/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneWayAnova {
    public double anovaFValue(Collection<double[]> collection) {
        AnovaStats anovaStats = this.anovaStats(collection);
        return anovaStats.F;
    }

    public double anovaPValue(Collection<double[]> collection) {
        AnovaStats anovaStats = this.anovaStats(collection);
        FDistribution fDistribution = new FDistribution(null, (double)anovaStats.dfbg, (double)anovaStats.dfwg);
        return 1.0 - fDistribution.cumulativeProbability(anovaStats.F);
    }

    public double anovaPValue(Collection<SummaryStatistics> collection, boolean bl) {
        AnovaStats anovaStats = this.anovaStats(collection, bl);
        FDistribution fDistribution = new FDistribution(null, (double)anovaStats.dfbg, (double)anovaStats.dfwg);
        return 1.0 - fDistribution.cumulativeProbability(anovaStats.F);
    }

    private AnovaStats anovaStats(Collection<double[]> collection) {
        MathUtils.checkNotNull(collection);
        ArrayList<SummaryStatistics> arrayList = new ArrayList<SummaryStatistics>(collection.size());
        for (double[] dArray : collection) {
            SummaryStatistics summaryStatistics = new SummaryStatistics();
            arrayList.add(summaryStatistics);
            for (double d : dArray) {
                summaryStatistics.addValue(d);
            }
        }
        return this.anovaStats(arrayList, false);
    }

    public boolean anovaTest(Collection<double[]> collection, double d) {
        if (d <= 0.0 || d > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)d, 0, 0.5);
        }
        return this.anovaPValue(collection) < d;
    }

    private AnovaStats anovaStats(Collection<SummaryStatistics> collection, boolean bl) {
        double d;
        double d2;
        MathUtils.checkNotNull(collection);
        if (!bl) {
            if (collection.size() < 2) {
                throw new DimensionMismatchException((Localizable)LocalizedFormats.TWO_OR_MORE_CATEGORIES_REQUIRED, collection.size(), 2);
            }
            for (SummaryStatistics summaryStatistics : collection) {
                if (summaryStatistics.getN() > 1L) continue;
                throw new DimensionMismatchException((Localizable)LocalizedFormats.TWO_OR_MORE_VALUES_IN_CATEGORY_REQUIRED, (int)summaryStatistics.getN(), 2);
            }
        }
        int n = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        for (SummaryStatistics summaryStatistics : collection) {
            d2 = summaryStatistics.getSum();
            double d6 = summaryStatistics.getSumsq();
            int n3 = (int)summaryStatistics.getN();
            n2 += n3;
            d4 += d2;
            d5 += d6;
            n += n3 - 1;
            d = d6 - d2 * d2 / (double)n3;
            d3 += d;
        }
        double d7 = d5 - d4 * d4 / (double)n2;
        d2 = d7 - d3;
        int n4 = collection.size() - 1;
        double d8 = d2 / (double)n4;
        d = d3 / (double)n;
        double d9 = d8 / d;
        return new AnovaStats(n4, n, d9);
    }

    private static class AnovaStats {
        private final int dfbg;
        private final int dfwg;
        private final double F;

        private AnovaStats(int n, int n2, double d) {
            this.dfbg = n;
            this.dfwg = n2;
            this.F = d;
        }
    }
}

