/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.util.FastMath;

public class TTest {
    public double pairedT(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        double d = StatUtils.meanDifference(dArray, dArray2);
        return this.t(d, 0.0, StatUtils.varianceDifference(dArray, dArray2, d), dArray.length);
    }

    public double pairedTTest(double[] dArray, double[] dArray2) {
        double d = StatUtils.meanDifference(dArray, dArray2);
        return this.tTest(d, 0.0, StatUtils.varianceDifference(dArray, dArray2, d), dArray.length);
    }

    public boolean pairedTTest(double[] dArray, double[] dArray2, double d) {
        this.checkSignificanceLevel(d);
        return this.pairedTTest(dArray, dArray2) < d;
    }

    public double t(double d, double[] dArray) {
        this.checkSampleData(dArray);
        return this.t(StatUtils.mean(dArray), d, StatUtils.variance(dArray), dArray.length);
    }

    public double t(double d, StatisticalSummary statisticalSummary) {
        this.checkSampleData(statisticalSummary);
        return this.t(statisticalSummary.getMean(), d, statisticalSummary.getVariance(), statisticalSummary.getN());
    }

    public double homoscedasticT(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        return this.homoscedasticT(StatUtils.mean(dArray), StatUtils.mean(dArray2), StatUtils.variance(dArray), StatUtils.variance(dArray2), dArray.length, dArray2.length);
    }

    public double t(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        return this.t(StatUtils.mean(dArray), StatUtils.mean(dArray2), StatUtils.variance(dArray), StatUtils.variance(dArray2), dArray.length, dArray2.length);
    }

    public double t(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) {
        this.checkSampleData(statisticalSummary);
        this.checkSampleData(statisticalSummary2);
        return this.t(statisticalSummary.getMean(), statisticalSummary2.getMean(), statisticalSummary.getVariance(), statisticalSummary2.getVariance(), statisticalSummary.getN(), statisticalSummary2.getN());
    }

    public double homoscedasticT(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) {
        this.checkSampleData(statisticalSummary);
        this.checkSampleData(statisticalSummary2);
        return this.homoscedasticT(statisticalSummary.getMean(), statisticalSummary2.getMean(), statisticalSummary.getVariance(), statisticalSummary2.getVariance(), statisticalSummary.getN(), statisticalSummary2.getN());
    }

    public double tTest(double d, double[] dArray) {
        this.checkSampleData(dArray);
        return this.tTest(StatUtils.mean(dArray), d, StatUtils.variance(dArray), dArray.length);
    }

    public boolean tTest(double d, double[] dArray, double d2) {
        this.checkSignificanceLevel(d2);
        return this.tTest(d, dArray) < d2;
    }

    public double tTest(double d, StatisticalSummary statisticalSummary) {
        this.checkSampleData(statisticalSummary);
        return this.tTest(statisticalSummary.getMean(), d, statisticalSummary.getVariance(), statisticalSummary.getN());
    }

    public boolean tTest(double d, StatisticalSummary statisticalSummary, double d2) {
        this.checkSignificanceLevel(d2);
        return this.tTest(d, statisticalSummary) < d2;
    }

    public double tTest(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        return this.tTest(StatUtils.mean(dArray), StatUtils.mean(dArray2), StatUtils.variance(dArray), StatUtils.variance(dArray2), dArray.length, dArray2.length);
    }

    public double homoscedasticTTest(double[] dArray, double[] dArray2) {
        this.checkSampleData(dArray);
        this.checkSampleData(dArray2);
        return this.homoscedasticTTest(StatUtils.mean(dArray), StatUtils.mean(dArray2), StatUtils.variance(dArray), StatUtils.variance(dArray2), dArray.length, dArray2.length);
    }

    public boolean tTest(double[] dArray, double[] dArray2, double d) {
        this.checkSignificanceLevel(d);
        return this.tTest(dArray, dArray2) < d;
    }

    public boolean homoscedasticTTest(double[] dArray, double[] dArray2, double d) {
        this.checkSignificanceLevel(d);
        return this.homoscedasticTTest(dArray, dArray2) < d;
    }

    public double tTest(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) {
        this.checkSampleData(statisticalSummary);
        this.checkSampleData(statisticalSummary2);
        return this.tTest(statisticalSummary.getMean(), statisticalSummary2.getMean(), statisticalSummary.getVariance(), statisticalSummary2.getVariance(), statisticalSummary.getN(), statisticalSummary2.getN());
    }

    public double homoscedasticTTest(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) {
        this.checkSampleData(statisticalSummary);
        this.checkSampleData(statisticalSummary2);
        return this.homoscedasticTTest(statisticalSummary.getMean(), statisticalSummary2.getMean(), statisticalSummary.getVariance(), statisticalSummary2.getVariance(), statisticalSummary.getN(), statisticalSummary2.getN());
    }

    public boolean tTest(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2, double d) {
        this.checkSignificanceLevel(d);
        return this.tTest(statisticalSummary, statisticalSummary2) < d;
    }

    protected double df(double d, double d2, double d3, double d4) {
        return (d / d3 + d2 / d4) * (d / d3 + d2 / d4) / (d * d / (d3 * d3 * (d3 - 1.0)) + d2 * d2 / (d4 * d4 * (d4 - 1.0)));
    }

    protected double t(double d, double d2, double d3, double d4) {
        return (d - d2) / FastMath.sqrt(d3 / d4);
    }

    protected double t(double d, double d2, double d3, double d4, double d5, double d6) {
        return (d - d2) / FastMath.sqrt(d3 / d5 + d4 / d6);
    }

    protected double homoscedasticT(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = ((d5 - 1.0) * d3 + (d6 - 1.0) * d4) / (d5 + d6 - 2.0);
        return (d - d2) / FastMath.sqrt(d7 * (1.0 / d5 + 1.0 / d6));
    }

    protected double tTest(double d, double d2, double d3, double d4) {
        double d5 = FastMath.abs(this.t(d, d2, d3, d4));
        TDistribution tDistribution = new TDistribution(null, d4 - 1.0);
        return 2.0 * tDistribution.cumulativeProbability(-d5);
    }

    protected double tTest(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = FastMath.abs(this.t(d, d2, d3, d4, d5, d6));
        double d8 = this.df(d3, d4, d5, d6);
        TDistribution tDistribution = new TDistribution(null, d8);
        return 2.0 * tDistribution.cumulativeProbability(-d7);
    }

    protected double homoscedasticTTest(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = FastMath.abs(this.homoscedasticT(d, d2, d3, d4, d5, d6));
        double d8 = d5 + d6 - 2.0;
        TDistribution tDistribution = new TDistribution(null, d8);
        return 2.0 * tDistribution.cumulativeProbability(-d7);
    }

    private void checkSignificanceLevel(double d) {
        if (d <= 0.0 || d > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.SIGNIFICANCE_LEVEL, (Number)d, 0.0, 0.5);
        }
    }

    private void checkSampleData(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_DATA_FOR_T_STATISTIC, (Number)dArray.length, 2, true);
        }
    }

    private void checkSampleData(StatisticalSummary statisticalSummary) {
        if (statisticalSummary == null) {
            throw new NullArgumentException();
        }
        if (statisticalSummary.getN() < 2L) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_DATA_FOR_T_STATISTIC, (Number)statisticalSummary.getN(), 2, true);
        }
    }
}

