/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.interval;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math3.stat.interval.ConfidenceInterval;
import org.apache.commons.math3.stat.interval.IntervalUtils;
import org.apache.commons.math3.util.FastMath;

public class NormalApproximationInterval
implements BinomialConfidenceInterval {
    public ConfidenceInterval createInterval(int n, int n2, double d) {
        IntervalUtils.checkParameters(n, n2, d);
        double d2 = (double)n2 / (double)n;
        double d3 = (1.0 - d) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution();
        double d4 = normalDistribution.inverseCumulativeProbability(1.0 - d3) * FastMath.sqrt(1.0 / (double)n * d2 * (1.0 - d2));
        return new ConfidenceInterval(d2 - d4, d2 + d4, d);
    }
}

