/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.regression;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.regression.AbstractMultipleLinearRegression;

public class GLSMultipleLinearRegression
extends AbstractMultipleLinearRegression {
    private RealMatrix Omega;
    private RealMatrix OmegaInverse;

    public void newSampleData(double[] dArray, double[][] dArray2, double[][] dArray3) {
        this.validateSampleData(dArray2, dArray);
        this.newYSampleData(dArray);
        this.newXSampleData(dArray2);
        this.validateCovarianceData(dArray2, dArray3);
        this.newCovarianceData(dArray3);
    }

    protected void newCovarianceData(double[][] dArray) {
        this.Omega = new Array2DRowRealMatrix(dArray);
        this.OmegaInverse = null;
    }

    protected RealMatrix getOmegaInverse() {
        if (this.OmegaInverse == null) {
            this.OmegaInverse = new LUDecomposition(this.Omega).getSolver().getInverse();
        }
        return this.OmegaInverse;
    }

    protected RealVector calculateBeta() {
        RealMatrix realMatrix = this.getOmegaInverse();
        RealMatrix realMatrix2 = this.getX().transpose();
        RealMatrix realMatrix3 = realMatrix2.multiply(realMatrix).multiply(this.getX());
        RealMatrix realMatrix4 = new LUDecomposition(realMatrix3).getSolver().getInverse();
        return realMatrix4.multiply(realMatrix2).multiply(realMatrix).operate(this.getY());
    }

    protected RealMatrix calculateBetaVariance() {
        RealMatrix realMatrix = this.getOmegaInverse();
        RealMatrix realMatrix2 = this.getX().transpose().multiply(realMatrix).multiply(this.getX());
        return new LUDecomposition(realMatrix2).getSolver().getInverse();
    }

    protected double calculateErrorVariance() {
        RealVector realVector = this.calculateResiduals();
        double d = realVector.dotProduct(this.getOmegaInverse().operate(realVector));
        return d / (double)(this.getX().getRowDimension() - this.getX().getColumnDimension());
    }
}

