/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.regression;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math3.stat.regression.AbstractMultipleLinearRegression;

public class OLSMultipleLinearRegression
extends AbstractMultipleLinearRegression {
    private QRDecomposition qr = null;
    private final double threshold;

    public OLSMultipleLinearRegression() {
        this(0.0);
    }

    public OLSMultipleLinearRegression(double d) {
        this.threshold = d;
    }

    public void newSampleData(double[] dArray, double[][] dArray2) {
        this.validateSampleData(dArray2, dArray);
        this.newYSampleData(dArray);
        this.newXSampleData(dArray2);
    }

    public void newSampleData(double[] dArray, int n, int n2) {
        super.newSampleData(dArray, n, n2);
        this.qr = new QRDecomposition(this.getX(), this.threshold);
    }

    public RealMatrix calculateHat() {
        RealMatrix realMatrix = this.qr.getQ();
        int n = this.qr.getR().getColumnDimension();
        int n2 = realMatrix.getColumnDimension();
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n2, n2);
        double[][] dArray = array2DRowRealMatrix.getDataRef();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = i == j && i < n ? 1.0 : 0.0;
            }
        }
        return realMatrix.multiply(array2DRowRealMatrix).multiply(realMatrix.transpose());
    }

    public double calculateTotalSumOfSquares() {
        if (this.isNoIntercept()) {
            return StatUtils.sumSq(this.getY().toArray());
        }
        return new SecondMoment().evaluate(this.getY().toArray());
    }

    public double calculateResidualSumOfSquares() {
        RealVector realVector = this.calculateResiduals();
        return realVector.dotProduct(realVector);
    }

    public double calculateRSquared() {
        return 1.0 - this.calculateResidualSumOfSquares() / this.calculateTotalSumOfSquares();
    }

    public double calculateAdjustedRSquared() {
        double d = this.getX().getRowDimension();
        if (this.isNoIntercept()) {
            return 1.0 - (1.0 - this.calculateRSquared()) * (d / (d - (double)this.getX().getColumnDimension()));
        }
        return 1.0 - this.calculateResidualSumOfSquares() * (d - 1.0) / (this.calculateTotalSumOfSquares() * (d - (double)this.getX().getColumnDimension()));
    }

    protected void newXSampleData(double[][] dArray) {
        super.newXSampleData(dArray);
        this.qr = new QRDecomposition(this.getX(), this.threshold);
    }

    protected RealVector calculateBeta() {
        return this.qr.getSolver().solve(this.getY());
    }

    protected RealMatrix calculateBetaVariance() {
        int n = this.getX().getColumnDimension();
        RealMatrix realMatrix = this.qr.getR().getSubMatrix(0, n - 1, 0, n - 1);
        RealMatrix realMatrix2 = new LUDecomposition(realMatrix).getSolver().getInverse();
        return realMatrix2.multiply(realMatrix2.transpose());
    }
}

