/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.transform;

import java.io.Serializable;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.transform.DctNormalization;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.RealTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.transform.TransformUtils;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;

public class FastCosineTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120212L;
    private final DctNormalization normalization;

    public FastCosineTransformer(DctNormalization dctNormalization) {
        this.normalization = dctNormalization;
    }

    public double[] transform(double[] dArray, TransformType transformType) {
        if (transformType == TransformType.FORWARD) {
            if (this.normalization == DctNormalization.ORTHOGONAL_DCT_I) {
                double d = FastMath.sqrt(2.0 / (double)(dArray.length - 1));
                return TransformUtils.scaleArray(this.fct(dArray), d);
            }
            return this.fct(dArray);
        }
        double d = 2.0 / (double)(dArray.length - 1);
        double d2 = this.normalization == DctNormalization.ORTHOGONAL_DCT_I ? FastMath.sqrt(d) : d;
        return TransformUtils.scaleArray(this.fct(dArray), d2);
    }

    public double[] transform(UnivariateFunction univariateFunction, double d, double d2, int n, TransformType transformType) {
        double[] dArray = FunctionUtils.sample(univariateFunction, d, d2, n);
        return this.transform(dArray, transformType);
    }

    protected double[] fct(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = dArray.length - 1;
        if (!ArithmeticUtils.isPowerOfTwo(n)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_PLUS_ONE, dArray.length);
        }
        if (n == 1) {
            dArray2[0] = 0.5 * (dArray[0] + dArray[1]);
            dArray2[1] = 0.5 * (dArray[0] - dArray[1]);
            return dArray2;
        }
        double[] dArray3 = new double[n];
        dArray3[0] = 0.5 * (dArray[0] + dArray[n]);
        dArray3[n >> 1] = dArray[n >> 1];
        double d = 0.5 * (dArray[0] - dArray[n]);
        for (int i = 1; i < n >> 1; ++i) {
            double d2 = 0.5 * (dArray[i] + dArray[n - i]);
            double d3 = FastMath.sin((double)i * Math.PI / (double)n) * (dArray[i] - dArray[n - i]);
            double d4 = FastMath.cos((double)i * Math.PI / (double)n) * (dArray[i] - dArray[n - i]);
            dArray3[i] = d2 - d3;
            dArray3[n - i] = d2 + d3;
            d += d4;
        }
        FastFourierTransformer fastFourierTransformer = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] complexArray = fastFourierTransformer.transform(dArray3, TransformType.FORWARD);
        dArray2[0] = complexArray[0].getReal();
        dArray2[1] = d;
        for (int i = 1; i < n >> 1; ++i) {
            dArray2[2 * i] = complexArray[i].getReal();
            dArray2[2 * i + 1] = dArray2[2 * i - 1] - complexArray[i].getImaginary();
        }
        dArray2[n] = complexArray[n >> 1].getReal();
        return dArray2;
    }
}

