/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.transform;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.transform.TransformUtils;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class FastFourierTransformer
implements Serializable {
    static final long serialVersionUID = 20120210L;
    private static final double[] W_SUB_N_R = new double[]{1.0, -1.0, 6.123233995736766E-17, 0.7071067811865476, 0.9238795325112867, 0.9807852804032304, 0.9951847266721969, 0.9987954562051724, 0.9996988186962042, 0.9999247018391445, 0.9999811752826011, 0.9999952938095762, 0.9999988234517019, 0.9999997058628822, 0.9999999264657179, 0.9999999816164293, 0.9999999954041073, 0.9999999988510269, 0.9999999997127567, 0.9999999999281892, 0.9999999999820472, 0.9999999999955118, 0.999999999998878, 0.9999999999997194, 0.9999999999999298, 0.9999999999999825, 0.9999999999999957, 0.9999999999999989, 0.9999999999999998, 0.9999999999999999, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private static final double[] W_SUB_N_I = new double[]{2.4492935982947064E-16, -1.2246467991473532E-16, -1.0, -0.7071067811865475, -0.3826834323650898, -0.19509032201612825, -0.0980171403295606, -0.049067674327418015, -0.024541228522912288, -0.012271538285719925, -0.006135884649154475, -0.003067956762965976, -0.0015339801862847655, -7.669903187427045E-4, -3.8349518757139556E-4, -1.917475973107033E-4, -9.587379909597734E-5, -4.793689960306688E-5, -2.396844980841822E-5, -1.1984224905069705E-5, -5.9921124526424275E-6, -2.996056226334661E-6, -1.4980281131690111E-6, -7.490140565847157E-7, -3.7450702829238413E-7, -1.8725351414619535E-7, -9.362675707309808E-8, -4.681337853654909E-8, -2.340668926827455E-8, -1.1703344634137277E-8, -5.8516723170686385E-9, -2.9258361585343192E-9, -1.4629180792671596E-9, -7.314590396335798E-10, -3.657295198167899E-10, -1.8286475990839495E-10, -9.143237995419748E-11, -4.571618997709874E-11, -2.285809498854937E-11, -1.1429047494274685E-11, -5.714523747137342E-12, -2.857261873568671E-12, -1.4286309367843356E-12, -7.143154683921678E-13, -3.571577341960839E-13, -1.7857886709804195E-13, -8.928943354902097E-14, -4.4644716774510487E-14, -2.2322358387255243E-14, -1.1161179193627622E-14, -5.580589596813811E-15, -2.7902947984069054E-15, -1.3951473992034527E-15, -6.975736996017264E-16, -3.487868498008632E-16, -1.743934249004316E-16, -8.71967124502158E-17, -4.35983562251079E-17, -2.179917811255395E-17, -1.0899589056276974E-17, -5.449794528138487E-18, -2.7248972640692436E-18, -1.3624486320346218E-18};
    private final DftNormalization normalization;

    public FastFourierTransformer(DftNormalization dftNormalization) {
        this.normalization = dftNormalization;
    }

    private static void bitReversalShuffle2(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        assert (dArray2.length == n);
        int n2 = n >> 1;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            if (i < n3) {
                double d = dArray[i];
                dArray[i] = dArray[n3];
                dArray[n3] = d;
                d = dArray2[i];
                dArray2[i] = dArray2[n3];
                dArray2[n3] = d;
            }
            for (n4 = n2; n4 <= n3 && n4 > 0; n3 -= n4, n4 >>= 1) {
            }
            n3 += n4;
        }
    }

    private static void normalizeTransformedData(double[][] dArray, DftNormalization dftNormalization, TransformType transformType) {
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        int n = dArray2.length;
        assert (dArray3.length == n);
        switch (dftNormalization) {
            case STANDARD: {
                if (transformType != TransformType.INVERSE) break;
                double d = 1.0 / (double)n;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = n2;
                    dArray2[n3] = dArray2[n3] * d;
                    int n4 = n2++;
                    dArray3[n4] = dArray3[n4] * d;
                }
                break;
            }
            case UNITARY: {
                double d = 1.0 / FastMath.sqrt(n);
                int n5 = 0;
                while (n5 < n) {
                    int n6 = n5;
                    dArray2[n6] = dArray2[n6] * d;
                    int n7 = n5++;
                    dArray3[n7] = dArray3[n7] * d;
                }
                break;
            }
            default: {
                throw new MathIllegalStateException();
            }
        }
    }

    public static void transformInPlace(double[][] dArray, DftNormalization dftNormalization, TransformType transformType) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n;
        int n2;
        int n3;
        int n4;
        if (dArray.length != 2) {
            throw new DimensionMismatchException(dArray.length, 2);
        }
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        if (dArray2.length != dArray3.length) {
            throw new DimensionMismatchException(dArray3.length, dArray2.length);
        }
        int n5 = dArray2.length;
        if (!ArithmeticUtils.isPowerOfTwo(n5)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, n5);
        }
        if (n5 == 1) {
            return;
        }
        if (n5 == 2) {
            double d9 = dArray2[0];
            double d10 = dArray3[0];
            double d11 = dArray2[1];
            double d12 = dArray3[1];
            dArray2[0] = d9 + d11;
            dArray3[0] = d10 + d12;
            dArray2[1] = d9 - d11;
            dArray3[1] = d10 - d12;
            FastFourierTransformer.normalizeTransformedData(dArray, dftNormalization, transformType);
            return;
        }
        FastFourierTransformer.bitReversalShuffle2(dArray2, dArray3);
        if (transformType == TransformType.INVERSE) {
            for (n4 = 0; n4 < n5; n4 += 4) {
                n3 = n4 + 1;
                n2 = n4 + 2;
                n = n4 + 3;
                d8 = dArray2[n4];
                d7 = dArray3[n4];
                d6 = dArray2[n2];
                d5 = dArray3[n2];
                d4 = dArray2[n3];
                d3 = dArray3[n3];
                d2 = dArray2[n];
                d = dArray3[n];
                dArray2[n4] = d8 + d6 + d4 + d2;
                dArray3[n4] = d7 + d5 + d3 + d;
                dArray2[n3] = d8 - d4 + (d - d5);
                dArray3[n3] = d7 - d3 + (d6 - d2);
                dArray2[n2] = d8 - d6 + d4 - d2;
                dArray3[n2] = d7 - d5 + d3 - d;
                dArray2[n] = d8 - d4 + (d5 - d);
                dArray3[n] = d7 - d3 + (d2 - d6);
            }
        } else {
            for (n4 = 0; n4 < n5; n4 += 4) {
                n3 = n4 + 1;
                n2 = n4 + 2;
                n = n4 + 3;
                d8 = dArray2[n4];
                d7 = dArray3[n4];
                d6 = dArray2[n2];
                d5 = dArray3[n2];
                d4 = dArray2[n3];
                d3 = dArray3[n3];
                d2 = dArray2[n];
                d = dArray3[n];
                dArray2[n4] = d8 + d6 + d4 + d2;
                dArray3[n4] = d7 + d5 + d3 + d;
                dArray2[n3] = d8 - d4 + (d5 - d);
                dArray3[n3] = d7 - d3 + (d2 - d6);
                dArray2[n2] = d8 - d6 + d4 - d2;
                dArray3[n2] = d7 - d5 + d3 - d;
                dArray2[n] = d8 - d4 + (d - d5);
                dArray3[n] = d7 - d3 + (d6 - d2);
            }
        }
        n4 = 4;
        n3 = 2;
        while (n4 < n5) {
            n2 = n4 << 1;
            n = n3 + 1;
            d8 = W_SUB_N_R[n];
            d7 = W_SUB_N_I[n];
            if (transformType == TransformType.INVERSE) {
                d7 = -d7;
            }
            for (int i = 0; i < n5; i += n2) {
                int n6 = i + n4;
                d5 = 1.0;
                d4 = 0.0;
                for (int j = 0; j < n4; ++j) {
                    double d13 = dArray2[i + j];
                    double d14 = dArray3[i + j];
                    double d15 = dArray2[n6 + j];
                    double d16 = dArray3[n6 + j];
                    dArray2[i + j] = d13 + d5 * d15 - d4 * d16;
                    dArray3[i + j] = d14 + d5 * d16 + d4 * d15;
                    dArray2[n6 + j] = d13 - (d5 * d15 - d4 * d16);
                    dArray3[n6 + j] = d14 - (d5 * d16 + d4 * d15);
                    double d17 = d5 * d8 - d4 * d7;
                    double d18 = d5 * d7 + d4 * d8;
                    d5 = d17;
                    d4 = d18;
                }
            }
            n4 = n2;
            n3 = n;
        }
        FastFourierTransformer.normalizeTransformedData(dArray, dftNormalization, transformType);
    }

    public Complex[] transform(double[] dArray, TransformType transformType) {
        double[][] dArrayArray = new double[][]{MathArrays.copyOf(dArray, dArray.length), new double[dArray.length]};
        FastFourierTransformer.transformInPlace(dArrayArray, this.normalization, transformType);
        return TransformUtils.createComplexArray(dArrayArray);
    }

    public Complex[] transform(UnivariateFunction univariateFunction, double d, double d2, int n, TransformType transformType) {
        double[] dArray = FunctionUtils.sample(univariateFunction, d, d2, n);
        return this.transform(dArray, transformType);
    }

    public Complex[] transform(Complex[] complexArray, TransformType transformType) {
        double[][] dArray = TransformUtils.createRealImaginaryArray(complexArray);
        FastFourierTransformer.transformInPlace(dArray, this.normalization, transformType);
        return TransformUtils.createComplexArray(dArray);
    }

    @Deprecated
    public Object mdfft(Object object, TransformType transformType) {
        MultiDimensionalComplexMatrix multiDimensionalComplexMatrix = (MultiDimensionalComplexMatrix)new MultiDimensionalComplexMatrix(object).clone();
        int[] nArray = multiDimensionalComplexMatrix.getDimensionSizes();
        for (int i = 0; i < nArray.length; ++i) {
            this.mdfft(multiDimensionalComplexMatrix, transformType, i, new int[0]);
        }
        return multiDimensionalComplexMatrix.getArray();
    }

    @Deprecated
    private void mdfft(MultiDimensionalComplexMatrix multiDimensionalComplexMatrix, TransformType transformType, int n, int[] nArray) {
        int[] nArray2 = multiDimensionalComplexMatrix.getDimensionSizes();
        if (nArray.length == nArray2.length) {
            int n2;
            Complex[] complexArray = new Complex[nArray2[n]];
            for (n2 = 0; n2 < nArray2[n]; ++n2) {
                nArray[n] = n2;
                complexArray[n2] = multiDimensionalComplexMatrix.get(nArray);
            }
            complexArray = this.transform(complexArray, transformType);
            for (n2 = 0; n2 < nArray2[n]; ++n2) {
                nArray[n] = n2;
                multiDimensionalComplexMatrix.set(complexArray[n2], nArray);
            }
        } else {
            int[] nArray3 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            if (nArray.length == n) {
                nArray3[n] = 0;
                this.mdfft(multiDimensionalComplexMatrix, transformType, n, nArray3);
            } else {
                int n3 = 0;
                while (n3 < nArray2[nArray.length]) {
                    nArray3[nArray.length] = n3++;
                    this.mdfft(multiDimensionalComplexMatrix, transformType, n, nArray3);
                }
            }
        }
    }

    @Deprecated
    private static class MultiDimensionalComplexMatrix
    implements Cloneable {
        protected int[] dimensionSize;
        protected Object multiDimensionalComplexArray;

        MultiDimensionalComplexMatrix(Object object) {
            Object[] objectArray;
            this.multiDimensionalComplexArray = object;
            int n = 0;
            Object object2 = object;
            while (object2 instanceof Object[]) {
                objectArray = (Object[])object2;
                ++n;
                object2 = objectArray[0];
            }
            this.dimensionSize = new int[n];
            n = 0;
            object2 = object;
            while (object2 instanceof Object[]) {
                objectArray = (Object[])object2;
                this.dimensionSize[n++] = objectArray.length;
                object2 = objectArray[0];
            }
        }

        public Complex get(int ... nArray) {
            if (nArray == null) {
                if (this.dimensionSize.length > 0) {
                    throw new DimensionMismatchException(0, this.dimensionSize.length);
                }
                return null;
            }
            if (nArray.length != this.dimensionSize.length) {
                throw new DimensionMismatchException(nArray.length, this.dimensionSize.length);
            }
            Object object = this.multiDimensionalComplexArray;
            for (int i = 0; i < this.dimensionSize.length; ++i) {
                object = ((Object[])object)[nArray[i]];
            }
            return (Complex)object;
        }

        public Complex set(Complex complex, int ... nArray) {
            if (nArray == null) {
                if (this.dimensionSize.length > 0) {
                    throw new DimensionMismatchException(0, this.dimensionSize.length);
                }
                return null;
            }
            if (nArray.length != this.dimensionSize.length) {
                throw new DimensionMismatchException(nArray.length, this.dimensionSize.length);
            }
            Object[] objectArray = (Object[])this.multiDimensionalComplexArray;
            for (int i = 0; i < this.dimensionSize.length - 1; ++i) {
                objectArray = (Object[])objectArray[nArray[i]];
            }
            Complex complex2 = (Complex)objectArray[nArray[this.dimensionSize.length - 1]];
            objectArray[nArray[this.dimensionSize.length - 1]] = complex;
            return complex2;
        }

        public int[] getDimensionSizes() {
            return (int[])this.dimensionSize.clone();
        }

        public Object getArray() {
            return this.multiDimensionalComplexArray;
        }

        public Object clone() {
            MultiDimensionalComplexMatrix multiDimensionalComplexMatrix = new MultiDimensionalComplexMatrix(Array.newInstance(Complex.class, this.dimensionSize));
            this.clone(multiDimensionalComplexMatrix);
            return multiDimensionalComplexMatrix;
        }

        private void clone(MultiDimensionalComplexMatrix multiDimensionalComplexMatrix) {
            int[][] nArray;
            int[] nArray2 = new int[this.dimensionSize.length];
            int n = 1;
            for (int i = 0; i < this.dimensionSize.length; ++i) {
                n *= this.dimensionSize[i];
            }
            block1: for (int[] nArray3 : nArray = new int[n][this.dimensionSize.length]) {
                System.arraycopy(nArray2, 0, nArray3, 0, this.dimensionSize.length);
                for (int i = 0; i < this.dimensionSize.length; ++i) {
                    int n2 = i;
                    nArray2[n2] = nArray2[n2] + 1;
                    if (nArray2[i] < this.dimensionSize[i]) continue block1;
                    nArray2[i] = 0;
                }
            }
            for (int[] nArray3 : nArray) {
                multiDimensionalComplexMatrix.set(this.get(nArray3), nArray3);
            }
        }
    }
}

