/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.transform;

import java.io.Serializable;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.transform.RealTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.transform.TransformUtils;
import org.apache.commons.math3.util.ArithmeticUtils;

public class FastHadamardTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120211L;

    public double[] transform(double[] dArray, TransformType transformType) {
        if (transformType == TransformType.FORWARD) {
            return this.fht(dArray);
        }
        return TransformUtils.scaleArray(this.fht(dArray), 1.0 / (double)dArray.length);
    }

    public double[] transform(UnivariateFunction univariateFunction, double d, double d2, int n, TransformType transformType) {
        return this.transform(FunctionUtils.sample(univariateFunction, d, d2, n), transformType);
    }

    public int[] transform(int[] nArray) {
        return this.fht(nArray);
    }

    protected double[] fht(double[] dArray) {
        int n = dArray.length;
        int n2 = n / 2;
        if (!ArithmeticUtils.isPowerOfTwo(n)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n);
        }
        double[] dArray2 = new double[n];
        double[] dArray3 = (double[])dArray.clone();
        for (int i = 1; i < n; i <<= 1) {
            int n3;
            int n4;
            double[] dArray4 = dArray3;
            dArray3 = dArray2;
            dArray2 = dArray4;
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = 2 * n4;
                dArray3[n4] = dArray2[n3] + dArray2[n3 + 1];
            }
            for (n4 = n2; n4 < n; ++n4) {
                n3 = 2 * n4;
                dArray3[n4] = dArray2[n3 - n] - dArray2[n3 - n + 1];
            }
        }
        return dArray3;
    }

    protected int[] fht(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        if (!ArithmeticUtils.isPowerOfTwo(n)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n);
        }
        int[] nArray2 = new int[n];
        int[] nArray3 = (int[])nArray.clone();
        for (int i = 1; i < n; i <<= 1) {
            int n3;
            int n4;
            int[] nArray4 = nArray3;
            nArray3 = nArray2;
            nArray2 = nArray4;
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = 2 * n4;
                nArray3[n4] = nArray2[n3] + nArray2[n3 + 1];
            }
            for (n4 = n2; n4 < n; ++n4) {
                n3 = 2 * n4;
                nArray3[n4] = nArray2[n3 - n] - nArray2[n3 - n + 1];
            }
        }
        return nArray3;
    }
}

