/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.transform;

import java.io.Serializable;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.DstNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.RealTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.transform.TransformUtils;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;

public class FastSineTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120211L;
    private final DstNormalization normalization;

    public FastSineTransformer(DstNormalization dstNormalization) {
        this.normalization = dstNormalization;
    }

    public double[] transform(double[] dArray, TransformType transformType) {
        if (this.normalization == DstNormalization.ORTHOGONAL_DST_I) {
            double d = FastMath.sqrt(2.0 / (double)dArray.length);
            return TransformUtils.scaleArray(this.fst(dArray), d);
        }
        if (transformType == TransformType.FORWARD) {
            return this.fst(dArray);
        }
        double d = 2.0 / (double)dArray.length;
        return TransformUtils.scaleArray(this.fst(dArray), d);
    }

    public double[] transform(UnivariateFunction univariateFunction, double d, double d2, int n, TransformType transformType) {
        double[] dArray = FunctionUtils.sample(univariateFunction, d, d2, n);
        dArray[0] = 0.0;
        return this.transform(dArray, transformType);
    }

    protected double[] fst(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        if (!ArithmeticUtils.isPowerOfTwo(dArray.length)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, dArray.length);
        }
        if (dArray[0] != 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.FIRST_ELEMENT_NOT_ZERO, dArray[0]);
        }
        int n = dArray.length;
        if (n == 1) {
            dArray2[0] = 0.0;
            return dArray2;
        }
        double[] dArray3 = new double[n];
        dArray3[0] = 0.0;
        dArray3[n >> 1] = 2.0 * dArray[n >> 1];
        for (int i = 1; i < n >> 1; ++i) {
            double d = FastMath.sin((double)i * Math.PI / (double)n) * (dArray[i] + dArray[n - i]);
            double d2 = 0.5 * (dArray[i] - dArray[n - i]);
            dArray3[i] = d + d2;
            dArray3[n - i] = d - d2;
        }
        FastFourierTransformer fastFourierTransformer = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] complexArray = fastFourierTransformer.transform(dArray3, TransformType.FORWARD);
        dArray2[0] = 0.0;
        dArray2[1] = 0.5 * complexArray[0].getReal();
        for (int i = 1; i < n >> 1; ++i) {
            dArray2[2 * i] = -complexArray[i].getImaginary();
            dArray2[2 * i + 1] = complexArray[i].getReal() + dArray2[2 * i - 1];
        }
        return dArray2;
    }
}

