/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class CompositeFormat {
    private CompositeFormat() {
    }

    public static NumberFormat getDefaultNumberFormat() {
        return CompositeFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    public static NumberFormat getDefaultNumberFormat(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(10);
        return numberFormat;
    }

    public static void parseAndIgnoreWhitespace(String string, ParsePosition parsePosition) {
        CompositeFormat.parseNextCharacter(string, parsePosition);
        parsePosition.setIndex(parsePosition.getIndex() - 1);
    }

    public static char parseNextCharacter(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = string.length();
        char c = '\u0000';
        if (n < n2) {
            char c2;
            while (Character.isWhitespace(c2 = string.charAt(n++)) && n < n2) {
            }
            parsePosition.setIndex(n);
            if (n < n2) {
                c = c2;
            }
        }
        return c;
    }

    private static Number parseNumber(String string, double d, ParsePosition parsePosition) {
        Double d2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(d);
        stringBuilder.append(')');
        int n = stringBuilder.length();
        int n2 = parsePosition.getIndex();
        int n3 = n2 + n;
        if (n3 < string.length() && string.substring(n2, n3).compareTo(stringBuilder.toString()) == 0) {
            d2 = d;
            parsePosition.setIndex(n3);
        }
        return d2;
    }

    public static Number parseNumber(String string, NumberFormat numberFormat, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        Number number = numberFormat.parse(string, parsePosition);
        int n2 = parsePosition.getIndex();
        if (n == n2) {
            double[] dArray = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
            for (int i = 0; i < dArray.length && (number = CompositeFormat.parseNumber(string, dArray[i], parsePosition)) == null; ++i) {
            }
        }
        return number;
    }

    public static boolean parseFixedstring(String string, String string2, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = n + string2.length();
        if (n >= string.length() || n2 > string.length() || string.substring(n, n2).compareTo(string2) != 0) {
            parsePosition.setIndex(n);
            parsePosition.setErrorIndex(n);
            return false;
        }
        parsePosition.setIndex(n2);
        return true;
    }

    public static StringBuffer formatDouble(double d, NumberFormat numberFormat, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            stringBuffer.append('(');
            stringBuffer.append(d);
            stringBuffer.append(')');
        } else {
            numberFormat.format(d, stringBuffer, fieldPosition);
        }
        return stringBuffer;
    }
}

