/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.util.NoSuchElementException;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultidimensionalCounter
implements Iterable<Integer> {
    private final int dimension;
    private final int[] uniCounterOffset;
    private final int[] size;
    private final int totalSize;
    private final int last;

    public MultidimensionalCounter(int ... nArray) {
        this.dimension = nArray.length;
        this.size = MathArrays.copyOf(nArray);
        this.uniCounterOffset = new int[this.dimension];
        this.last = this.dimension - 1;
        int n = nArray[this.last];
        for (int i = 0; i < this.last; ++i) {
            int n2 = 1;
            for (int j = i + 1; j < this.dimension; ++j) {
                n2 *= nArray[j];
            }
            this.uniCounterOffset[i] = n2;
            n *= nArray[i];
        }
        this.uniCounterOffset[this.last] = 0;
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.totalSize = n;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public int getDimension() {
        return this.dimension;
    }

    public int[] getCounts(int n) {
        if (n < 0 || n >= this.totalSize) {
            throw new OutOfRangeException(n, (Number)0, this.totalSize);
        }
        int[] nArray = new int[this.dimension];
        int n2 = 0;
        for (int i = 0; i < this.last; ++i) {
            int n3 = 0;
            int n4 = this.uniCounterOffset[i];
            while (n2 <= n) {
                n2 += n4;
                ++n3;
            }
            n2 -= n4;
            nArray[i] = --n3;
        }
        nArray[this.last] = n - n2;
        return nArray;
    }

    public int getCount(int ... nArray) {
        if (nArray.length != this.dimension) {
            throw new DimensionMismatchException(nArray.length, this.dimension);
        }
        int n = 0;
        for (int i = 0; i < this.dimension; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || n2 >= this.size[i]) {
                throw new OutOfRangeException(n2, (Number)0, this.size[i] - 1);
            }
            n += this.uniCounterOffset[i] * nArray[i];
        }
        return n + nArray[this.last];
    }

    public int getSize() {
        return this.totalSize;
    }

    public int[] getSizes() {
        return MathArrays.copyOf(this.size);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.dimension) {
            stringBuilder.append("[").append(this.getCount(n++)).append("]");
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements java.util.Iterator<Integer> {
        private final int[] counter;
        private int count;
        private final int maxCount;

        Iterator() {
            this.counter = new int[MultidimensionalCounter.this.dimension];
            this.count = -1;
            this.maxCount = MultidimensionalCounter.this.totalSize - 1;
            this.counter[((MultidimensionalCounter)MultidimensionalCounter.this).last] = -1;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.maxCount;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            for (int i = MultidimensionalCounter.this.last; i >= 0; --i) {
                if (this.counter[i] != MultidimensionalCounter.this.size[i] - 1) {
                    int n = i;
                    this.counter[n] = this.counter[n] + 1;
                    break;
                }
                this.counter[i] = 0;
            }
            return ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public int[] getCounts() {
            return MathArrays.copyOf(this.counter);
        }

        public int getCount(int n) {
            return this.counter[n];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

