/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pair<K, V> {
    private final K key;
    private final V value;

    public Pair(K k, V v) {
        this.key = k;
        this.value = v;
    }

    public Pair(Pair<? extends K, ? extends V> pair) {
        this(pair.getKey(), pair.getValue());
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public K getFirst() {
        return this.key;
    }

    public V getSecond() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)object;
        return (this.key == null ? pair.key == null : this.key.equals(pair.key)) && (this.value == null ? pair.value == null : this.value.equals(pair.value));
    }

    public int hashCode() {
        int n = this.key == null ? 0 : this.key.hashCode();
        int n2 = this.value == null ? 0 : this.value.hashCode();
        n = 37 * n + n2 ^ n2 >>> 16;
        return n;
    }

    public String toString() {
        return "[" + this.getKey() + ", " + this.getValue() + "]";
    }

    public static <K, V> Pair<K, V> create(K k, V v) {
        return new Pair<K, V>(k, v);
    }
}

