/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.command.sell;

import java.util.Optional;
import net.brcdev.shopgui.command.sell.CmdSellSubcommand;
import net.brcdev.shopgui.config.Lang;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.core.BSubCommand;
import net.brcdev.shopgui.database.Callback;
import net.brcdev.shopgui.player.PlayerData;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.util.InventoryUtils;
import net.brcdev.shopgui.util.NumberUtils;
import org.bukkit.inventory.ItemStack;

public class CmdSellHand
extends CmdSellSubcommand {
    public CmdSellHand() {
        this.aliases.add("hand");
        this.aliases.add("h");
        this.correctUsage = "/sell hand [quantity]";
        this.permission = "shopguiplus.sell.hand";
        this.senderMustBePlayer = true;
    }

    @Override
    public void execute() {
        Optional<BSubCommand> optional;
        if (Settings.sellHandSellsAllItems && (optional = this.main.getCmdSell().findSubcommand("handall")).isPresent()) {
            optional.get().execute(this.sender, this.args, false);
            return;
        }
        if (this.assertPlayerInAllowedGamemode()) {
            return;
        }
        if (this.assertPlayerInAllowedWorld()) {
            return;
        }
        if (this.assertPlayerHasItemInHand()) {
            return;
        }
        this.main.getPlayerManager().handlePlayerData(this.player, new Callback<PlayerData>(){

            @Override
            public void onSuccess(PlayerData playerData) {
                Object object;
                ItemStack itemStack = InventoryUtils.getItemInPlayersMainHand(CmdSellHand.this.player);
                int n = itemStack.getAmount();
                if (CmdSellHand.this.args.length > 0) {
                    object = CmdSellHand.this.args[0];
                    if (!NumberUtils.isPositiveInteger((String)object) || Integer.valueOf((String)object) < 1 || Integer.valueOf((String)object) > itemStack.getAmount()) {
                        CmdSellHand.this.msg(Lang.MSG_SELLHAND_INVALIDQUANTITY.toMsg().replace("%max%", String.valueOf(itemStack.getAmount())));
                        return;
                    }
                    n = Integer.valueOf((String)object);
                }
                if ((object = CmdSellHand.this.main.getShopManager().findShopItemByItemStack(CmdSellHand.this.player, playerData, itemStack, Settings.sellHandExcludeFreeItems)) == null) {
                    CmdSellHand.this.msg(Lang.MSG_SELLHAND_CANNOTSELL.toMsg());
                    return;
                }
                if (!Settings.sellHandAllowAllQuantities && itemStack.getAmount() % n > 0) {
                    CmdSellHand.this.msg(Lang.MSG_SELLHAND_MULTIPLEQUANTITYONLY.toMsg().replace("%quantity%", String.valueOf(itemStack.getAmount())));
                    return;
                }
                CmdSellHand.this.main.getShopManager().handleItemSellHand(CmdSellHand.this.player, (ShopItem)object, n, true, true);
            }

            @Override
            public void onFailure(PlayerData playerData) {
                CmdSellHand.this.msg(Lang.MSG_ERROR.toMsg());
            }
        });
    }
}

