/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.modifier.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.exception.modifier.ModifierFindAlternativeInvalidTypeException;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.modifier.PriceModifierScope;
import net.brcdev.shopgui.modifier.permission.PermissionPriceModifier;
import net.brcdev.shopgui.permission.PermissionManager;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class PermissionPriceModifierManager {
    private ShopGuiPlugin main;
    private List<PermissionPriceModifier> permissionPriceModifiers = new ArrayList<PermissionPriceModifier>();

    public PermissionPriceModifierManager(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
    }

    public List<PermissionPriceModifier> getPermissionPriceModifiers() {
        return this.permissionPriceModifiers;
    }

    public void loadPermissionPriceModifiers() {
        this.permissionPriceModifiers.clear();
        ConfigurationSection configurationSection = this.main.getConfigPriceModifiers().getConfig().getConfigurationSection("priceModifiers");
        if (configurationSection != null) {
            for (String string : configurationSection.getKeys(false)) {
                double d;
                PriceModifierActionType priceModifierActionType;
                PriceModifierScope priceModifierScope;
                String string2;
                String string3;
                block11: {
                    string3 = "";
                    string2 = "";
                    try {
                        priceModifierScope = PriceModifierScope.valueOf(configurationSection.getString(string + ".scope").toUpperCase());
                        priceModifierActionType = PriceModifierActionType.valueOf(configurationSection.getString(string + ".type").toUpperCase());
                        d = configurationSection.getDouble(string + ".value");
                        if (priceModifierScope == PriceModifierScope.SHOP) {
                            string3 = configurationSection.getString(string + ".shop");
                            if (string3 == null || this.main.getShopManager().getShopById(string3) == null) {
                                this.main.warning("Missing or invalid shop specified for price modifier '" + string + "', price modifier not loaded");
                                continue;
                            }
                            break block11;
                        }
                        if (priceModifierScope != PriceModifierScope.ITEM) break block11;
                        string3 = configurationSection.getString(string + ".shop");
                        string2 = configurationSection.getString(string + ".shopItem");
                        if (string3 == null || this.main.getShopManager().getShopById(string3) == null) {
                            this.main.warning("Missing or invalid shop specified for price modifier '" + string + "', price modifier not loaded");
                            continue;
                        }
                        if (string2 == null || this.main.getShopManager().getShopById(string3).getShopItem(string2) == null) {
                            this.main.warning("Missing or invalid shop item specified for price modifier '" + string + "', price modifier not loaded");
                        }
                        break block11;
                    }
                    catch (NullPointerException nullPointerException) {
                        this.main.warning("Error occurred when loading price modifier '" + string + "', price modifier not loaded");
                    }
                    continue;
                }
                PermissionPriceModifier permissionPriceModifier = new PermissionPriceModifier(string, priceModifierScope, priceModifierActionType, d);
                if (priceModifierScope == PriceModifierScope.SHOP) {
                    permissionPriceModifier.setShopId(string3);
                } else if (priceModifierScope == PriceModifierScope.ITEM) {
                    permissionPriceModifier.setShopId(string3);
                    permissionPriceModifier.setShopItemId(string2);
                }
                this.permissionPriceModifiers.add(permissionPriceModifier);
            }
        }
    }

    public List<PermissionPriceModifier> getPlayerPermissionPriceModifiers(Player player) {
        ArrayList<PermissionPriceModifier> arrayList = new ArrayList<PermissionPriceModifier>();
        for (PermissionPriceModifier permissionPriceModifier : this.permissionPriceModifiers) {
            if (!PermissionManager.hasPermission(player, "shopguiplus.pricemodifiers." + permissionPriceModifier.getId())) continue;
            arrayList.add(permissionPriceModifier);
        }
        return arrayList;
    }

    public PermissionPriceModifier getPlayersPermissionPriceModifier(Player player, ShopItem shopItem, PriceModifierActionType priceModifierActionType) {
        PermissionPriceModifier permissionPriceModifier3;
        Shop shop = shopItem.getShop();
        PermissionPriceModifier permissionPriceModifier2 = null;
        for (PermissionPriceModifier permissionPriceModifier3 : this.getPermissionPriceModifiers(PriceModifierScope.ITEM)) {
            if (!permissionPriceModifier3.getShopItemId().equalsIgnoreCase(shopItem.getId()) || !permissionPriceModifier3.getShopId().equalsIgnoreCase(shop.getId()) || permissionPriceModifier3.getType() != priceModifierActionType && permissionPriceModifier3.getType() != PriceModifierActionType.BOTH || !PermissionManager.hasPermission(player, "shopguiplus.pricemodifiers." + permissionPriceModifier3.getId()) || !this.isAlternativeBetterForPlayer(permissionPriceModifier2, permissionPriceModifier3, priceModifierActionType)) continue;
            permissionPriceModifier2 = permissionPriceModifier3;
        }
        PermissionPriceModifier permissionPriceModifier4 = this.getShopPriceModifier(player, shop, priceModifierActionType);
        if (this.isAlternativeBetterForPlayer(permissionPriceModifier2, permissionPriceModifier4, priceModifierActionType)) {
            permissionPriceModifier2 = permissionPriceModifier4;
        }
        if (this.isAlternativeBetterForPlayer(permissionPriceModifier2, permissionPriceModifier3 = this.getGlobalPriceModifier(player, priceModifierActionType), priceModifierActionType)) {
            permissionPriceModifier2 = permissionPriceModifier3;
        }
        return permissionPriceModifier2;
    }

    public PermissionPriceModifier getShopPriceModifier(Player player, Shop shop, PriceModifierActionType priceModifierActionType) {
        PermissionPriceModifier permissionPriceModifier = null;
        for (PermissionPriceModifier permissionPriceModifier2 : this.getPermissionPriceModifiers(PriceModifierScope.SHOP)) {
            if (!permissionPriceModifier2.getShopId().equalsIgnoreCase(shop.getId()) || permissionPriceModifier2.getType() != priceModifierActionType && permissionPriceModifier2.getType() != PriceModifierActionType.BOTH || !PermissionManager.hasPermission(player, "shopguiplus.pricemodifiers." + permissionPriceModifier2.getId()) || !this.isAlternativeBetterForPlayer(permissionPriceModifier, permissionPriceModifier2, priceModifierActionType)) continue;
            permissionPriceModifier = permissionPriceModifier2;
        }
        PermissionPriceModifier permissionPriceModifier3 = this.getGlobalPriceModifier(player, priceModifierActionType);
        if (this.isAlternativeBetterForPlayer(permissionPriceModifier, permissionPriceModifier3, priceModifierActionType)) {
            permissionPriceModifier = permissionPriceModifier3;
        }
        return permissionPriceModifier;
    }

    public PermissionPriceModifier getGlobalPriceModifier(Player player, PriceModifierActionType priceModifierActionType) {
        PermissionPriceModifier permissionPriceModifier = null;
        for (PermissionPriceModifier permissionPriceModifier2 : this.getPermissionPriceModifiers(PriceModifierScope.GLOBAL)) {
            if (permissionPriceModifier2.getType() != priceModifierActionType && permissionPriceModifier2.getType() != PriceModifierActionType.BOTH || !PermissionManager.hasPermission(player, "shopguiplus.pricemodifiers." + permissionPriceModifier2.getId()) || !this.isAlternativeBetterForPlayer(permissionPriceModifier, permissionPriceModifier2, priceModifierActionType)) continue;
            permissionPriceModifier = permissionPriceModifier2;
        }
        return permissionPriceModifier;
    }

    private List<PermissionPriceModifier> getPermissionPriceModifiers(PriceModifierScope ... priceModifierScopeArray) {
        ArrayList<PermissionPriceModifier> arrayList = new ArrayList<PermissionPriceModifier>();
        for (PermissionPriceModifier permissionPriceModifier : this.permissionPriceModifiers) {
            if (!Arrays.asList(priceModifierScopeArray).contains((Object)permissionPriceModifier.getScope())) continue;
            arrayList.add(permissionPriceModifier);
        }
        return arrayList;
    }

    private boolean isAlternativeBetterForPlayer(PermissionPriceModifier permissionPriceModifier, PermissionPriceModifier permissionPriceModifier2, PriceModifierActionType priceModifierActionType) {
        if (priceModifierActionType != PriceModifierActionType.BUY && priceModifierActionType != PriceModifierActionType.SELL) {
            throw new ModifierFindAlternativeInvalidTypeException();
        }
        if (permissionPriceModifier == null) {
            return true;
        }
        if (permissionPriceModifier2 == null) {
            return false;
        }
        if (priceModifierActionType == PriceModifierActionType.BUY) {
            return permissionPriceModifier2.getValue() < permissionPriceModifier.getValue();
        }
        if (priceModifierActionType == PriceModifierActionType.SELL) {
            return permissionPriceModifier2.getValue() > permissionPriceModifier.getValue();
        }
        return false;
    }
}

