/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.shop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.brcdev.shopgui.gui.element.special.GuiSpecialElement;
import net.brcdev.shopgui.shop.ShopManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MainMenuItem {
    private ShopManager.MainMenuItemType type;
    private ItemStack item;
    private List<Integer> slots;
    private String shopId;
    private GuiSpecialElement specialElement;
    private List<String> commandsOnClick;
    private List<String> commandsOnClickConsole;
    private boolean closeGuiOnClick;

    public MainMenuItem(ShopManager.MainMenuItemType mainMenuItemType, int n) {
        this.type = mainMenuItemType;
        this.slots = new ArrayList<Integer>(Arrays.asList(n));
        this.commandsOnClick = new ArrayList<String>();
        this.commandsOnClickConsole = new ArrayList<String>();
        this.closeGuiOnClick = false;
    }

    public MainMenuItem(ShopManager.MainMenuItemType mainMenuItemType, ItemStack itemStack, int n) {
        this.type = mainMenuItemType;
        this.item = itemStack;
        this.slots = new ArrayList<Integer>(Arrays.asList(n));
        this.commandsOnClick = new ArrayList<String>();
        this.commandsOnClickConsole = new ArrayList<String>();
        this.closeGuiOnClick = false;
    }

    public MainMenuItem(ShopManager.MainMenuItemType mainMenuItemType, List<Integer> list) {
        this.type = mainMenuItemType;
        this.slots = list;
        this.commandsOnClick = new ArrayList<String>();
        this.commandsOnClickConsole = new ArrayList<String>();
        this.closeGuiOnClick = false;
    }

    public MainMenuItem(ShopManager.MainMenuItemType mainMenuItemType, ItemStack itemStack, List<Integer> list) {
        this.type = mainMenuItemType;
        this.item = itemStack;
        this.slots = list;
        this.commandsOnClick = new ArrayList<String>();
        this.commandsOnClickConsole = new ArrayList<String>();
        this.closeGuiOnClick = false;
    }

    public MainMenuItem(MainMenuItem mainMenuItem) {
        this.type = mainMenuItem.type;
        this.item = mainMenuItem.item;
        this.slots = mainMenuItem.slots;
        this.commandsOnClick = mainMenuItem.commandsOnClick;
        this.commandsOnClickConsole = mainMenuItem.commandsOnClickConsole;
        this.closeGuiOnClick = mainMenuItem.closeGuiOnClick;
    }

    public ShopManager.MainMenuItemType getType() {
        return this.type;
    }

    public void setType(ShopManager.MainMenuItemType mainMenuItemType) {
        this.type = mainMenuItemType;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack itemStack) {
        this.item = itemStack;
    }

    @Deprecated
    public int getSlot() {
        return this.slots.get(0);
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    @Deprecated
    public void setSlot(int n) {
        this.slots.clear();
        this.slots.add(n);
    }

    public void setSlots(List<Integer> list) {
        this.slots = list;
    }

    public String getShopId() {
        return this.shopId;
    }

    public void setShopId(String string) {
        this.shopId = string;
    }

    public GuiSpecialElement getSpecialElement() {
        return this.specialElement;
    }

    public void setSpecialElement(GuiSpecialElement guiSpecialElement) {
        this.specialElement = guiSpecialElement;
    }

    public List<String> getCommandsOnClick() {
        return this.commandsOnClick;
    }

    public void setCommandsOnClick(List<String> list) {
        this.commandsOnClick = list;
    }

    public List<String> getCommandsOnClickConsole() {
        return this.commandsOnClickConsole;
    }

    public void setCommandsOnClickConsole(List<String> list) {
        this.commandsOnClickConsole = list;
    }

    public boolean isCloseGuiOnClick() {
        return this.closeGuiOnClick;
    }

    public void setCloseGuiOnClick(boolean bl) {
        this.closeGuiOnClick = bl;
    }

    public void executeAllCommands(Player player) {
        for (String string : this.commandsOnClick) {
            Bukkit.dispatchCommand((CommandSender)player, (String)string.replace("%PLAYER%", player.getName()));
        }
        for (String string : this.commandsOnClickConsole) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string.replace("%PLAYER%", player.getName()));
        }
    }
}

