/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.spawner.external;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.config.Settings;
import net.brcdev.shopgui.exception.api.ExternalSpawnerProviderNameConflictException;
import net.brcdev.shopgui.spawner.external.provider.ExternalSpawnerProvider;
import org.apache.commons.lang.StringUtils;

public class ExternalSpawnerHandler {
    private ShopGuiPlugin main;
    private List<ExternalSpawnerProvider> registeredProviders;
    private ExternalSpawnerProvider provider;

    public ExternalSpawnerHandler(ShopGuiPlugin shopGuiPlugin) {
        this.main = shopGuiPlugin;
        this.registeredProviders = new ArrayList<ExternalSpawnerProvider>();
    }

    public void registerExternalSpawnerProvider(ExternalSpawnerProvider externalSpawnerProvider) {
        String string = externalSpawnerProvider.getName();
        if (this.getSpawnerProvider(string).isPresent()) {
            throw new ExternalSpawnerProviderNameConflictException(string);
        }
        this.registeredProviders.add(externalSpawnerProvider);
        this.main.getLogger().info("Registered spawners support for " + string + ".");
    }

    public void setupMainProvider() {
        if (this.registeredProviders.size() > 1) {
            if (StringUtils.isEmpty((String)Settings.spawnerProvider)) {
                this.main.getLogger().info("Found multiple registered spawner plugins (" + this.buildRegisteredProvidersList() + ").");
                this.main.getLogger().info("Add \"spawnerProvider: <NAME>\" to config.yml, replacing <NAME> with one of names listed above to select one of them.");
                this.main.getLogger().info("Using built-in spawners support until one of them is chosen.");
            } else {
                Optional<ExternalSpawnerProvider> optional = this.getSpawnerProvider(Settings.spawnerProvider);
                if (!optional.isPresent()) {
                    this.main.getLogger().info("Invalid spawnerProvider name provided in config.yml! List of registered providers you can use: " + this.buildRegisteredProvidersList());
                    this.main.getLogger().info("Using built-in spawners support until valid name is provided.");
                } else {
                    this.provider = optional.get();
                }
            }
        } else if (this.registeredProviders.size() == 1) {
            this.provider = this.registeredProviders.get(0);
        }
        if (this.provider == null) {
            this.main.getLogger().info("No external spawner plugins registered, using built-in spawners support.");
        } else {
            this.main.getLogger().info("Using " + this.provider.getName() + " for spawners support.");
        }
    }

    public ExternalSpawnerProvider getProvider() {
        return this.provider;
    }

    public boolean isProviderSetup() {
        return this.provider != null;
    }

    private String buildRegisteredProvidersList() {
        String string = "";
        for (ExternalSpawnerProvider externalSpawnerProvider : this.registeredProviders) {
            string = string + externalSpawnerProvider.getName() + ", ";
        }
        if (string.endsWith(", ")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    private Optional<ExternalSpawnerProvider> getSpawnerProvider(String string) {
        return this.registeredProviders.stream().filter(externalSpawnerProvider -> externalSpawnerProvider.getName().equalsIgnoreCase(string)).findFirst();
    }
}

