/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.brcdev.shopgui.exception.UnsupportedMinecraftVersionException;
import net.brcdev.shopgui.legacy.LegacyItemStackHandler;
import net.brcdev.shopgui.util.NmsVersion;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NmsUtils {
    private static final Pattern MINECRAFT_SHORT_VERSION_PATTERN = Pattern.compile("(v\\d_\\d+)");
    private static final Pattern MINECRAFT_FULL_VERSION_PATTERN = Pattern.compile("(v\\d_\\d+_[a-zA-Z0-9]+)");

    public static boolean isNmsVersionAtLeast(NmsVersion nmsVersion) {
        NmsVersion nmsVersion2 = NmsUtils.readNmsVersion();
        return nmsVersion2.extractVersionNumber() >= nmsVersion.extractVersionNumber();
    }

    public static boolean isNmsVersionLowerThan(NmsVersion nmsVersion) {
        return !NmsUtils.isNmsVersionAtLeast(nmsVersion);
    }

    public static String getNmsClasspath() {
        return NmsUtils.extractNmsVersion(MINECRAFT_FULL_VERSION_PATTERN);
    }

    private static NmsVersion readNmsVersion() {
        return NmsUtils.parseShortNmsVersion(NmsUtils.extractNmsVersion(MINECRAFT_SHORT_VERSION_PATTERN));
    }

    private static String extractNmsVersion(Pattern pattern) {
        String string = Bukkit.getServer().getClass().getPackage().getName();
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group();
        }
        throw new UnsupportedMinecraftVersionException();
    }

    private static NmsVersion parseShortNmsVersion(String string) {
        NmsVersion nmsVersion;
        try {
            nmsVersion = NmsVersion.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedMinecraftVersionException();
        }
        return nmsVersion;
    }

    private static String getGameProfileClassPath() {
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_8)) {
            return "com.mojang.authlib.GameProfile";
        }
        throw new UnsupportedMinecraftVersionException();
    }

    private static String getPropertyMapClassPath() {
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_8)) {
            return "com.mojang.authlib.properties.PropertyMap";
        }
        throw new UnsupportedMinecraftVersionException();
    }

    private static String getPropertyClassPath() {
        if (NmsUtils.isNmsVersionAtLeast(NmsVersion.v1_8)) {
            return "com.mojang.authlib.properties.Property";
        }
        throw new UnsupportedMinecraftVersionException();
    }

    static ItemStack setHeadSkin(ItemStack itemStack, String string) {
        if (!LegacyItemStackHandler.isPlayerHead(itemStack) || string == null || string.isEmpty()) {
            return itemStack;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        try {
            Class<?> clazz = Class.forName(NmsUtils.getGameProfileClassPath());
            Object obj = clazz.getConstructor(UUID.class, String.class).newInstance(UUID.randomUUID(), "base64");
            Object object = obj.getClass().getMethod("getProperties", new Class[0]).invoke(obj, new Object[0]);
            Class<?> clazz2 = Class.forName(NmsUtils.getPropertyClassPath());
            Object obj2 = clazz2.getConstructor(String.class, String.class).newInstance("textures", string);
            object.getClass().getMethod("put", Object.class, Object.class).invoke(object, "textures", obj2);
            Field field = itemMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            field.set(itemMeta, obj);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return itemStack;
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    static String getHeadSkin(ItemStack itemStack) {
        if (!LegacyItemStackHandler.isPlayerHead(itemStack)) {
            return "";
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        try {
            Field field = itemMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            Object object = field.get(itemMeta);
            if (object == null) {
                return "";
            }
            Object object2 = object.getClass().getMethod("getProperties", new Class[0]).invoke(object, new Object[0]);
            Field field2 = object2.getClass().getDeclaredField("properties");
            field2.setAccessible(true);
            Object object3 = field2.get(object2);
            Method method2 = Arrays.stream(object3.getClass().getDeclaredMethods()).filter(method -> method.getName().equals("get")).findFirst().orElse(null);
            if (method2 == null) {
                return "";
            }
            Object object4 = method2.invoke(object3, "textures");
            Method method3 = object4.getClass().getMethod("iterator", new Class[0]);
            method3.setAccessible(true);
            Object object5 = method3.invoke(object4, new Object[0]);
            Method method4 = object5.getClass().getMethod("next", new Class[0]);
            method4.setAccessible(true);
            Object object6 = method4.invoke(object5, new Object[0]);
            String string = (String)object6.getClass().getMethod("getValue", new Class[0]).invoke(object6, new Object[0]);
            if (string == null) {
                return "";
            }
            return string;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return "";
        }
    }
}

