/*
 * Decompiled with CFR 0.152.
 */
package shaded.de.tr7zw.changeme.nbtapi.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import shaded.de.tr7zw.changeme.nbtapi.utils.Metrics;
import shaded.de.tr7zw.changeme.nbtapi.utils.VersionChecker;

public enum MinecraftVersion {
    UNKNOWN(Integer.MAX_VALUE),
    MC1_7_R4(174),
    MC1_8_R3(183),
    MC1_9_R1(191),
    MC1_9_R2(192),
    MC1_10_R1(1101),
    MC1_11_R1(1111),
    MC1_12_R1(1121),
    MC1_13_R1(1131),
    MC1_13_R2(1132),
    MC1_14_R1(1141),
    MC1_15_R1(1151),
    MC1_16_R1(1161),
    MC1_16_R2(1162),
    MC1_16_R3(1163),
    MC1_17_R1(1171),
    MC1_18_R1(1181, true),
    MC1_18_R2(1182, true),
    MC1_19_R1(1191, true),
    MC1_19_R2(1192, true),
    MC1_19_R3(1193, true),
    MC1_20_R1(1201, true),
    MC1_20_R2(1201, true);

    private static MinecraftVersion version;
    private static Boolean hasGsonSupport;
    private static Boolean isForgePresent;
    private static Boolean isFoliaPresent;
    private static boolean bStatsDisabled;
    private static boolean disablePackageWarning;
    private static boolean updateCheckDisabled;
    private static Logger logger;
    protected static final String VERSION = "2.12.0";
    private final int versionId;
    private final boolean mojangMapping;

    private MinecraftVersion(int n2) {
        this(n2, false);
    }

    private MinecraftVersion(int n2, boolean bl) {
        this.versionId = n2;
        this.mojangMapping = bl;
    }

    public int getVersionId() {
        return this.versionId;
    }

    public boolean isMojangMapping() {
        return this.mojangMapping;
    }

    public String getPackageName() {
        if (this == UNKNOWN) {
            return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        return this.name().replace("MC", "v");
    }

    public static boolean isAtLeastVersion(MinecraftVersion minecraftVersion) {
        return MinecraftVersion.getVersion().getVersionId() >= minecraftVersion.getVersionId();
    }

    public static boolean isNewerThan(MinecraftVersion minecraftVersion) {
        return MinecraftVersion.getVersion().getVersionId() > minecraftVersion.getVersionId();
    }

    public static MinecraftVersion getVersion() {
        if (version != null) {
            return version;
        }
        String string = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        logger.info("[NBTAPI] Found Spigot: " + string + "! Trying to find NMS support");
        try {
            version = MinecraftVersion.valueOf(string.replace("v", "MC"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            version = UNKNOWN;
        }
        if (version != UNKNOWN) {
            logger.info("[NBTAPI] NMS support '" + version.name() + "' loaded!");
        } else {
            logger.warning("[NBTAPI] This Server-Version(" + string + ") is not supported by this NBT-API Version(" + VERSION + ") located in " + VersionChecker.getPlugin() + ". The NBT-API will try to work as good as it can! Some functions may not work!");
        }
        MinecraftVersion.init();
        return version;
    }

    public static String getNBTAPIVersion() {
        return VERSION;
    }

    private static void init() {
        Object object;
        try {
            if (MinecraftVersion.hasGsonSupport() && !bStatsDisabled) {
                object = Bukkit.getPluginManager().getPlugin(VersionChecker.getPlugin());
                if (object != null && object instanceof JavaPlugin) {
                    MinecraftVersion.getLogger().info("[NBTAPI] Using the plugin '" + object.getName() + "' to create a bStats instance!");
                    new Metrics((JavaPlugin)object, 1058);
                } else if (object == null) {
                    MinecraftVersion.getLogger().info("[NBTAPI] Unable to create a bStats instance!!");
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "[NBTAPI] Error enabling Metrics!", exception);
        }
        if (MinecraftVersion.hasGsonSupport() && !updateCheckDisabled) {
            new Thread(() -> {
                try {
                    VersionChecker.checkForUpdates();
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "[NBTAPI] Error while checking for updates! Error: " + exception.getMessage());
                }
            }).start();
        }
        object = new String(new byte[]{100, 101, 46, 116, 114, 55, 122, 119, 46, 99, 104, 97, 110, 103, 101, 109, 101, 46, 110, 98, 116, 97, 112, 105, 46, 117, 116, 105, 108, 115});
        String string = new String(new byte[]{100, 101, 46, 116, 114, 55, 122, 119, 46, 110, 98, 116, 97, 112, 105, 46, 117, 116, 105, 108, 115});
        if (!disablePackageWarning && MinecraftVersion.class.getPackage().getName().equals(object)) {
            logger.warning("#########################################- NBTAPI -#########################################");
            logger.warning("The NBT-API package has not been moved! This *will* cause problems with other plugins containing");
            logger.warning("a different version of the api! Please read the guide on the plugin page on how to get the");
            logger.warning("Maven Shade plugin to relocate the api to your personal location! If you are not the developer,");
            logger.warning("please check your plugins and contact their developer, so they can fix this issue.");
            logger.warning("#########################################- NBTAPI -#########################################");
        }
        if (!disablePackageWarning && !"NBTAPI".equals(VersionChecker.getPlugin())) {
            if (!"de.tr7zw.nbtapi.utils".equals(string)) {
                logger.warning("#########################################- NBTAPI -#########################################");
                logger.warning("The NBT-API inside " + VersionChecker.getPlugin() + " is the plugin version, not the API!");
                logger.warning("The plugin itself should never be shaded! Remove the `-plugin` from the dependency and fix your shading setup.");
                logger.warning("For more info check: https://github.com/tr7zw/Item-NBT-API/wiki/Using-Maven#option-2-shading-the-nbt-api-into-your-plugin");
                logger.warning("#########################################- NBTAPI -#########################################");
                return;
            }
            if (MinecraftVersion.class.getPackage().getName().equals("de.tr7zw.nbtapi.utils")) {
                logger.warning("#########################################- NBTAPI -#########################################");
                logger.warning("The NBT-API inside " + VersionChecker.getPlugin() + " is located at 'de.tr7zw.nbtapi.utils'!");
                logger.warning("This package name is reserved for the official NBTAPI plugin, and not intended to be used for shading!");
                logger.warning("Please change the relocate to something else. For example: com.example.util.nbtapi");
                logger.warning("#########################################- NBTAPI -#########################################");
            }
        }
    }

    public static boolean hasGsonSupport() {
        if (hasGsonSupport != null) {
            return hasGsonSupport;
        }
        try {
            Class.forName("com.google.gson.Gson");
            hasGsonSupport = true;
        }
        catch (Exception exception) {
            logger.info("[NBTAPI] Gson not found! This will not allow the usage of some methods!");
            hasGsonSupport = false;
        }
        return hasGsonSupport;
    }

    public static boolean isForgePresent() {
        if (isForgePresent != null) {
            return isForgePresent;
        }
        try {
            logger.info("[NBTAPI] Found Forge: " + (MinecraftVersion.getVersion() == MC1_7_R4 ? Class.forName("cpw.mods.fml.common.Loader") : Class.forName("net.minecraftforge.fml.common.Loader")));
            isForgePresent = true;
        }
        catch (Exception exception) {
            isForgePresent = false;
        }
        return isForgePresent;
    }

    public static boolean isFoliaPresent() {
        if (isFoliaPresent != null) {
            return isFoliaPresent;
        }
        try {
            logger.info("[NBTAPI] Found Folia: " + Class.forName("io.papermc.paper.threadedregions.RegionizedServer"));
            isFoliaPresent = true;
        }
        catch (Exception exception) {
            isFoliaPresent = false;
        }
        return isFoliaPresent;
    }

    public static void disableBStats() {
        bStatsDisabled = true;
    }

    public static void disableUpdateCheck() {
        updateCheckDisabled = true;
    }

    public static void enableUpdateCheck() {
        updateCheckDisabled = false;
    }

    public static void disablePackageWarning() {
        disablePackageWarning = true;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void replaceLogger(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("Logger can not be null!");
        }
        MinecraftVersion.logger = logger;
    }

    static {
        bStatsDisabled = false;
        disablePackageWarning = false;
        updateCheckDisabled = true;
        logger = Logger.getLogger("NBTAPI");
    }
}

