/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.handlers.lootPopulation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.advancedplugins.ae.enchanthandler.enchantments.AdvancedGroup;
import net.advancedplugins.ae.handlers.lootPopulation.PopulationHandler;
import net.advancedplugins.ae.handlers.lootPopulation.enums.LootMapType;
import net.advancedplugins.ae.handlers.lootPopulation.enums.LootType;

public class LootMap {
    private ImmutableMap<LootType, Integer> chancesMap;
    private final boolean enabled;
    private double generationChance;
    private final LootMapType lootMapType;
    private List<AdvancedGroup> blockedGroups;
    private boolean tradeAllLoot;
    private int maxItemsPerContainer;
    private ImmutableList<LootType> finalLootChances;
    private static final String[] a;

    public LootMap(LootMapType lootMapType, PopulationHandler populationHandler) {
        int[] nArray = PopulationHandler.b();
        this.lootMapType = lootMapType;
        int[] nArray2 = nArray;
        this.enabled = populationHandler.getPopFile().get().getBoolean(lootMapType.getEnabledPath());
        if (!this.enabled) {
            return;
        }
        this.chancesMap = populationHandler.readChances(lootMapType);
        this.generationChance = populationHandler.getPopFile().get().getInt(lootMapType.getGenerationChance());
        switch (lootMapType) {
            case VILLAGER: {
                String[] stringArray = a;
                this.tradeAllLoot = populationHandler.getPopFile().get().getBoolean(stringArray[1]);
                this.blockedGroups = populationHandler.getPopFile().get().getStringList(stringArray[0]).stream().filter(AdvancedGroup::isGroup).map(AdvancedGroup::matchGroup).collect(Collectors.toList());
                if (nArray2 == null) break;
            }
            case RANDOM_LOOT: {
                String[] stringArray = a;
                this.maxItemsPerContainer = populationHandler.getPopFile().get().getInt(stringArray[3]);
                this.blockedGroups = populationHandler.getPopFile().get().getStringList(stringArray[2]).stream().filter(AdvancedGroup::isGroup).map(AdvancedGroup::matchGroup).collect(Collectors.toList());
            }
        }
        this.generateLootChances();
    }

    private void generateLootChances() {
        ArrayList<LootType> arrayList;
        block3: {
            LootMap lootMap;
            arrayList = new ArrayList<LootType>();
            int[] nArray = PopulationHandler.b();
            block0: for (Map.Entry entry : this.chancesMap.entrySet()) {
                lootMap = this;
                if (nArray == null) {
                    if (lootMap.lootMapType == LootMapType.VILLAGER && !this.shouldTradeAllLoot() && !((LootType)((Object)entry.getKey())).equals((Object)LootType.RANDOM_ENCHANT_BOOK) && nArray == null) continue;
                    for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                        arrayList.add((LootType)((Object)entry.getKey()));
                        if (nArray != null) continue block0;
                        if (nArray == null) continue;
                    }
                    if (nArray == null) continue;
                }
                break block3;
            }
            lootMap = this;
        }
        lootMap.finalLootChances = ImmutableList.copyOf(arrayList);
    }

    public LootType getRandomLoot() {
        if (this.getGenerationChance() < (double)(ThreadLocalRandom.current().nextInt(100) + 1)) {
            return null;
        }
        if (this.finalLootChances.size() <= 0) {
            return null;
        }
        if (this.finalLootChances.size() < 2) {
            return (LootType)((Object)this.finalLootChances.get(0));
        }
        return (LootType)((Object)this.finalLootChances.get(ThreadLocalRandom.current().nextInt(this.finalLootChances.size())));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getGenerationChance() {
        return this.generationChance;
    }

    public ImmutableMap<LootType, Integer> getChancesMap() {
        return this.chancesMap;
    }

    public List<AdvancedGroup> getBlockedGroups() {
        return this.blockedGroups;
    }

    public int getMaxItemsPerContainer() {
        return this.maxItemsPerContainer;
    }

    public boolean shouldTradeAllLoot() {
        return this.tradeAllLoot;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block10: {
            block9: {
                var5 = new String[4];
                var3_1 = 0;
                var2_2 = "cTR\u000fbx,giL\u0002gz:;_R\u0002`t%|NJ\u0006g2.gRK\u0013p\u001bcTR\u000fbx,giL\u0002gz:;IL\u0002gz\byQr\flk";
                var4_3 = "cTR\u000fbx,giL\u0002gz:;_R\u0002`t%|NJ\u0006g2.gRK\u0013p\u001bcTR\u000fbx,giL\u0002gz:;IL\u0002gz\byQr\flk".length();
                var1_4 = 33;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 101;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block9;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = LootMap.a(v0, LootMap.a(v2));
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0018#/x\u0013\rz\u0005-52\u001e\fW\t)-u\u000f\u0014S\u000eo&n\u0013\u0015F\u0019\u001f\u0018#/x\u0013\rz\u0005-52\u0011\u0001N#6$q\u000f0S\u0018\u0001.r\b\u0001_\u0004'3";
                    var4_3 = "\u0018#/x\u0013\rz\u0005-52\u001e\fW\t)-u\u000f\u0014S\u000eo&n\u0013\u0015F\u0019\u001f\u0018#/x\u0013\rz\u0005-52\u0011\u0001N#6$q\u000f0S\u0018\u0001.r\b\u0001_\u0004'3".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 26;
                        v4 = ++var0_5;
                        v2 = var2_2.substring(v4, v4 + var1_4);
                        v3 = 0;
                        break block9;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = LootMap.a(v0, LootMap.a(v2));
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block10;
                    break;
                }
            }
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl39:
                // 1 sources

                ** continue;
            }
        }
        LootMap.a = var5;
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x2C);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 112;
                        break;
                    }
                    case 1: {
                        n5 = 88;
                        break;
                    }
                    case 2: {
                        n5 = 91;
                        break;
                    }
                    case 3: {
                        n5 = 6;
                        break;
                    }
                    case 4: {
                        n5 = 102;
                        break;
                    }
                    case 5: {
                        n5 = 122;
                        break;
                    }
                    default: {
                        n5 = 44;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

