/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.managers;

import com.google.common.base.Preconditions;
import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.enums.EHeadStyleType;
import dev.hexedhero.pinprompt.utils.Common;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class HeadStyleManager {
    private EHeadStyleType headStyle;
    private static HeadStyleManager instance;

    public static HeadStyleManager getInstance() {
        if (instance == null) {
            instance = new HeadStyleManager();
        }
        return instance;
    }

    private HeadStyleManager() {
        this.setupHeadStyleType((CommandSender)Bukkit.getConsoleSender());
        Common.tellConsole(true, "HeadStyleManager initialized!");
    }

    public void setupHeadStyleType(CommandSender commandSender) {
        try {
            this.headStyle = EHeadStyleType.valueOf(PINPrompt.getInstance().getConfig().getString("PIN Inventory.Head Style").toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            Common.tell(commandSender, Common.getLanguagePrefix(commandSender) + "&cUNKNOWN HEAD TYPE \"%headStyleType%\" &7- &fFallbacking to default Quartz!".replace("%headStyleType%", PINPrompt.getInstance().getConfig().getString("PIN Inventory.Head Style")));
            this.headStyle = EHeadStyleType.QUARTZ;
        }
    }

    public String getHeadTextureBase64(int n) {
        Preconditions.checkArgument((n >= 1 && n <= 9 ? 1 : 0) != 0, (Object)"The head number must be between 1 and 9!");
        Preconditions.checkArgument((this.headStyle != null ? 1 : 0) != 0, (Object)"headStyle cannot be null");
        return this.headStyle.getHeadTextureBase64(n);
    }
}

