/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.managers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.enums.EPINOpenReason;
import dev.hexedhero.pinprompt.managers.FlyManager;
import dev.hexedhero.pinprompt.managers.HeadStyleManager;
import dev.hexedhero.pinprompt.managers.NMSManager;
import dev.hexedhero.pinprompt.managers.PINManager;
import dev.hexedhero.pinprompt.managers.SpectatorManager;
import dev.hexedhero.pinprompt.managers.TaskManager;
import dev.hexedhero.pinprompt.managers.TeleportManager;
import dev.hexedhero.pinprompt.tasks.PlayerInGUITask;
import dev.hexedhero.pinprompt.utils.ColorHelper;
import dev.hexedhero.pinprompt.utils.Common;
import dev.hexedhero.pinprompt.utils.VersionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class InventoryManager {
    private Inventory PINInventory;
    private static InventoryManager instance;
    private Method metaSetProfileMethod;
    private Field metaProfileField;

    public static InventoryManager getInstance() {
        if (instance == null) {
            instance = new InventoryManager();
        }
        return instance;
    }

    private InventoryManager() {
        this.createPINInventory();
        this.stockInventory();
        Common.tellConsole(true, "InventoryManager initialized!");
    }

    public Inventory getPINInventory() {
        return this.PINInventory;
    }

    public InventoryManager createPINInventory() {
        this.PINInventory = Bukkit.createInventory(null, (InventoryType)InventoryType.DISPENSER, (String)ColorHelper.colorize(Common.getLanguage("PIN Name", false)));
        return this;
    }

    public InventoryManager stockInventory() {
        Common.debugToConsole("Inventory", "Stocking inventory");
        this.getPINInventory().clear();
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack = this.createSkull(ColorHelper.colorize(Common.getLanguage("PIN Head Name", false)).replace("%number%", Integer.toString(i + 1)), HeadStyleManager.getInstance().getHeadTextureBase64(i + 1));
            if (PINPrompt.getInstance().getConfig().getBoolean("PIN Inventory.Display Number As Amount")) {
                itemStack.setAmount(i + 1);
            }
            this.PINInventory.setItem(i, itemStack);
        }
        return this;
    }

    public void openNewPINInventory(Player player, EPINOpenReason ePINOpenReason) {
        Common.debugToConsole("Inventory", "Setting up new PIN inventory for %uuid%".replace("%uuid%", player.getUniqueId().toString()));
        TeleportManager.getInstance().teleportPlayer(player, ePINOpenReason);
        UUID uUID = player.getUniqueId();
        if (ePINOpenReason.getNewPIN()) {
            PINManager.getInstance().addPlayerToCreatingPIN(uUID);
        } else {
            PINManager.getInstance().addPlayerToNeedingPIN(uUID);
        }
        if (!player.isFlying() && !player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
            if (!player.getAllowFlight()) {
                FlyManager.getInstance().addPlayerInSavedFlyMode(player);
            }
            player.setAllowFlight(true);
            player.setFlying(true);
        }
        if (player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
            player.setGameMode(GameMode.valueOf((String)PINPrompt.getInstance().getConfig().getString("Spectator Mode Handler.Switch To").toUpperCase()));
            SpectatorManager.getInstance().addPlayerInSavedSpectatorMode(player);
            if (!player.getAllowFlight()) {
                FlyManager.getInstance().addPlayerInSavedFlyMode(player);
            }
            player.setAllowFlight(true);
            player.setFlying(true);
        }
        BukkitTask bukkitTask = new PlayerInGUITask(player, ePINOpenReason.getTimeout()).runTaskTimer((Plugin)PINPrompt.getInstance(), 3L, 1L);
        TaskManager.getInstance().putPlayerInTimeOutTask(player, bukkitTask);
    }

    public void openPINInventory(Player player) {
        Common.debugToConsole("Inventory", "Opening PIN inventory for %uuid%".replace("%uuid%", player.getUniqueId().toString()));
        player.closeInventory();
        player.openInventory(this.PINInventory);
        Common.playSound(player, player.getLocation(), Common.getSound("PIN Open"));
        String string = PINManager.getInstance().isPlayerNeedingPIN(player.getUniqueId()) ? Common.getLanguage("PIN Name", false) : Common.getLanguage("New PIN Name", false);
        NMSManager.getInstance().getNMSImplementation().updateGUITitle(player, ColorHelper.colorize(string));
    }

    private ItemStack createSkull(String string, String string2) {
        ItemStack itemStack = new ItemStack(VersionHelper.getMajorVersionNumber() >= 13 ? Material.valueOf((String)"PLAYER_HEAD") : Material.valueOf((String)"SKULL_ITEM"));
        if (VersionHelper.getMajorVersionNumber() <= 12) {
            itemStack.setDurability((short)3);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(string.trim().isEmpty() ? " " : string);
        this.mutateItemMeta((SkullMeta)itemMeta, string2);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private void mutateItemMeta(SkullMeta skullMeta, String string) {
        try {
            if (this.metaSetProfileMethod == null) {
                this.metaSetProfileMethod = skullMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                this.metaSetProfileMethod.setAccessible(true);
            }
            this.metaSetProfileMethod.invoke((Object)skullMeta, this.makeProfile(string));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            try {
                if (this.metaProfileField == null) {
                    this.metaProfileField = skullMeta.getClass().getDeclaredField("profile");
                    this.metaProfileField.setAccessible(true);
                }
                this.metaProfileField.set(skullMeta, this.makeProfile(string));
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException2) {
                reflectiveOperationException2.printStackTrace();
            }
        }
    }

    private GameProfile makeProfile(String string) {
        UUID uUID = new UUID(string.substring(string.length() - 20).hashCode(), string.substring(string.length() - 10).hashCode());
        GameProfile gameProfile = new GameProfile(uUID, "aaaaa");
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
        return gameProfile;
    }
}

