/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.managers;

import dev.hexedhero.pinprompt.nms.API_1_19_R3_PLUS;
import dev.hexedhero.pinprompt.nms.INMSImplementation;
import dev.hexedhero.pinprompt.nms.NMS_1_14_R1_TO_1_16_R3;
import dev.hexedhero.pinprompt.nms.NMS_1_17_R1;
import dev.hexedhero.pinprompt.nms.NMS_1_18_R1;
import dev.hexedhero.pinprompt.nms.NMS_1_18_R2;
import dev.hexedhero.pinprompt.nms.NMS_1_19_R1_TO_1_19_R2;
import dev.hexedhero.pinprompt.nms.NMS_1_19_R3_PLUS;
import dev.hexedhero.pinprompt.nms.NMS_1_8_R1;
import dev.hexedhero.pinprompt.nms.NMS_1_8_R2_TO_1_13_R2;
import dev.hexedhero.pinprompt.utils.Common;
import dev.hexedhero.pinprompt.utils.VersionHelper;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.InventoryView;

public class NMSManager {
    private INMSImplementation nmsImplementation;
    private static NMSManager instance;

    public static NMSManager getInstance() {
        if (instance == null) {
            instance = new NMSManager();
        }
        return instance;
    }

    private NMSManager() {
        this.setupNMSImplementation((CommandSender)Bukkit.getConsoleSender());
        Common.tellConsole(true, "NMSManager initialized!");
    }

    public void setupNMSImplementation(CommandSender commandSender) {
        try {
            if (VersionHelper.getMajorVersionNumber() >= 20 || InventoryView.class.getMethod("setTitle", String.class) != null) {
                this.nmsImplementation = new API_1_19_R3_PLUS();
                return;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        switch (VersionHelper.getNMSVersion()) {
            case "v1_8_R1": {
                this.nmsImplementation = new NMS_1_8_R1();
                break;
            }
            case "v1_8_R2": 
            case "v1_8_R3": 
            case "v1_9_R1": 
            case "v1_9_R2": 
            case "v1_10_R1": 
            case "v1_11_R1": 
            case "v1_12_R1": 
            case "v1_13_R1": 
            case "v1_13_R2": {
                this.nmsImplementation = new NMS_1_8_R2_TO_1_13_R2();
                break;
            }
            case "v1_14_R1": 
            case "v1_15_R1": 
            case "v1_16_R1": 
            case "v1_16_R2": 
            case "v1_16_R3": {
                this.nmsImplementation = new NMS_1_14_R1_TO_1_16_R3();
                break;
            }
            case "v1_17_R1": {
                this.nmsImplementation = new NMS_1_17_R1();
                break;
            }
            case "v1_18_R1": {
                this.nmsImplementation = new NMS_1_18_R1();
                break;
            }
            case "v1_18_R2": {
                this.nmsImplementation = new NMS_1_18_R2();
                break;
            }
            case "v1_19_R1": 
            case "v1_19_R2": {
                this.nmsImplementation = new NMS_1_19_R1_TO_1_19_R2();
                break;
            }
            case "v1_19_R3": {
                this.nmsImplementation = new NMS_1_19_R3_PLUS();
                break;
            }
            default: {
                Common.tell(commandSender, Common.getLanguagePrefix(commandSender) + "&cNON SUPPORTED MINECRAFT VERSION!");
                Common.tell(commandSender, Common.getLanguagePrefix(commandSender) + "&cUSING LATEST REFLECTION AVAILABLE - MAY NOT WORK, PLEASE UPDATE!");
                Common.tell(commandSender, Common.getLanguagePrefix(commandSender) + "&aUsing NMS v1_19_R3_PLUS...");
                this.nmsImplementation = new NMS_1_19_R3_PLUS();
                return;
            }
        }
    }

    public INMSImplementation getNMSImplementation() {
        return this.nmsImplementation;
    }
}

