/*
 * Decompiled with CFR 0.152.
 */
package dev.hexedhero.pinprompt.utils;

import dev.hexedhero.pinprompt.PINPrompt;
import dev.hexedhero.pinprompt.utils.ColorHelper;
import dev.hexedhero.pinprompt.utils.PluginInformation;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Common {
    private static final DecimalFormat NUMBER_FORMAT_NANO = new DecimalFormat("0.00");
    private static final Collection<String> warnedSounds = new ArrayList<String>();

    private Common() {
    }

    public static void tell(CommandSender commandSender, String ... stringArray) {
        for (String string : stringArray) {
            if (commandSender instanceof Player) {
                commandSender.sendMessage(ColorHelper.colorize(string));
                continue;
            }
            Common.tellConsole(true, string);
        }
    }

    public static void tellConsole(boolean bl, String ... stringArray) {
        for (String string : stringArray) {
            Bukkit.getConsoleSender().sendMessage("[%plugin_name%] ".replace("%plugin_name%", PluginInformation.getName()) + (bl ? ColorHelper.colorize(string) : string));
        }
    }

    public static String nanosToMillis(long l) {
        return NUMBER_FORMAT_NANO.format((double)l / 1000000.0);
    }

    public static void debugToConsole(String string, String ... stringArray) {
        if (!PINPrompt.getInstance().getConfig().getBoolean("Debug Mode")) {
            return;
        }
        Common.tellConsole(true, "&c[DEBUG] " + string + ":");
        for (String string2 : stringArray) {
            Common.tellConsole(false, string2);
        }
    }

    public static String getLanguage(String string, boolean bl) {
        return (bl ? Common.getLanguagePrefix() : "") + PINPrompt.getInstance().getConfig().getString("Language." + string);
    }

    public static List<String> getLanguageList(String string, boolean bl) {
        if (!bl) {
            return PINPrompt.getInstance().getConfig().getStringList("Language." + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : PINPrompt.getInstance().getConfig().getStringList("Language." + string)) {
            arrayList.add(Common.getLanguagePrefix() + string2);
        }
        return arrayList;
    }

    public static String getLanguagePrefix(CommandSender commandSender) {
        return commandSender instanceof Player ? Common.getLanguagePrefix() : "";
    }

    public static String getLanguagePrefix() {
        return PINPrompt.getInstance().getConfig().getString("Language.Prefix");
    }

    public static String getSound(String string) {
        return PINPrompt.getInstance().getConfig().getString("Sound." + string);
    }

    public static void playSound(Player player, Location location, String string) {
        Common.playSound(new HashSet<Player>(Arrays.asList(player)), location, string);
    }

    public static void playSound(Set<Player> set, Location location, String string) {
        float f;
        float f2;
        Sound sound;
        String[] stringArray = string.split(":");
        if (stringArray[0].equalsIgnoreCase("NONE")) {
            return;
        }
        try {
            sound = Sound.valueOf((String)stringArray[0]);
            f2 = Float.parseFloat(stringArray[1]);
            f = Float.parseFloat(stringArray[2]);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
            if (!warnedSounds.contains(string)) {
                Common.tellConsole(true, "&cIncorrect Sound: \"%sound%\"".replace("%sound%", string), "&cPlease change this inside your config.yml to a correct sound of your Minecraft vesion!", "&cAlso make sure you're providing a volume and pitch for the sound.");
                warnedSounds.add(string);
            }
            return;
        }
        for (Player player : set) {
            player.playSound(location, sound, f2, f);
        }
    }

    public static void sendTitle(Player player, String string, String string2) {
        player.sendTitle(ColorHelper.colorize(string), ColorHelper.colorize(string2));
    }
}

