/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.commands;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import deadlydisasters.Main;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class TownyDisasters
implements CommandExecutor,
TabCompleter {
    private Main plugin;

    public TownyDisasters(Main main) {
        this.plugin = main;
        main.getCommand("towndisasters").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!Utils.TownyB) {
            commandSender.sendMessage(Utils.chat("&cTowny has not been detected on the server!"));
            return true;
        }
        if (stringArray.length < 1 || stringArray.length > 2) {
            commandSender.sendMessage(Utils.chat("&c/towndisasters <on|off> [player]"));
            return true;
        }
        if (!(commandSender instanceof Player) && stringArray.length != 2) {
            commandSender.sendMessage(Utils.chat("&c/towndisasters <on|off> <player>"));
            return true;
        }
        if (!((Player)commandSender).hasPermission("deadlydisasters.towny")) {
            commandSender.sendMessage(Utils.chat(this.plugin.getConfig().getString("messages.permission_error")));
            return true;
        }
        Resident resident = null;
        if (stringArray.length == 2) {
            resident = Utils.getTownyAPI().getResident(stringArray[1]);
            if (resident == null) {
                commandSender.sendMessage(Utils.chat("&cCould not find player '" + stringArray[1] + "'"));
                return true;
            }
        } else {
            resident = Utils.getTownyAPI().getResident((Player)commandSender);
        }
        if (resident.getTownOrNull() == null) {
            commandSender.sendMessage(Utils.chat("&cPlayer '" + resident.getName() + "' does not have a town!"));
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("on")) {
            resident.getTownOrNull().addMetaData((CustomDataField)new BooleanDataField("DeadlyDisasters", Boolean.valueOf(true)));
            TownyMessaging.sendPrefixedTownMessage((Town)resident.getTownOrNull(), (String)"Disaster Protection has been Enabled.");
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("off")) {
            resident.getTownOrNull().addMetaData((CustomDataField)new BooleanDataField("DeadlyDisasters", Boolean.valueOf(false)));
            TownyMessaging.sendPrefixedTownMessage((Town)resident.getTownOrNull(), (String)"Disaster Protection has been Disabled.");
            return true;
        }
        commandSender.sendMessage(Utils.chat("&c/towndisasters <on|off> [player]"));
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!commandSender.hasPermission("deadlydisasters.towny")) {
            return arrayList;
        }
        if (stringArray.length == 1) {
            StringUtil.copyPartialMatches((String)stringArray[0], Arrays.asList("on", "off"), arrayList);
            Collections.sort(arrayList);
            return arrayList;
        }
        if (stringArray.length == 2) {
            StringUtil.copyPartialMatches((String)stringArray[1], (Iterable)Bukkit.getServer().getOnlinePlayers().stream().map(player -> player.getName()).collect(Collectors.toList()), arrayList);
            Collections.sort(arrayList);
            return arrayList;
        }
        return arrayList;
    }
}

