/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities;

import deadlydisasters.Main;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public enum CustomEntityType {
    ENDTOTEM("customentities.endstorm_mobs.endtotem", "endtotem", 'd'),
    BABYENDTOTEM("customentities.pets.baby_endtotem", "babyendtotem", 'd'),
    ENDWORM("customentities.endstorm_mobs.endworm", "endworm", 'd'),
    VOIDARCHER("customentities.endstorm_mobs.voidarcher", "voidarcher", 'd'),
    VOIDGUARDIAN("customentities.endstorm_mobs.voidguardian", "voidguardian", 'd'),
    VOIDSTALKER("customentities.endstorm_mobs.voidstalker", "voidstalker", 'd'),
    DARKMAGE("customentities.purge_mobs.darkmage", "darkmage", '8'),
    PRIMEDCREEPER("customentities.purge_mobs.primedcreeper", "primedcreeper", '8'),
    SKELETONKNIGHT("customentities.purge_mobs.skeletonknight", "skeletonknight", '8'),
    TUNNELLER("customentities.purge_mobs.tunneller", "tunnellerzombie", '8'),
    SWAMPBEAST("customentities.purge_mobs.swampbeast", "swampbeast", '8'),
    ZOMBIEKNIGHT("customentities.purge_mobs.zombieknight", "zombieknight", '8'),
    SHADOWLEECH("customentities.purge_mobs.shadowleech", "shadowleech", '8'),
    ANCIENTMUMMY("customentities.sandstorm_mobs.ancientmummy", "ancientmummy", 'e'),
    ANCIENTSKELETON("customentities.sandstorm_mobs.ancientskeleton", "ancientskeleton", 'e'),
    LOSTSOUL("customentities.soulstorm_mobs.lostsoul", "lostsoul", '3'),
    TAMEDLOSTSOUL("customentities.pets.tamed_lostsoul", "tamedlostsoul", '3'),
    SOULREAPER("customentities.soulstorm_mobs.soulreaper", "soulreaper", '3'),
    YETI("customentities.snowstorm_mobs.yeti", "yeti", '9'),
    FIREPHANTOM("customentities.solarstorm_mobs.firephantom", "firephantom", 'c'),
    CURSEDDIVER("customentities.monsoon_mobs.cursed_diver", "curseddiver", '1'),
    INFESTEDSKELETON("customentities.infestedcaves_mobs.infested_skeleton", "infestedskeleton", '3'),
    INFESTEDZOMBIE("customentities.infestedcaves_mobs.infested_zombie", "infestedzombie", '3'),
    INFESTEDCREEPER("customentities.infestedcaves_mobs.infested_creeper", "infestedcreeper", '3'),
    INFESTEDENDERMAN("customentities.infestedcaves_mobs.infested_enderman", "infestedenderman", '3'),
    INFESTEDSPIRIT("customentities.infestedcaves_mobs.infested_spirit", "infestedspirit", '3'),
    INFESTEDTRIBESMAN("customentities.infestedcaves_mobs.infested_tribesman", "infestedtribesman", '3'),
    INFESTEDDEVOURER("customentities.infestedcaves_mobs.infested_devourer", "infesteddevourer", '3'),
    INFESTEDHOWLER("customentities.infestedcaves_mobs.infested_howler", "infestedhowler", '3'),
    INFESTEDWORM("customentities.infestedcaves_mobs.infested_worm", "infestedworm", '3'),
    CHRISTMASELF("customentities.christmas_mobs.elf", "elf", 'c'),
    PETCHRISTMASELF("customentities.pets.pet_elf", "petelf", 'c'),
    FROSTY("customentities.christmas_mobs.frosty", "frosty", 'c'),
    GRINCH("customentities.christmas_mobs.grinch", "grinch", 'c'),
    SANTA("customentities.christmas_mobs.santa", "santa", 'c'),
    RAMPAGINGGOAT("customentities.easter_mobs.rampaging_goat", "rampaginggoat", 'a'),
    EASTERBUNNY("customentities.easter_mobs.easter_bunny", "easterbunny", 'a'),
    KILLERCHICKEN("customentities.easter_mobs.killer_chicken", "killerchicken", 'a'),
    SCARECROW("customentities.halloween_mobs.scarecrow", "scarecrow", '6'),
    GHOUL("customentities.halloween_mobs.ghoul", "ghoul", '6'),
    VAMPIRE("customentities.halloween_mobs.vampire", "vampire", '6'),
    PSYCO("customentities.halloween_mobs.psyco", "psyco", '6'),
    PUMPKINKING("customentities.halloween_mobs.pumpkin_king", "pumpkinking", '6');

    private double health;
    private double damage;
    private double spawnRate;
    private boolean spawning;
    public String configPath;
    public String species;
    public NamespacedKey nameKey;
    private List<String> dropsList;
    private char colChar;
    public static Set<String> speciesList;
    public static YamlConfiguration yaml;
    public static Set<CustomEntityType> bossTypes;

    static {
        speciesList = new HashSet<String>();
        bossTypes = new HashSet<CustomEntityType>(Arrays.asList(SANTA, EASTERBUNNY, PUMPKINKING));
    }

    private CustomEntityType(String string2, String string3, char c) {
        this.configPath = string2;
        this.species = string3;
        this.colChar = c;
    }

    public static void reload(Main main) {
        speciesList.clear();
        CustomEntityType[] customEntityTypeArray = CustomEntityType.values();
        int n = customEntityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomEntityType customEntityType = customEntityTypeArray[n2];
            speciesList.add(customEntityType.species);
            customEntityType.nameKey = new NamespacedKey((Plugin)main, customEntityType.species);
            customEntityType.resetValues();
            if (yaml.contains(String.valueOf(customEntityType.configPath) + ".health")) {
                customEntityType.setHealth(yaml.getDouble(String.valueOf(customEntityType.configPath) + ".health"));
            }
            if (yaml.contains(String.valueOf(customEntityType.configPath) + ".damage")) {
                customEntityType.setDamage(yaml.getDouble(String.valueOf(customEntityType.configPath) + ".damage"));
            }
            if (yaml.getBoolean("settings.allow_custom_mobs") && yaml.contains(String.valueOf(customEntityType.configPath) + ".spawning")) {
                customEntityType.setSpawning(yaml.getBoolean(String.valueOf(customEntityType.configPath) + ".spawning"));
            } else {
                customEntityType.setSpawning(false);
            }
            if (yaml.contains(String.valueOf(customEntityType.configPath) + ".spawnrate") && customEntityType.spawning) {
                customEntityType.setSpawnRate(yaml.getDouble(String.valueOf(customEntityType.configPath) + ".spawnrate"));
            } else {
                customEntityType.setSpawnRate(-1.0);
            }
            if (yaml.getBoolean("settings.allow_custom_drops") && yaml.contains(String.valueOf(customEntityType.configPath) + ".drops")) {
                customEntityType.setDropsList(yaml.getStringList(String.valueOf(customEntityType.configPath) + ".drops"));
            } else {
                customEntityType.setDropsList(new ArrayList<String>());
            }
            ++n2;
        }
    }

    public Object grabCustomSetting(String string) {
        return yaml.get(String.valueOf(this.configPath) + '.' + string);
    }

    public void resetValues() {
        this.spawning = false;
        this.spawnRate = 0.0;
    }

    public static CustomEntityType getCustomEntityType(String string) {
        CustomEntityType[] customEntityTypeArray = CustomEntityType.values();
        int n = customEntityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomEntityType customEntityType = customEntityTypeArray[n2];
            if (customEntityType.species.equals(string)) {
                return customEntityType;
            }
            ++n2;
        }
        return null;
    }

    public static void saveDataFile(Main main) {
        try {
            yaml.save(new File(main.getDataFolder().getAbsolutePath(), "entities.yml"));
        }
        catch (IOException iOException) {
            Main.consoleSender.sendMessage(Utils.chat(String.valueOf(Languages.prefix) + "&cError #00 Unable to save data file!"));
        }
    }

    public double getHealth() {
        return this.health;
    }

    public void setHealth(double d) {
        this.health = d;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double d) {
        this.damage = d;
    }

    public double getSpawnRate() {
        return this.spawnRate;
    }

    public void setSpawnRate(double d) {
        this.spawnRate = d;
    }

    public boolean canSpawn() {
        return this.spawning;
    }

    public void setSpawning(boolean bl) {
        this.spawning = bl;
    }

    public List<String> getDropsList() {
        return this.dropsList;
    }

    public void setDropsList(List<String> list) {
        this.dropsList = list;
    }

    public char getColChar() {
        return this.colChar;
    }

    public void setColChar(char c) {
        this.colChar = c;
    }
}

