/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.christmasentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Frosty
extends CustomEntity {
    private int iceCooldown = 0;
    private int tpCooldown = 10;
    private int iceRadius = 10;
    private LivingEntity target;
    private Random rand;

    public Frosty(Snowman snowman, Main main, Random random) {
        super((Mob)snowman, main);
        this.rand = random;
        this.entityType = CustomEntityType.FROSTY;
        this.species = this.entityType.species;
        snowman.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        snowman.setDerp(true);
        snowman.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        snowman.setHealth(this.entityType.getHealth());
        snowman.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.2);
        snowman.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        snowman.setCanPickupItems(false);
        snowman.setMetadata("dd-frosty", (MetadataValue)main.fixedData);
        snowman.setMetadata("dd-christmasmob", (MetadataValue)main.fixedData);
        if (snowman.getCustomName() == null) {
            snowman.setCustomName(Languages.getString("entities.frosty"));
        }
        snowman.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation().add(0.0, 1.1, 0.0), 5, 0.3, 0.3, 0.3, 1.0, (Object)Material.PACKED_ICE.createBlockData());
        this.entity.getWorld().spawnParticle(Particle.FALLING_DUST, this.entity.getLocation().add(0.0, 1.2, 0.0), 2, 0.3, 0.4, 0.3, 1.0, (Object)Material.PACKED_ICE.createBlockData());
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.entity.isDead()) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.entity.getTarget() == null) {
            for (Entity entity : this.entity.getWorld().getNearbyEntities(this.entity.getLocation(), 15.0, 15.0, 15.0)) {
                if (!(entity instanceof Player) || Utils.isPlayerImmune((Player)entity)) continue;
                this.entity.setTarget((LivingEntity)entity);
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_GHAST_DEATH, SoundCategory.HOSTILE, 2.0f, 0.8f);
                break;
            }
        } else if (this.entity.getTarget().isDead() || this.entity.getTarget() instanceof Player && Utils.isPlayerImmune((Player)this.entity.getTarget())) {
            this.entity.setTarget(null);
        }
        if (this.iceCooldown > 0) {
            --this.iceCooldown;
        } else if (this.tpCooldown <= 11 && this.entity.getTarget() != null && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 81.0) {
            this.createIceSpell(this.entity.getLocation(), Utils.getVectorTowards(this.entity.getLocation(), this.entity.getTarget().getLocation()), this.iceRadius);
            this.iceCooldown = 12;
            return;
        }
        if (this.tpCooldown > 0) {
            --this.tpCooldown;
        } else if (this.iceCooldown <= 4 && this.entity.getTarget() != null && this.entity.isOnGround() && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) >= 225.0 && !this.entity.getLocation().getBlock().getRelative(BlockFace.DOWN).isPassable() && !this.entity.getLocation().getBlock().getRelative(BlockFace.DOWN, 2).isPassable() && !this.entity.getLocation().getBlock().getRelative(BlockFace.DOWN, 3).isPassable()) {
            Entity entity;
            entity = null;
            int n = 0;
            while (n < 10) {
                entity = Utils.findSmartYSpawn(this.entity.getTarget().getLocation(), Utils.getSpotInSquareRadius(this.entity.getTarget().getLocation(), 3), 2, 4);
                if (entity != null && !entity.getBlock().getRelative(BlockFace.DOWN).isPassable() && !entity.getBlock().getRelative(BlockFace.DOWN, 2).isPassable() && !entity.getBlock().getRelative(BlockFace.DOWN, 3).isPassable()) break;
                ++n;
            }
            if (entity == null) {
                return;
            }
            final Location location = entity.getBlock().getRelative(BlockFace.DOWN).getLocation();
            final Material material = location.getBlock().getType();
            this.target = this.entity.getTarget();
            this.tpCooldown = 15;
            this.entity.setAI(false);
            this.entity.setGravity(false);
            float f = this.entity.getLocation().getYaw();
            this.entity.teleport(this.entity.getLocation().getBlock().getLocation().add(0.5, 0.0, 0.5));
            this.entity.setRotation(f, 70.0f);
            final Block block = this.entity.getLocation().getBlock().getRelative(BlockFace.DOWN);
            final Material material2 = block.getType();
            if (!(block.getState() instanceof InventoryHolder || Utils.isBlockImmune(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                block.setType(Material.PACKED_ICE);
            }
            final int[] nArray = new int[1];
            new RepeatingTask(this.plugin, 0, 1){

                @Override
                public void run() {
                    if (Frosty.this.entity == null) {
                        if (block != null && block.getType() == Material.PACKED_ICE) {
                            block.setType(material2);
                        }
                        if (location != null && location.getBlock().getType() == Material.PACKED_ICE) {
                            location.getBlock().setType(material);
                        }
                        this.cancel();
                        return;
                    }
                    nArray[0] = nArray[0] + 1;
                    if (nArray[0] <= 30) {
                        Frosty.this.entity.teleport(Frosty.this.entity.getLocation().add(0.0, -0.07, 0.0));
                        Frosty.this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 1.0, 0.5), 7, 0.3, 0.2, 0.3, 1.0, (Object)Material.PACKED_ICE.createBlockData());
                        if (nArray[0] % 5 == 0) {
                            Frosty.this.entity.getWorld().playSound(block.getLocation(), Sound.BLOCK_GLASS_HIT, SoundCategory.HOSTILE, 1.0f, 0.5f);
                        }
                        return;
                    }
                    if (nArray[0] == 40) {
                        if (!(block.getState() instanceof InventoryHolder || Utils.isBlockImmune(location.getBlock().getType()) || Utils.isZoneProtected(location.getBlock().getLocation()))) {
                            location.getBlock().setType(Material.PACKED_ICE);
                        }
                        Frosty.this.entity.teleport(location.getBlock().getRelative(BlockFace.DOWN).getLocation().add(0.5, 0.0, 0.5));
                        return;
                    }
                    if (nArray[0] > 40 && nArray[0] <= 60) {
                        Frosty.this.entity.teleport(Frosty.this.entity.getLocation().add(0.0, 0.0666, 0.0));
                        Frosty.this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, location.clone().add(0.5, 1.0, 0.5), 7, 0.3, 0.2, 0.3, 1.0, (Object)Material.PACKED_ICE.createBlockData());
                        if (nArray[0] % 5 == 0) {
                            Frosty.this.entity.getWorld().playSound(location, Sound.BLOCK_GLASS_HIT, SoundCategory.HOSTILE, 1.0f, 0.5f);
                        }
                        if (Frosty.this.target != null && Frosty.this.target.getWorld().equals(Frosty.this.entity.getWorld())) {
                            Utils.makeEntityFaceLocation((Entity)Frosty.this.entity, Frosty.this.target.getLocation());
                        }
                        return;
                    }
                    if (nArray[0] > 60) {
                        Frosty.this.entity.setAI(true);
                        Frosty.this.entity.setGravity(true);
                        Frosty.this.entity.setTarget(Frosty.this.target);
                        this.cancel();
                        Frosty.this.plugin.getServer().getScheduler().runTaskLater((Plugin)Frosty.this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                if (block.getType() == Material.PACKED_ICE) {
                                    block.setType(material2);
                                }
                                if (location.getBlock().getType() == Material.PACKED_ICE) {
                                    location.getBlock().setType(material);
                                }
                            }
                        }, 200L);
                    }
                }
            };
            return;
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void createIceSpell(Location location, final Vector vector, final int n) {
        final World world = location.getWorld();
        final Vector vector2 = new Vector(vector.getZ(), 0.0, -vector.getX());
        final Location location2 = location.clone().add(vector.clone().multiply(-2)).add(vector2.clone().multiply(-4));
        final HashMap hashMap = new HashMap();
        int[] nArray = new int[2];
        nArray[0] = n * 2 + 4;
        final int[] nArray2 = nArray;
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                if (nArray2[1] % 2 == 0 && nArray2[0] >= 0) {
                    Block block;
                    int n2;
                    if (nArray2[0] <= 4 || nArray2[0] >= n) {
                        n2 = 2;
                        while (n2 < 6) {
                            block = Utils.getHighestExposedBlock(location2.clone().add(vector2.clone().multiply(n2)), 3);
                            if (!(block == null || hashMap.containsKey(block) || block.getState() instanceof InventoryHolder || Utils.isBlockImmune(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                hashMap.put(block, block.getState());
                                block.setType(Material.PACKED_ICE);
                                world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 1.0, 0.5), 5, 0.4, 0.3, 0.4, 1.0, (Object)Material.PACKED_ICE.createBlockData());
                            }
                            ++n2;
                        }
                    } else {
                        n2 = 0;
                        while (n2 < 9) {
                            block = Utils.getHighestExposedBlock(location2.clone().add(vector2.clone().multiply(n2)), 3);
                            if (!(block == null || hashMap.containsKey(block) || block.getState() instanceof InventoryHolder || Utils.isBlockImmune(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                hashMap.put(block, block.getState());
                                block.setType(Material.PACKED_ICE);
                                world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 1.0, 0.5), 5, 0.4, 0.3, 0.4, 1.0, (Object)Material.PACKED_ICE.createBlockData());
                            }
                            ++n2;
                        }
                    }
                    if (((Frosty)Frosty.this).plugin.mcVersion >= 1.17) {
                        world.playSound(location2, Sound.ENTITY_PLAYER_HURT_FREEZE, SoundCategory.BLOCKS, 0.6f, 0.5f);
                    }
                    location2.add(vector.clone().multiply(0.5));
                    nArray2[0] = nArray2[0] - 1;
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (((Block)entry.getKey()).getType() != Material.PACKED_ICE) continue;
                    if (Frosty.this.rand.nextInt(5) == 0) {
                        world.spawnParticle(Particle.FALLING_DUST, ((Block)entry.getKey()).getLocation().add(0.5, 1.0, 0.5), 1, 0.3, 0.1, 0.3, 1.0, (Object)Material.PACKED_ICE.createBlockData());
                    }
                    for (Entity entity : world.getNearbyEntities(((Block)entry.getKey()).getLocation().add(0.5, 1.5, 0.5), 0.5, 0.5, 0.5)) {
                        if (entity.hasMetadata("dd-christmasmob")) continue;
                        Vector vector3 = new Vector(entity.getVelocity().getX() / 8.0, entity.getVelocity().getY(), entity.getVelocity().getZ() / 8.0);
                        if (vector3.getY() > 0.0) {
                            vector3.setY(vector3.getY() / 8.0);
                        }
                        entity.setVelocity(vector3);
                        if (((Frosty)Frosty.this).plugin.mcVersion >= 1.17) {
                            entity.setFreezeTicks(220);
                        }
                        if (!(((Frosty)Frosty.this).plugin.mcVersion >= 1.17) || !(entity instanceof Player) || nArray2[1] % 5 != 0) continue;
                        world.playSound(entity.getLocation(), Sound.ENTITY_PLAYER_HURT_FREEZE, SoundCategory.BLOCKS, 0.2f, 0.5f);
                    }
                }
                if (nArray2[1] >= 200) {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (((Block)entry.getKey()).getType() != Material.PACKED_ICE) continue;
                        ((BlockState)entry.getValue()).update(true);
                    }
                    this.cancel();
                }
                nArray2[1] = nArray2[1] + 1;
            }
        };
    }
}

