/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.christmasentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.entities.christmasentities.Elf;
import deadlydisasters.entities.christmasentities.Frosty;
import deadlydisasters.entities.christmasentities.Grinch;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.DDSong;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.SongMaker;
import deadlydisasters.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Santa
extends CustomEntity {
    private int cooldown = 5;
    private Random rand;
    private Present[] presents = new Present[3];
    private BossBar bar;
    public SongMaker songMaker;
    public static Set<Block> snowGlobeBlocks = new HashSet<Block>();

    public Santa(Zombie zombie, Main main, Random random) {
        super((Mob)zombie, main);
        this.rand = random;
        this.entityType = CustomEntityType.SANTA;
        this.species = this.entityType.species;
        zombie.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        if (main.mcVersion >= 1.16) {
            zombie.setAdult();
        } else {
            zombie.setBaby(false);
        }
        ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), CustomHead.SANTA.getHead()};
        int n = 0;
        while (n < 3) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStackArray[n].getItemMeta();
            leatherArmorMeta.setColor(Color.fromBGR((int)0, (int)0, (int)220));
            itemStackArray[n].setItemMeta((ItemMeta)leatherArmorMeta);
            ++n;
        }
        zombie.getEquipment().setArmorContents(itemStackArray);
        zombie.getEquipment().setHelmetDropChance(0.0f);
        zombie.getEquipment().setChestplateDropChance(0.0f);
        zombie.getEquipment().setLeggingsDropChance(0.0f);
        zombie.getEquipment().setBootsDropChance(0.0f);
        zombie.setCanPickupItems(false);
        zombie.setSilent(true);
        zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        zombie.setHealth(this.entityType.getHealth());
        zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
        zombie.setMetadata("dd-santa", (MetadataValue)main.fixedData);
        zombie.setMetadata("dd-christmasmob", (MetadataValue)main.fixedData);
        if (zombie.getCustomName() == null) {
            zombie.setCustomName(Languages.getString("entities.santa"));
        }
        this.bar = Bukkit.createBossBar((String)Utils.chat("&c" + Languages.getString("entities.santa")), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[]{BarFlag.DARKEN_SKY, BarFlag.CREATE_FOG});
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        this.bar.setProgress(Utils.clamp(1.0 / this.entityType.getHealth() * this.entity.getHealth(), 0.0, 1.0));
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_VILLAGER_HURT, SoundCategory.HOSTILE, 2.0f, 0.6f);
        }
        this.entity.getWorld().spawnParticle(Particle.FALLING_DUST, this.entity.getLocation().add(0.0, 1.2, 0.0), 1, 0.3, 0.5, 0.3, 1.0, (Object)Material.SNOW.createBlockData());
        this.entity.getWorld().spawnParticle(Particle.FALLING_DUST, this.entity.getLocation().add(0.0, 1.2, 0.0), 1, 0.3, 0.5, 0.3, 1.0, (Object)Material.RED_WOOL.createBlockData());
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            this.clean();
            if (this.songMaker != null) {
                this.songMaker.stopSong();
            }
            return;
        }
        if (this.entity.isDead()) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_VILLAGER_DEATH, SoundCategory.HOSTILE, 2.0f, 0.5f);
            CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType, true);
            this.bar.removeAll();
            iterator.remove();
            this.clean();
            if (this.songMaker != null) {
                this.songMaker.stopSong();
            }
            return;
        }
        if (this.rand.nextInt(3) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_VILLAGER_CELEBRATE, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
        this.bar.removeAll();
        if (this.songMaker != null) {
            this.songMaker.removeAll();
        }
        for (Entity entity : this.entity.getNearbyEntities(40.0, 40.0, 40.0)) {
            if (!(entity instanceof Player)) continue;
            this.bar.addPlayer((Player)entity);
            if (this.songMaker == null) continue;
            this.songMaker.addPlayer((Player)entity);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.entity.getTarget() != null && this.entity.getTarget().getWorld().equals(this.entity.getWorld()) && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 225.0) {
            this.cooldown = 15;
            this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 40, 10, true, false));
            this.entity.swingMainHand();
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_SNOW_GOLEM_SHOOT, SoundCategory.HOSTILE, 2.0f, 0.5f);
            this.clean();
            int n = 5;
            int n2 = 0;
            for (Entity entity : this.entity.getNearbyEntities(30.0, 30.0, 30.0)) {
                if (!entity.hasMetadata("dd-christmasmob")) continue;
                ++n2;
            }
            if (n2 >= 9) {
                n = 2;
            }
            this.presents[0] = new Present(this.rand.nextInt(n), new Vector(0.5, 0.8, 0.0));
            this.presents[1] = new Present(this.rand.nextInt(n), new Vector(-0.5, 0.8, 0.5));
            this.presents[2] = new Present(this.rand.nextInt(n), new Vector(-0.5, 0.8, -0.5));
        }
    }

    @Override
    public void clean() {
        int n = 0;
        while (n < 3) {
            if (this.presents[n] != null) {
                if (this.presents[n].stand != null) {
                    this.presents[n].stand.remove();
                }
                if (this.presents[n].projectile != null) {
                    this.presents[n].projectile.remove();
                }
            }
            ++n;
        }
        this.bar.removeAll();
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    public static void summonSanta(Main main, final Block block) {
        snowGlobeBlocks.add(block);
        final World world = block.getWorld();
        Location location = new Location(world, (double)(block.getLocation().getBlockX() + (main.random.nextInt(16) - 8)), Math.max(150.0, block.getLocation().getY() + 50.0), (double)(block.getLocation().getBlockZ() - 150));
        final Boat boat = (Boat)world.spawnEntity(location.clone().add(150.0, 300.0, 0.0), EntityType.BOAT);
        boat.teleport(location);
        boat.setInvulnerable(true);
        final Zombie zombie = (Zombie)world.spawnEntity(location.clone().add(150.0, 300.0, 0.0), EntityType.ZOMBIE, false);
        zombie.setRemoveWhenFarAway(false);
        zombie.teleport(location.clone().add(0.0, 0.0, -9.5));
        final Santa santa = new Santa(zombie, main, main.random);
        main.handler.addEntity(santa);
        Location[] locationArray = new Location[]{location.clone().add(1.0, 0.0, -7.0), location.clone().add(-1.0, 0.0, -7.0), location.clone().add(1.0, 0.0, -2.0), location.clone().add(-1.0, 0.0, -2.0)};
        Location location2 = location.clone().add(150.0, 300.0, 0.0);
        final Horse[] horseArray = new Horse[]{(Horse)world.spawnEntity(location2, EntityType.HORSE, false), (Horse)world.spawnEntity(location2, EntityType.HORSE, false), (Horse)world.spawnEntity(location2, EntityType.HORSE, false), (Horse)world.spawnEntity(location2, EntityType.HORSE, false)};
        int n = 0;
        while (n < 4) {
            horseArray[n].teleport(locationArray[n]);
            horseArray[n].setLeashHolder((Entity)boat);
            horseArray[n].setColor(Horse.Color.BROWN);
            ++n;
        }
        final boolean[] blArray = new boolean[1];
        final SongMaker songMaker = new SongMaker(DDSong.CHRISTMAS_THEME);
        for (Entity entity : world.getNearbyEntities(block.getLocation(), 30.0, 30.0, 30.0)) {
            if (!(entity instanceof Player)) continue;
            songMaker.addPlayer((Player)entity);
        }
        songMaker.setLoop(true);
        songMaker.setVolume((float)((Double)CustomEntityType.SANTA.grabCustomSetting("boss_music_volume")).doubleValue());
        if (((Boolean)CustomEntityType.SANTA.grabCustomSetting("play_boss_music")).booleanValue()) {
            songMaker.playSong();
        }
        new RepeatingTask(main, 0, 1){

            @Override
            public void run() {
                world.spawnParticle(Particle.SNOWFLAKE, block.getLocation().add(0.5, 0.3, 0.5), 1, 0.2, 0.2, 0.2, 1.0E-4);
                if (!blArray[0] && boat.getLocation().getZ() >= block.getLocation().getZ()) {
                    zombie.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 80, 100, true, false));
                    blArray[0] = true;
                    santa.songMaker = songMaker;
                } else if (boat == null || boat.isDead() || boat.getLocation().getZ() >= block.getLocation().getZ() + 150.0) {
                    Horse[] horseArray2 = horseArray;
                    int n = horseArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Horse horse = horseArray2[n2];
                        if (horse != null) {
                            horse.remove();
                        }
                        ++n2;
                    }
                    if (boat != null) {
                        boat.remove();
                    }
                    this.cancel();
                    block.setType(Material.AIR);
                    world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 0.3, 0.5), 30, 0.2, 0.2, 0.2, 1.0E-4, (Object)Material.SNOW.createBlockData());
                    world.playSound(block.getLocation().add(0.5, 0.3, 0.5), Sound.BLOCK_GLASS_BREAK, SoundCategory.BLOCKS, 1.0f, 0.5f);
                    snowGlobeBlocks.remove(block);
                    zombie.setRemoveWhenFarAway(true);
                    return;
                }
                Vector vector = new Vector(0, 0, 1);
                boat.eject();
                Horse[] horseArray3 = horseArray;
                int n = horseArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Horse horse = horseArray3[n3];
                    if (horse != null) {
                        horse.setVelocity(vector);
                    }
                    ++n3;
                }
                boat.setVelocity(vector.clone().multiply(1.1).setY(0.04));
                if (!blArray[0]) {
                    zombie.setVelocity(vector);
                }
            }
        };
    }

    class Present {
        private ArmorStand stand;
        private Slime projectile;
        private BlockData trail;

        public Present(final int n, Vector vector) {
            this.stand = Utils.lockArmorStand((ArmorStand)Santa.this.entity.getWorld().spawnEntity(Santa.this.entity.getLocation().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND), true, false, true);
            this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
            switch (n) {
                case 4: {
                    this.stand.getEquipment().setHelmet(CustomHead.GGIFT.getHead());
                    this.trail = Material.LIME_WOOL.createBlockData();
                    break;
                }
                case 3: {
                    this.stand.getEquipment().setHelmet(CustomHead.BGIFT.getHead());
                    this.trail = Material.LIGHT_BLUE_WOOL.createBlockData();
                    break;
                }
                case 2: {
                    this.stand.getEquipment().setHelmet(CustomHead.YGIFT.getHead());
                    this.trail = Material.YELLOW_WOOL.createBlockData();
                    break;
                }
                case 1: {
                    this.stand.getEquipment().setHelmet(CustomHead.PGIFT.getHead());
                    this.trail = Material.PURPLE_WOOL.createBlockData();
                    break;
                }
                default: {
                    this.stand.getEquipment().setHelmet(CustomHead.WGIFT.getHead());
                    this.trail = Material.RED_WOOL.createBlockData();
                }
            }
            this.projectile = (Slime)Santa.this.entity.getWorld().spawnEntity(Santa.this.entity.getLocation().add(0.0, 100.0, 0.0), EntityType.SLIME);
            this.projectile.setSize(0);
            this.projectile.setSilent(true);
            this.projectile.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(100.0);
            this.projectile.setHealth(100.0);
            this.projectile.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(0.0);
            this.projectile.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
            this.projectile.teleport((Entity)Santa.this.entity);
            this.projectile.teleport(this.projectile.getLocation().add(0.0, 1.0, 0.0));
            this.projectile.setVelocity(vector);
            new RepeatingTask(Santa.this.plugin, 0, 1){

                @Override
                public void run() {
                    if (Present.this.stand == null || Present.this.stand.isDead() || Present.this.projectile == null || Present.this.projectile.isDead() || Santa.this.entity == null) {
                        if (Present.this.stand != null) {
                            Present.this.stand.remove();
                        }
                        if (Present.this.projectile != null) {
                            Present.this.projectile.remove();
                        }
                        this.cancel();
                        return;
                    }
                    Present.this.stand.teleport(Present.this.projectile.getLocation().add(0.0, -2.0, 0.0));
                    Present.this.stand.getWorld().spawnParticle(Particle.BLOCK_CRACK, Present.this.stand.getLocation().add(0.0, 2.0, 0.0), 2, 0.1, 0.1, 0.1, 1.0, (Object)Present.this.trail);
                    if (Present.this.projectile.isOnGround()) {
                        Present.this.stand.getWorld().spawnParticle(Particle.BLOCK_CRACK, Present.this.stand.getLocation().add(0.0, 2.0, 0.0), 30, 0.7, 0.7, 0.7, 1.0, (Object)Present.this.trail);
                        switch (n) {
                            case 4: {
                                Mob mob = (Mob)Present.this.projectile.getWorld().spawnEntity(Present.this.projectile.getLocation(), EntityType.ZOMBIE);
                                ((Santa)((Present)Present.this).Santa.this).plugin.handler.addEntity(new Grinch(mob, Santa.this.plugin, ((Present)Present.this).Santa.this.rand));
                                if (Santa.this.entity.getTarget() == null || Santa.this.entity.getTarget().isDead()) break;
                                mob.setTarget(Santa.this.entity.getTarget());
                                break;
                            }
                            case 3: {
                                Snowman snowman = (Snowman)Present.this.projectile.getWorld().spawnEntity(Present.this.projectile.getLocation(), EntityType.SNOWMAN);
                                ((Santa)((Present)Present.this).Santa.this).plugin.handler.addEntity(new Frosty(snowman, Santa.this.plugin, ((Present)Present.this).Santa.this.rand));
                                if (Santa.this.entity.getTarget() == null || Santa.this.entity.getTarget().isDead()) break;
                                snowman.setTarget(Santa.this.entity.getTarget());
                                break;
                            }
                            case 2: {
                                int n2 = 0;
                                while (n2 < 3) {
                                    Zombie zombie = (Zombie)Present.this.projectile.getWorld().spawnEntity(Present.this.projectile.getLocation(), EntityType.ZOMBIE);
                                    ((Santa)((Present)Present.this).Santa.this).plugin.handler.addEntity(new Elf(zombie, Santa.this.plugin, ((Present)Present.this).Santa.this.rand));
                                    if (Santa.this.entity.getTarget() != null && !Santa.this.entity.getTarget().isDead()) {
                                        zombie.setTarget(Santa.this.entity.getTarget());
                                    }
                                    ++n2;
                                }
                                break;
                            }
                            case 1: {
                                Present.this.createIceSpell(Present.this.projectile.getLocation(), 5);
                                break;
                            }
                            default: {
                                Present.this.projectile.getWorld().createExplosion(Present.this.projectile.getLocation(), 3.5f, true, true);
                            }
                        }
                        Present.this.stand.remove();
                        Present.this.projectile.remove();
                        this.cancel();
                        return;
                    }
                }
            };
        }

        private void createIceSpell(final Location location, final int n) {
            final World world = location.getWorld();
            final HashMap hashMap = new HashMap();
            final int[] nArray = new int[2];
            new RepeatingTask(Santa.this.plugin, 0, 1){

                @Override
                public void run() {
                    if (nArray[1] % 2 == 0 && nArray[0] <= n) {
                        BlockVector object = new BlockVector(location.getX(), location.getY(), location.getZ());
                        int n3 = -nArray[0];
                        while (n3 < nArray[0]) {
                            int n2 = -nArray[0];
                            while (n2 < nArray[0]) {
                                Block block;
                                Vector vector = object.clone().add(new Vector(n3, 0, n2));
                                double d = object.distance(vector);
                                if (!(d > (double)nArray[0] || d < (double)(nArray[0] - 1) || (block = Utils.getHighestExposedBlock(vector.toLocation(location.getWorld()), 3)) == null || hashMap.containsKey(block) || Utils.isBlockImmune(block.getType()) || Utils.isZoneProtected(block.getLocation()))) {
                                    hashMap.put(block, block.getState());
                                    block.setType(Material.PACKED_ICE);
                                    world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 1.0, 0.5), 5, 0.4, 0.3, 0.4, 1.0, (Object)Material.PACKED_ICE.createBlockData());
                                }
                                ++n2;
                            }
                            ++n3;
                        }
                        if (((Santa)((Present)Present.this).Santa.this).plugin.mcVersion >= 1.17) {
                            world.playSound(location, Sound.ENTITY_PLAYER_HURT_FREEZE, SoundCategory.BLOCKS, 0.6f, 0.5f);
                        }
                        nArray[0] = nArray[0] + 1;
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (((Block)entry.getKey()).getType() != Material.PACKED_ICE) continue;
                        if (((Present)Present.this).Santa.this.rand.nextInt(5) == 0) {
                            world.spawnParticle(Particle.FALLING_DUST, ((Block)entry.getKey()).getLocation().add(0.5, 1.0, 0.5), 1, 0.3, 0.1, 0.3, 1.0, (Object)Material.PACKED_ICE.createBlockData());
                        }
                        for (Entity entity : world.getNearbyEntities(((Block)entry.getKey()).getLocation().add(0.5, 1.5, 0.5), 0.5, 0.5, 0.5)) {
                            if (entity.hasMetadata("dd-christmasmob")) continue;
                            Vector vector = new Vector(entity.getVelocity().getX() / 8.0, entity.getVelocity().getY(), entity.getVelocity().getZ() / 8.0);
                            if (vector.getY() > 0.0) {
                                vector.setY(vector.getY() / 8.0);
                            }
                            entity.setVelocity(vector);
                            if (((Santa)((Present)Present.this).Santa.this).plugin.mcVersion >= 1.17) {
                                entity.setFreezeTicks(220);
                            }
                            if (!(((Santa)((Present)Present.this).Santa.this).plugin.mcVersion >= 1.17) || !(entity instanceof Player) || nArray[1] % 5 != 0) continue;
                            world.playSound(entity.getLocation(), Sound.ENTITY_PLAYER_HURT_FREEZE, SoundCategory.BLOCKS, 0.2f, 0.5f);
                        }
                    }
                    if (nArray[1] >= 200) {
                        for (Map.Entry entry : hashMap.entrySet()) {
                            if (((Block)entry.getKey()).getType() != Material.PACKED_ICE) continue;
                            ((BlockState)entry.getValue()).update(true);
                        }
                        this.cancel();
                    }
                    nArray[1] = nArray[1] + 1;
                }
            };
        }
    }
}

