/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.easterentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.specialevents.EasterEventHandler;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;

public class RampagingGoat
extends CustomEntity {
    private Random rand;
    private int cooldown;

    public RampagingGoat(Goat goat, Main main) {
        super((Mob)goat, main);
        this.rand = main.random;
        this.entityType = CustomEntityType.RAMPAGINGGOAT;
        this.species = this.entityType.species;
        goat.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        goat.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        goat.setHealth(this.entityType.getHealth());
        goat.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        goat.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
        goat.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        goat.setMetadata("dd-rampaginggoat", (MetadataValue)main.fixedData);
        if (goat.getCustomName() == null) {
            goat.setCustomName(Languages.getString("easter.rampagingGoat"));
        }
        goat.setRemoveWhenFarAway(true);
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        int n = 0;
        while (n < 8) {
            Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)(this.rand.nextInt(125) + 25), (int)255, (int)(this.rand.nextInt(55) + 25)), Color.fromRGB((int)25, (int)(this.rand.nextInt(155) + 100), (int)255), this.rand.nextFloat());
            if (this.rand.nextInt(2) == 0) {
                dustTransition = new Particle.DustTransition(Color.fromRGB((int)(this.rand.nextInt(105) + 150), (int)25, (int)255), Color.fromRGB((int)25, (int)(this.rand.nextInt(155) + 100), (int)255), this.rand.nextFloat() / 2.0f);
            }
            this.entity.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, this.entity.getLocation().add(this.rand.nextDouble() * 1.5 - 0.75, 0.7 + (this.rand.nextDouble() * 1.5 - 0.75), this.rand.nextDouble() * 1.5 - 0.75), 1, 0.0, 0.0, 0.0, 0.001, (Object)dustTransition);
            ++n;
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.entity.isDead()) {
            if (this.entity != null && this.entity.getKiller() != null && this.plugin.eventHandler.isEnabled && this.plugin.eventHandler instanceof EasterEventHandler && !((EasterEventHandler)this.plugin.eventHandler).eggs[2].hasAchieved(this.entity.getKiller().getUniqueId())) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType, true);
                ((EasterEventHandler)this.plugin.eventHandler).eggs[2].addProgress(this.entity.getKiller().getUniqueId(), 1);
            }
            iterator.remove();
            return;
        }
        if (this.cooldown-- > 0) {
            return;
        }
        Utils.mergeEntityData((Entity)this.entity, "{Brain:{memories:{\"minecraft:ram_cooldown_ticks\":{value:0},\"minecraft:long_jump_cooling_down\":{value:0}}}}");
        this.cooldown = 5;
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

