/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.endstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;

public class EndTotem
extends CustomEntity {
    private ArmorStand[] stands = new ArmorStand[4];
    private int locked = 1;
    private int timer = 3;
    private int animTicks;
    private Random rand;
    private boolean animation;

    public EndTotem(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.ENDTOTEM;
        this.rand = random;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        World world = mob.getWorld();
        Location location = mob.getLocation().clone().add(150.0, 100.0, 0.0);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.endTotem"));
        }
        this.stands[0] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
        this.equipHands(this.stands[0], Material.END_PORTAL_FRAME, Material.CHORUS_PLANT, Material.CHORUS_FLOWER);
        this.stands[1] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
        this.equipHands(this.stands[1], Material.PURPUR_PILLAR, Material.CHORUS_PLANT, Material.CHORUS_FLOWER);
        this.stands[2] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
        this.equipHands(this.stands[2], Material.OBSIDIAN, Material.CHORUS_FLOWER, Material.CHORUS_PLANT);
        this.stands[2].setLeftArmPose(new EulerAngle(0.5, 0.5, -1.8));
        this.stands[2].setRotation(90.0f, 0.0f);
        this.stands[3] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
        this.lockStand(this.stands[3]);
        this.stands[3].getEquipment().setHelmet(new ItemStack(Material.OBSIDIAN));
        this.stands[0].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.stands[1].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.stands[2].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.stands[3].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        if (main.mcVersion >= 1.16) {
            mob.getAttribute(Attribute.GENERIC_ATTACK_KNOCKBACK).setBaseValue(5.0);
        }
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.32);
        mob.setMetadata("dd-endtotem", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        mob.setSilent(true);
        mob.setCanPickupItems(false);
    }

    @Override
    public void tick() {
        Location location;
        if (this.entity == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMAN_HURT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        if (!this.animation && this.entity.hasMetadata("dd-animation")) {
            this.entity.removeMetadata("dd-animation", (Plugin)this.plugin);
            this.animation = true;
            this.animTicks = 15;
        }
        ArmorStand[] armorStandArray = this.stands;
        int n = this.stands.length;
        int n2 = 0;
        while (n2 < n) {
            location = armorStandArray[n2];
            if (location == null) {
                return;
            }
            ++n2;
        }
        location = this.entity.getLocation();
        this.stands[0].setHeadPose(new EulerAngle(Math.toRadians(location.getPitch()), 0.0, 0.0));
        if (this.plugin.mcVersion >= 1.16) {
            this.entity.getWorld().spawnParticle(Particle.REVERSE_PORTAL, location.clone().add(0.0, 1.0, 0.0), 7, 0.5, 0.75, 0.5, 0.01);
        }
        if (this.animation) {
            float f = this.stands[0].getLocation().getYaw();
            this.stands[0].teleport(location.clone().add(0.0, 1.0, 0.0));
            this.stands[0].setRotation(f + 30.0f, 0.0f);
            f = this.stands[1].getLocation().getYaw();
            this.stands[1].teleport(location.clone().add(0.0, 0.2, 0.0));
            this.stands[1].setRotation(f - 30.0f, 0.0f);
            f = this.stands[2].getLocation().getYaw();
            this.stands[2].teleport(location.clone().subtract(0.0, 0.55, 0.0));
            this.stands[2].setRotation(f + 30.0f, 0.0f);
            f = this.stands[3].getLocation().getYaw();
            this.stands[3].teleport(location.clone().subtract(0.0, 1.3, 0.0));
            this.stands[3].setRotation(f + 30.0f, 0.0f);
            this.entity.getWorld().spawnParticle(Particle.DRAGON_BREATH, location.clone().add(0.0, 1.0, 0.0), 7, 0.2, 0.2, 0.2, 0.2);
            --this.animTicks;
            if (this.animTicks <= 0) {
                this.animation = false;
            }
            return;
        }
        Location location2 = null;
        if (this.locked >= 0) {
            location2 = this.stands[this.locked].getLocation().clone();
        }
        this.stands[0].teleport(location.clone().add(0.0, 1.0, 0.0));
        this.stands[1].teleport(location.clone().add(0.0, 0.2, 0.0));
        this.stands[1].setRotation(location.getYaw() + 90.0f, 0.0f);
        this.stands[2].teleport(location.clone().subtract(0.0, 0.55, 0.0));
        this.stands[3].teleport(location.clone().subtract(0.0, 1.3, 0.0));
        if (location2 != null) {
            this.stands[this.locked].setRotation(location2.getYaw() + 6.0f, 0.0f);
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            ArmorStand[] armorStandArray = this.stands;
            int n = this.stands.length;
            int n2 = 0;
            while (n2 < n) {
                ArmorStand armorStand = armorStandArray[n2];
                if (armorStand != null) {
                    armorStand.remove();
                }
                ++n2;
            }
            iterator.remove();
            return;
        }
        this.refreshReferences((Entity[])this.stands);
        if (this.entity.isDead()) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_EVOKER_PREPARE_ATTACK, SoundCategory.HOSTILE, 1.0f, 0.5f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.entity.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, this.entity.getLocation().add(0.0, 2.0, 0.0), 1000, 0.25, 0.25, 0.25, 20.0);
            this.clean();
            iterator.remove();
            return;
        }
        this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMITE_STEP, SoundCategory.HOSTILE, 0.8f, 0.5f);
        if (this.timer <= 0) {
            this.timer = 5;
            this.locked = -1;
        } else if (this.timer == 3) {
            this.locked = this.rand.nextInt(3);
        }
        --this.timer;
    }

    @Override
    public void clean() {
        ArmorStand[] armorStandArray = this.stands;
        int n = this.stands.length;
        int n2 = 0;
        while (n2 < n) {
            ArmorStand armorStand = armorStandArray[n2];
            if (armorStand != null) {
                armorStand.remove();
            }
            ++n2;
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void equipHands(ArmorStand armorStand, Material material, Material material2, Material material3) {
        this.lockStand(armorStand);
        armorStand.getEquipment().setHelmet(new ItemStack(material));
        armorStand.getEquipment().setItemInMainHand(new ItemStack(material2));
        armorStand.getEquipment().setItemInOffHand(new ItemStack(material3));
        armorStand.setRightArmPose(new EulerAngle(0.0, 0.3, 1.1));
        armorStand.setLeftArmPose(new EulerAngle(0.0, 0.5, -1.8));
    }

    private void lockStand(ArmorStand armorStand) {
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setGravity(false);
        armorStand.setArms(true);
        armorStand.setMarker(true);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
    }
}

