/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.endstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class VoidGuardian
extends CustomEntity {
    private boolean rage;
    private Random rand;
    private ItemStack[] armor = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), CustomHead.VOIDGUARD.getHead()};

    public VoidGuardian(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.VOIDGUARDIAN;
        this.rand = random;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
        this.changeColor(50, 50, 50, CustomHead.VOIDGUARD.getHead());
        mob.getEquipment().setItemInMainHand(ItemsHandler.voidsedge);
        mob.getEquipment().setItemInOffHand(ItemsHandler.voidshield);
        mob.setMetadata("dd-voidguardian", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        EntityEquipment entityEquipment = mob.getEquipment();
        entityEquipment.setHelmetDropChance(0.0f);
        entityEquipment.setChestplateDropChance(0.0f);
        entityEquipment.setLeggingsDropChance(0.0f);
        entityEquipment.setBootsDropChance(0.0f);
        entityEquipment.setItemInMainHandDropChance(0.0f);
        entityEquipment.setItemInOffHandDropChance(0.0f);
        mob.setCanPickupItems(false);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.voidGuard"));
        }
        mob.setSilent(true);
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        this.entity.getWorld().spawnParticle(Particle.DRAGON_BREATH, this.entity.getLocation().add(0.0, 0.5, 0.0), 3, 0.25, 0.5, 0.25, 0.015);
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.getWorld().spawnParticle(Particle.SOUL, this.entity.getLocation().add(0.0, 0.5, 0.0), 15, 0.3, 0.5, 0.3, 0.03);
            }
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_DROWNED_DEATH, SoundCategory.HOSTILE, 0.8f, 0.5f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.entity.getHealth() < this.entityType.getHealth() - 1.0) {
            this.entity.setHealth(Math.min(this.entity.getHealth() + 1.0, this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
            this.entity.getWorld().spawnParticle(Particle.COMPOSTER, this.entity.getLocation().add(0.0, 0.5, 0.0), 5, 0.3, 0.4, 0.3, 0.001);
        }
        if (!this.rage && this.entity.getHealth() <= this.entityType.getHealth() / 2.0) {
            this.changeColor(76, 48, 255, CustomHead.VOIDGUARDRAGE.getHead());
            this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.4);
            this.rage = true;
        } else if (this.rage && this.entity.getHealth() > this.entityType.getHealth() / 2.0) {
            this.changeColor(50, 50, 50, CustomHead.VOIDGUARD.getHead());
            this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
            this.rage = false;
            if (this.entity.getTarget() instanceof Player && !Utils.isPlayerImmune((Player)this.entity.getTarget())) {
                this.plugin.achievementsHandler.awardProgress(this.entity.getTarget().getUniqueId(), "master.series.void_master", 1, 2);
            }
        }
        if (this.rage) {
            this.entity.getWorld().spawnParticle(Particle.DAMAGE_INDICATOR, this.entity.getLocation().add(0.0, 0.5, 0.0), 10, 0.3, 0.3, 0.3, 0.25);
        }
        if (this.rand.nextInt(8) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_DROWNED_AMBIENT, SoundCategory.HOSTILE, 0.8f, 0.5f);
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void changeColor(int n, int n2, int n3, ItemStack itemStack) {
        int n4 = 0;
        while (n4 < 3) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.armor[n4].getItemMeta();
            leatherArmorMeta.setColor(Color.fromBGR((int)n, (int)n2, (int)n3));
            this.armor[n4].setItemMeta((ItemMeta)leatherArmorMeta);
            ++n4;
        }
        this.armor[3] = itemStack;
        this.entity.getEquipment().setArmorContents(this.armor);
    }
}

