/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.halloweenentities;

import deadlydisasters.Main;
import deadlydisasters.entities.AnimatedEntity;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.AnimationHandler;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Ghoul
extends AnimatedEntity {
    private Random rand;
    private UUID standUUID;
    public AnimationHandler grabAnimation;
    private AnimationHandler riseAnimation;
    private boolean walking;
    private Block ground;
    private Location toGround;
    private Location step;
    private int soundTick;

    public Ghoul(Zombie zombie, Block block, final Main main, boolean bl) {
        super((Mob)zombie, main);
        this.entityType = CustomEntityType.GHOUL;
        this.rand = main.random;
        this.species = this.entityType.species;
        this.ground = block;
        if (block == null) {
            this.walking = true;
        }
        this.entity.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.entity.setMetadata("dd-ghoul", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        this.entity.setMetadata("dd-halloweenmobs", (MetadataValue)main.fixedData);
        this.entity.setCanPickupItems(false);
        this.entity.setSilent(true);
        this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        this.entity.setHealth(this.entityType.getHealth());
        this.entity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
        this.entity.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        this.entity.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, -1, 0, true, false));
        if (main.mcVersion >= 1.16) {
            zombie.setAdult();
        } else {
            zombie.setBaby(false);
        }
        this.stand = (ArmorStand)this.entity.getWorld().spawnEntity(this.entity.getLocation().clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        this.stand = Utils.lockArmorStand(this.stand, false, true, true);
        this.stand.setBasePlate(false);
        ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), CustomHead.ROTTENZOMBIE.getHead()};
        int n = this.rand.nextInt(50) + 25;
        int n2 = 0;
        while (n2 < 3) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStackArray[n2].getItemMeta();
            leatherArmorMeta.setColor(Color.fromBGR((int)(n - 15), (int)n, (int)1));
            itemStackArray[n2].setItemMeta((ItemMeta)leatherArmorMeta);
            ++n2;
        }
        this.stand.getEquipment().setArmorContents(itemStackArray);
        this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.standUUID = this.stand.getUniqueId();
        if (this.entity.getCustomName() == null) {
            this.entity.setCustomName(Languages.getString("halloween.ghoul"));
        }
        this.step = this.entity.getLocation();
        this.walkAnimation = new AnimationHandler(true, true, true);
        this.walkAnimation.setContinueFrame(1);
        AnimationHandler.Animation[] animationArray = new AnimationHandler.Animation[5];
        AnimationHandler animationHandler = this.walkAnimation;
        animationHandler.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray = new AnimationHandler.AnimationCheckpoint[4];
        AnimationHandler animationHandler2 = this.walkAnimation;
        animationHandler2.getClass();
        animationCheckpointArray[0] = animationHandler2.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_LEG, 0.0, 0.0, 0.0, -30.0, 0.0, 10.0, 12, false, 0.5, 0.5);
        AnimationHandler animationHandler3 = this.walkAnimation;
        animationHandler3.getClass();
        animationCheckpointArray[1] = animationHandler3.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_LEG, 0.0, 0.0, 0.0, 30.0, 0.0, -10.0, 12, false, 0.5, 0.5);
        AnimationHandler animationHandler4 = this.walkAnimation;
        animationHandler4.getClass();
        animationCheckpointArray[2] = animationHandler4.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, 20.0, 0.0, 10.0, 12, false, 0.5, 0.5);
        AnimationHandler animationHandler5 = this.walkAnimation;
        animationHandler5.getClass();
        animationCheckpointArray[3] = animationHandler5.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, -20.0, 0.0, -10.0, 12, false, 0.5, 0.5);
        animationArray[0] = animationHandler.new AnimationHandler.Animation(animationCheckpointArray);
        AnimationHandler animationHandler6 = this.walkAnimation;
        animationHandler6.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray2 = new AnimationHandler.AnimationCheckpoint[4];
        AnimationHandler animationHandler7 = this.walkAnimation;
        animationHandler7.getClass();
        animationCheckpointArray2[0] = animationHandler7.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_LEG, -30.0, 0.0, 10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler8 = this.walkAnimation;
        animationHandler8.getClass();
        animationCheckpointArray2[1] = animationHandler8.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_LEG, 30.0, 0.0, -10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler9 = this.walkAnimation;
        animationHandler9.getClass();
        animationCheckpointArray2[2] = animationHandler9.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_ARM, 20.0, 0.0, 10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler10 = this.walkAnimation;
        animationHandler10.getClass();
        animationCheckpointArray2[3] = animationHandler10.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_ARM, -20.0, 0.0, -10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        animationArray[1] = animationHandler6.new AnimationHandler.Animation(animationCheckpointArray2);
        AnimationHandler animationHandler11 = this.walkAnimation;
        animationHandler11.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray3 = new AnimationHandler.AnimationCheckpoint[4];
        AnimationHandler animationHandler12 = this.walkAnimation;
        animationHandler12.getClass();
        animationCheckpointArray3[0] = animationHandler12.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_LEG, 0.0, 0.0, 0.0, 30.0, 0.0, 10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler13 = this.walkAnimation;
        animationHandler13.getClass();
        animationCheckpointArray3[1] = animationHandler13.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_LEG, 0.0, 0.0, 0.0, -30.0, 0.0, -10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler14 = this.walkAnimation;
        animationHandler14.getClass();
        animationCheckpointArray3[2] = animationHandler14.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, -20.0, 0.0, 10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler15 = this.walkAnimation;
        animationHandler15.getClass();
        animationCheckpointArray3[3] = animationHandler15.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, 20.0, 0.0, -10.0, 12, false, 0.0, 0.5);
        animationArray[2] = animationHandler11.new AnimationHandler.Animation(animationCheckpointArray3);
        AnimationHandler animationHandler16 = this.walkAnimation;
        animationHandler16.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray4 = new AnimationHandler.AnimationCheckpoint[4];
        AnimationHandler animationHandler17 = this.walkAnimation;
        animationHandler17.getClass();
        animationCheckpointArray4[0] = animationHandler17.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_LEG, 30.0, 0.0, 10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler18 = this.walkAnimation;
        animationHandler18.getClass();
        animationCheckpointArray4[1] = animationHandler18.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_LEG, -30.0, 0.0, -10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler19 = this.walkAnimation;
        animationHandler19.getClass();
        animationCheckpointArray4[2] = animationHandler19.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_ARM, -20.0, 0.0, 10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler20 = this.walkAnimation;
        animationHandler20.getClass();
        animationCheckpointArray4[3] = animationHandler20.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_ARM, 20.0, 0.0, -10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        animationArray[3] = animationHandler16.new AnimationHandler.Animation(animationCheckpointArray4);
        AnimationHandler animationHandler21 = this.walkAnimation;
        animationHandler21.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray5 = new AnimationHandler.AnimationCheckpoint[4];
        AnimationHandler animationHandler22 = this.walkAnimation;
        animationHandler22.getClass();
        animationCheckpointArray5[0] = animationHandler22.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_LEG, 0.0, 0.0, 0.0, -30.0, 0.0, 10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler23 = this.walkAnimation;
        animationHandler23.getClass();
        animationCheckpointArray5[1] = animationHandler23.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_LEG, 0.0, 0.0, 0.0, 30.0, 0.0, -10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler24 = this.walkAnimation;
        animationHandler24.getClass();
        animationCheckpointArray5[2] = animationHandler24.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, 20.0, 0.0, 10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler25 = this.walkAnimation;
        animationHandler25.getClass();
        animationCheckpointArray5[3] = animationHandler25.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, -20.0, 0.0, -10.0, 12, false, 0.0, 0.5);
        animationArray[4] = animationHandler21.new AnimationHandler.Animation(animationCheckpointArray5);
        this.walkAnimation.setAnimations(animationArray);
        this.grabAnimation = new AnimationHandler(true, false, true);
        AnimationHandler.Animation[] animationArray2 = new AnimationHandler.Animation[1];
        AnimationHandler animationHandler26 = this.grabAnimation;
        animationHandler26.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray6 = new AnimationHandler.AnimationCheckpoint[3];
        AnimationHandler animationHandler27 = this.grabAnimation;
        animationHandler27.getClass();
        animationCheckpointArray6[0] = animationHandler27.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_ARM, 260.0, 36.0, 0.0, 245.0, -20.0, 15.0, 14, true, 0.5, 0.5);
        AnimationHandler animationHandler28 = this.grabAnimation;
        animationHandler28.getClass();
        animationCheckpointArray6[1] = animationHandler28.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_ARM, 260.0, 325.0, 0.0, 245.0, 380.0, -5.0, 14, true, 1.0, 0.5);
        AnimationHandler animationHandler29 = this.grabAnimation;
        animationHandler29.getClass();
        animationCheckpointArray6[2] = animationHandler29.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.HEAD, 0.0, 0.0, -20.0, 0.0, 0.0, 20.0, 14, true, 0.5, 0.5);
        animationArray2[0] = animationHandler26.new AnimationHandler.Animation(animationCheckpointArray6);
        this.grabAnimation.setAnimations(animationArray2);
        this.grabAnimation.go();
        this.riseAnimation = new AnimationHandler(true, true, false);
        AnimationHandler.Animation[] animationArray3 = new AnimationHandler.Animation[1];
        AnimationHandler animationHandler30 = this.riseAnimation;
        animationHandler30.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray7 = new AnimationHandler.AnimationCheckpoint[3];
        AnimationHandler animationHandler31 = this.riseAnimation;
        animationHandler31.getClass();
        animationCheckpointArray7[0] = animationHandler31.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.RIGHT_ARM, 187.0, 44.0, 0.0, 260.0, 36.0, 0.0, 40, false, 0.5, 0.5);
        AnimationHandler animationHandler32 = this.riseAnimation;
        animationHandler32.getClass();
        animationCheckpointArray7[1] = animationHandler32.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.LEFT_ARM, 199.0, 316.0, 0.0, 260.0, 325.0, 0.0, 40, false, 0.5, 0.5);
        AnimationHandler animationHandler33 = this.riseAnimation;
        animationHandler33.getClass();
        animationCheckpointArray7[2] = animationHandler33.new AnimationHandler.AnimationCheckpoint(AnimationHandler.BodyPart.HEAD, 319.0, 0.0, 20.0, 0.0, 0.0, -20.0, 40, false, 0.5, 0.5);
        animationArray3[0] = animationHandler30.new AnimationHandler.Animation(animationCheckpointArray7);
        this.riseAnimation.setAnimations(animationArray3);
        if (bl) {
            this.riseAnimation.startAnimation(this.stand);
            this.riseAnimation.tick(this.stand);
            final int[] nArray = new int[]{40};
            this.toGround = block.getRelative(BlockFace.DOWN).getLocation().add(0.5, 0.1, 0.5);
            final double d = 0.02;
            new RepeatingTask(main, 0, 1){

                @Override
                public void run() {
                    if (Ghoul.this.entity == null) {
                        this.cancel();
                        return;
                    }
                    Ghoul.this.entity.teleport(Ghoul.this.toGround);
                    Ghoul.this.toGround.add(0.0, d, 0.0);
                    if (nArray[0] % 5 == 0 && main.mcVersion >= 1.2) {
                        Ghoul.this.entity.getWorld().playSound(Ghoul.this.entity.getLocation(), Sound.BLOCK_SCULK_BREAK, SoundCategory.HOSTILE, 2.0f, 0.5f);
                    }
                    if ((nArray[0] = nArray[0] - 1) <= 0) {
                        this.cancel();
                    }
                }
            };
        }
    }

    @Override
    public void tick() {
        if (this.entity == null || this.stand == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_VILLAGER_HURT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        if (this.step.distanceSquared(this.entity.getLocation()) > 3.0 && this.entity.isOnGround()) {
            this.step = this.entity.getLocation();
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_VILLAGER_STEP, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
        super.tick();
        if (this.walking) {
            this.entity.getWorld().spawnParticle(Particle.BLOCK_DUST, this.entity.getLocation().clone().add(0.0, 1.1, 0.0), 1, 0.2, 0.4, 0.2, 1.0, (Object)Material.PODZOL.createBlockData());
            return;
        }
        this.entity.teleport(this.toGround.setDirection(this.entity.getEyeLocation().getDirection()));
        this.stand.teleport(this.entity.getLocation().subtract(0.0, 0.1, 0.0));
        if (!this.riseAnimation.isFinished()) {
            this.riseAnimation.tick(this.stand);
            this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.ground.getLocation().add(0.5, 1.1, 0.5), 5, 0.4, 0.1, 0.4, 1.0, (Object)this.ground.getBlockData());
            return;
        }
        if (this.soundTick++ == 10) {
            this.soundTick = 0;
            if (this.plugin.mcVersion >= 1.2) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_SCULK_BREAK, SoundCategory.HOSTILE, 0.1f, 0.5f);
            }
        }
        this.grabAnimation.tick(this.stand);
        if (Utils.isTargetInRange(this.entity, 0.0, 4.0, true)) {
            this.entity.getTarget().setVelocity(this.entity.getTarget().getVelocity().multiply(0.25).add(Utils.getVectorTowards(this.entity.getTarget().getLocation(), this.entity.getEyeLocation().subtract(0.0, 0.3, 0.0)).multiply(0.05 * this.entity.getTarget().getLocation().distanceSquared(this.entity.getEyeLocation()))));
        }
        this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.ground.getLocation().add(0.5, 1.1, 0.5), 2, 0.4, 0.1, 0.4, 1.0, (Object)this.ground.getBlockData());
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.stand == null) {
            this.clean();
            iterator.remove();
            return;
        }
        this.stand = (ArmorStand)this.plugin.getServer().getEntity(this.standUUID);
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.getWorld().spawnParticle(Particle.SOUL, this.entity.getLocation().add(0.0, 0.5, 0.0), 15, 0.3, 0.5, 0.3, 0.03);
            }
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_VILLAGER_DEATH, SoundCategory.HOSTILE, 2.0f, 0.5f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        if (this.rand.nextInt(6) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_VILLAGER_AMBIENT, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
        if (!this.walking && (this.ground.isPassable() || this.entity.getHealth() < this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 100.0 * 70.0 && !Utils.isTargetInRange(this.entity, 0.0, 2.25, false))) {
            this.walking = true;
            this.entity.setVelocity(new Vector(0.0, 0.4, 0.0));
            this.stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
            this.stand.setLeftArmPose(new EulerAngle(0.0, 0.0, 0.0));
        }
    }

    public boolean isWalking() {
        return this.walking;
    }

    public void setWalking(boolean bl) {
        this.walking = bl;
    }

    @Override
    public void clean() {
        super.clean();
    }

    public void dig() {
        final int[] nArray = new int[1];
        final Location[] locationArray = new Location[1];
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                if (Ghoul.this.entity == null || Ghoul.this.entity.isDead()) {
                    this.cancel();
                    return;
                }
                if (nArray[0] > 0) {
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    if (n == 60) {
                        Ghoul.this.clean();
                        this.cancel();
                        Ghoul.this.entity.remove();
                        return;
                    }
                    Ghoul.this.entity.teleport(Ghoul.this.entity.getLocation().subtract(0.0, 0.05, 0.0));
                    Ghoul.this.stand.setHeadPose(new EulerAngle(Math.toRadians(nArray[0]), 0.0, 0.0));
                    locationArray[0].getWorld().spawnParticle(Particle.BLOCK_CRACK, locationArray[0], 5, 0.5, 0.1, 0.5, 0.1, (Object)(locationArray[0].getBlock().getType() == Material.AIR ? Material.DIRT.createBlockData() : locationArray[0].getBlock().getBlockData()));
                    return;
                }
                Ghoul.this.entity.setTarget(null);
                if (Ghoul.this.entity.isOnGround()) {
                    Ghoul.this.entity.setAI(false);
                    Ghoul.this.entity.setGravity(false);
                    locationArray[0] = Ghoul.this.entity.getLocation().getBlock().getLocation().add(0.5, 0.0, 0.5);
                    nArray[0] = nArray[0] + 1;
                }
            }
        };
    }
}

