/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.halloweenentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Psyco
extends CustomEntity {
    private Random rand;
    private int cooldown;

    public Psyco(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.PSYCO;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.rand = random;
        mob.setMetadata("dd-psyco", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.setMetadata("dd-halloweenmobs", (MetadataValue)main.fixedData);
        mob.setCanPickupItems(false);
        mob.setSilent(true);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        mob.getEquipment().setHelmetDropChance(0.0f);
        ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), CustomHead.STALKER.getHead()};
        int n = 0;
        while (n < 3) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStackArray[n].getItemMeta();
            leatherArmorMeta.setColor(Color.fromRGB((int)105, (int)68, (int)31));
            itemStackArray[n].setItemMeta((ItemMeta)leatherArmorMeta);
            ++n;
        }
        mob.getEquipment().setArmorContents(itemStackArray);
        mob.getEquipment().setItemInMainHand(new ItemStack(Material.IRON_SWORD));
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("halloween.psyco"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_HUSK_HURT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        Vector vector;
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.getWorld().spawnParticle(Particle.SOUL, this.entity.getLocation().add(0.0, 1.5, 0.0), 5, 0.3, 0.3, 0.3, 1.0E-4);
            }
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_HUSK_DEATH, SoundCategory.HOSTILE, 1.0f, 0.6f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.rand.nextInt(4) == 0 && Tag.WOODEN_DOORS.getValues().contains(this.entity.getLocation().add(this.entity.getLocation().getDirection()).getBlock().getType()) && !Utils.isZoneProtected(this.entity.getLocation().add(this.entity.getLocation().getDirection()))) {
            this.entity.getLocation().add(this.entity.getLocation().getDirection()).getBlock().breakNaturally();
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        if (this.entity.getTarget() == null && (vector = this.entity.getNearbyEntities(30.0, 30.0, 30.0).stream().filter(entity -> entity instanceof Player).sorted((entity, entity2) -> (int)entity.getLocation().distanceSquared(entity2.getLocation())).collect(Collectors.toList()).iterator()).hasNext()) {
            Entity entity3 = (Entity)vector.next();
            this.entity.setTarget((LivingEntity)entity3);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (Utils.isTargetInRange(this.entity, 25.0, 1600.0, false)) {
            float f = this.entity.getTarget().getLocation().getYaw() + 180.0f;
            vector = Utils.getVectorTowards(this.entity.getTarget().getLocation(), this.entity.getLocation());
            Location location = this.entity.getTarget().getLocation().setDirection(vector);
            if (f > location.getYaw() - 45.0f && f < location.getYaw() + 45.0f) {
                Location location2 = this.entity.getTarget().getLocation();
                int n = 0;
                while (n < 5) {
                    location.add(vector);
                    Location location3 = Utils.findSmartYSpawn(location2, location, 2, 5);
                    if (location3 != null) {
                        this.cooldown = 4;
                        LivingEntity livingEntity = this.entity.getTarget();
                        this.entity.setTarget(null);
                        this.entity.teleport(location3);
                        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.entity.setTarget(livingEntity), 1L);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

