/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.halloweenentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.entities.halloweenentities.Ghoul;
import deadlydisasters.events.disasters.DeathParade;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.AsyncRepeatingTask;
import deadlydisasters.utils.NBSongs;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.SongPlayer;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class PumpkinKing
extends CustomEntity {
    private Random rand;
    private BossBar bar;
    private int cooldown = 3;
    private int noTargetTicks;
    private Location lastTargetLoc;
    private Entity lastTarget;
    private int targetHoldTicks;
    private LivingEntity basketTarget;
    private Location step;
    public SongPlayer songPlayer;
    public int damageTicks;
    private Slime projectile;
    private ArmorStand pumpkin;
    public DeathParade parade;
    private Set<Entity> toRemove = new HashSet<Entity>();
    private Set<UUID> ghouls = new HashSet<UUID>();
    public static Set<Block> pumpkinBasketBlocks = new HashSet<Block>();

    public PumpkinKing(Mob mob, Main main, Random random) {
        super(mob, main);
        this.rand = random;
        this.entityType = CustomEntityType.PUMPKINKING;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        mob.setSilent(true);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.2);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(60.0);
        mob.getEquipment().setHelmetDropChance(0.0f);
        mob.getEquipment().setHelmet(new ItemStack(Material.JACK_O_LANTERN));
        mob.getEquipment().setItemInOffHandDropChance(0.0f);
        mob.getEquipment().setItemInOffHand(ItemsHandler.etherealLanternBoss);
        mob.setMetadata("dd-pumpkinking", (MetadataValue)main.fixedData);
        mob.setMetadata("dd-halloweenmobs", (MetadataValue)main.fixedData);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("halloween.pumpkinKing"));
        }
        this.step = mob.getLocation();
        this.bar = Bukkit.createBossBar((String)Utils.chat("&c" + Languages.getString("halloween.pumpkinKing")), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[]{BarFlag.DARKEN_SKY, BarFlag.CREATE_FOG});
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOGLIN_HURT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        this.bar.setProgress(Utils.clamp(1.0 / this.entityType.getHealth() * this.entity.getHealth(), 0.0, 1.0));
        if (this.damageTicks >= 12) {
            this.damageTicks = 0;
            for (Entity entity2 : this.entity.getWorld().getNearbyEntities(this.entity.getLocation(), 8.0, 8.0, 8.0, entity -> entity instanceof Player && !entity.isDead() && !Utils.isEntityImmunePlayer(entity))) {
                this.spawnSoulBomb(this.entity.getLocation().add(0.0, 1.4, 0.0), (LivingEntity)entity2, new Vector(0, 0, 0), true);
            }
        }
        int n = 0;
        while (n < 8) {
            Particle.DustTransition dustTransition = new Particle.DustTransition(Color.BLACK, Color.fromRGB((int)255, (int)(this.rand.nextInt(40) + 80), (int)0), this.rand.nextFloat());
            this.entity.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, this.entity.getLocation().add(this.rand.nextDouble() - 0.5, 1.4 + (this.rand.nextDouble() - 0.5), this.rand.nextDouble() - 0.5), 1, 0.0, 0.0, 0.0, 0.001, (Object)dustTransition);
            ++n;
        }
        if (this.step.distanceSquared(this.entity.getLocation()) > 3.0 && this.entity.isOnGround()) {
            this.step = this.entity.getLocation();
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOGLIN_STEP, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void function(Iterator<CustomEntity> iterator) {
        Object object2;
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            this.clean();
            return;
        }
        if (this.entity.isDead()) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_VILLAGER_CURE, SoundCategory.HOSTILE, 1.0f, 0.5f);
            CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType, true);
            this.bar.removeAll();
            iterator.remove();
            this.clean();
            return;
        }
        this.bar.removeAll();
        if (this.songPlayer != null) {
            this.songPlayer.clearPlayers();
        }
        for (Object object2 : this.entity.getNearbyEntities(40.0, 40.0, 40.0).stream().filter(entity -> entity instanceof Player).sorted((entity, entity2) -> (int)entity.getLocation().distanceSquared(entity2.getLocation())).collect(Collectors.toList())) {
            this.bar.addPlayer((Player)object2);
            if (this.songPlayer != null) {
                this.songPlayer.addPlayer((Player)object2);
            }
            if (this.entity.getTarget() != null || Utils.isEntityImmunePlayer((Entity)object2)) continue;
            this.entity.setTarget((LivingEntity)object2);
        }
        if (this.entity.getTarget() == null) {
            if (this.basketTarget != null && !this.basketTarget.isDead()) {
                this.entity.setTarget(this.basketTarget);
            }
            if (this.noTargetTicks < 2 && this.noTargetTicks++ == 2) {
                this.entity.getEquipment().setItemInOffHand(ItemsHandler.etherealLanternBoss);
            }
        } else {
            if (this.entity.getEquipment().getItemInOffHand().getType() != Material.AIR && this.entity.getEquipment().getItemInOffHand().getItemMeta().getPersistentDataContainer().has(ItemsHandler.etherealLanternBossKey, PersistentDataType.BYTE)) {
                this.noTargetTicks = 0;
                this.entity.getEquipment().setItemInOffHand(ItemsHandler.etherealLanternBoss2);
            }
            if (this.lastTarget == null || !this.entity.getTarget().equals(this.lastTarget)) {
                this.lastTarget = this.entity.getTarget();
                this.targetHoldTicks = 0;
            } else if (this.targetHoldTicks++ == 7) {
                this.targetHoldTicks = 0;
                this.throwPumpkin(this.entity.getTarget(), true);
                this.cooldown = 9;
            } else if (this.lastTargetLoc == null || this.lastTargetLoc.getWorld() != this.lastTarget.getWorld() || this.lastTargetLoc.distanceSquared(this.lastTarget.getLocation()) > 16.0) {
                this.targetHoldTicks = 0;
                this.lastTargetLoc = this.lastTarget.getLocation();
            }
        }
        if (this.rand.nextInt(4) == 0) {
            switch (this.rand.nextInt(3)) {
                case 0: {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOGLIN_AMBIENT, SoundCategory.HOSTILE, 2.0f, 0.5f);
                    break;
                }
                case 1: {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOGLIN_ANGRY, SoundCategory.HOSTILE, 2.0f, 0.5f);
                    break;
                }
                case 2: {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOGLIN_DEATH, SoundCategory.HOSTILE, 1.5f, 0.5f);
                    break;
                }
            }
        }
        if (this.damageTicks != 0) {
            --this.damageTicks;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.entity.getTarget() instanceof ArmorStand) {
            return;
        }
        object2 = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4));
        Collections.shuffle(object2);
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Integer n = (Integer)iterator2.next();
            block5 : switch (n) {
                case 0: {
                    Object object3;
                    if (!Utils.isTargetInRange(this.entity, 0.0, 100.0, true)) break;
                    Entity entity3 = this.ghouls.iterator();
                    while (true) {
                        if (!entity3.hasNext()) {
                            if (this.ghouls.size() <= 5) break;
                            break block5;
                        }
                        object3 = Bukkit.getEntity((UUID)entity3.next());
                        if (object3 != null && !object3.isDead()) continue;
                        entity3.remove();
                    }
                    int n2 = 0;
                    HashSet<Block> hashSet = new HashSet<Block>();
                    int n3 = 0;
                    while (n3 < 20) {
                        Location location = Utils.findSmartYSpawn(this.entity.getLocation(), Utils.getSpotInSquareRadius(this.entity.getLocation(), this.rand.nextInt(6) + 3), 2, 5);
                        if (location != null && !hashSet.contains(location.getBlock())) {
                            location.subtract(0.0, 1.0, 0.0);
                            hashSet.add(location.getBlock());
                            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                                Zombie zombie2 = (Zombie)location.getWorld().spawn(location, Zombie.class, false, zombie -> zombie.setRotation(this.plugin.random.nextFloat() * 360.0f, 0.0f));
                                Ghoul ghoul = this.plugin.handler.addEntity(new Ghoul(zombie2, location.getBlock(), this.plugin, true));
                                this.ghouls.add(zombie2.getUniqueId());
                                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                                    ghoul.setWalking(true);
                                    ghoul.getEntity().setVelocity(new Vector(0.0, 0.4, 0.0));
                                    ((Mob)ghoul.getEntity()).setTarget(this.entity.getTarget());
                                    ghoul.grabAnimation.stop();
                                }, 60L);
                            }, (long)this.rand.nextInt(80));
                            if (++n2 == 5) break;
                        }
                        ++n3;
                    }
                    this.cooldown = n2 * 2;
                    this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, n2 * 20, 5, true, false, false));
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOGLIN_DEATH, SoundCategory.HOSTILE, 2.0f, 0.5f);
                    return;
                }
                case 1: {
                    if (!Utils.isTargetInRange(this.entity, 49.0, 1600.0, false)) break;
                    this.throwPumpkin(this.entity.getTarget(), false);
                    this.cooldown = 6;
                    return;
                }
                case 2: {
                    if (!Utils.isTargetInRange(this.entity, 36.0, 256.0, false)) break;
                    int n4 = 0;
                    Object object3 = new HashSet();
                    int n5 = 0;
                    while (n5 < 20) {
                        Block block;
                        Location location = Utils.findSmartYSpawn(this.entity.getTarget().getLocation(), Utils.getSpotInSquareRadius(this.entity.getTarget().getLocation(), this.rand.nextInt(20) + 1), 2, 8);
                        if (location != null && !object3.contains(block = location.getBlock().getRelative(BlockFace.DOWN)) && !object3.stream().anyMatch(block2 -> block2.getLocation().distanceSquared(block.getLocation()) < 16.0)) {
                            object3.add(block);
                            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.createBloodCircle(block, 80, 40), (long)(n4 * 10));
                            if (++n4 == 5) break;
                        }
                        ++n5;
                    }
                    this.cooldown = n4;
                    this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, n4 * 5, 5, true, false, false));
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOGLIN_ANGRY, SoundCategory.HOSTILE, 2.0f, 0.5f);
                    return;
                }
                case 3: {
                    Entity entity3;
                    if (!Utils.isTargetInRange(this.entity, 64.0, 1600.0, true)) break;
                    Object object3 = this.entity.getWorld().getNearbyEntities(this.entity.getLocation(), 15.0, 15.0, 15.0, entity -> entity instanceof Player && !entity.isDead() && !Utils.isEntityImmunePlayer(entity)).iterator();
                    while (true) {
                        if (!object3.hasNext()) {
                            this.cooldown = 7;
                            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOGLIN_ANGRY, SoundCategory.HOSTILE, 2.0f, 0.5f);
                            return;
                        }
                        entity3 = (Entity)object3.next();
                        this.spawnSoulBomb(this.entity.getLocation().add(0.0, 1.4, 0.0), (LivingEntity)entity3, new Vector(0, 2, 0), false);
                    }
                }
                case 4: {
                    this.cooldown = 6;
                    return;
                }
            }
        }
    }

    @Override
    public void clean() {
        this.bar.removeAll();
        if (this.songPlayer != null) {
            this.songPlayer.setPlaying(false);
        }
        if (this.pumpkin != null) {
            this.pumpkin.remove();
        }
        if (this.projectile != null) {
            this.projectile.remove();
        }
        for (Entity entity : this.toRemove) {
            if (entity == null) continue;
            entity.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void spawnSoulBomb(final Location location, final LivingEntity livingEntity, final Vector vector, final boolean bl) {
        final double[] dArray = new double[]{6.0};
        final int[] nArray = new int[]{80};
        final ArmorStand armorStand = Utils.lockArmorStand((ArmorStand)location.getWorld().spawnEntity(location.clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND), true, false, true);
        armorStand.getEquipment().setHelmet(CustomHead.SOULPARTICLE.getHead());
        armorStand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.toRemove.add((Entity)armorStand);
        armorStand.teleport(this.entity.getLocation());
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                nArray[0] = nArray[0] - 1;
                if (nArray[0] == 0 || armorStand == null || armorStand.isDead() || livingEntity == null || livingEntity.isDead() || !livingEntity.getWorld().equals(armorStand.getWorld())) {
                    this.cancel();
                    if (armorStand != null) {
                        armorStand.remove();
                    }
                    return;
                }
                dArray[0] = dArray[0] - 0.05;
                Vector vector2 = Utils.getVectorTowards(armorStand.getLocation(), livingEntity.getLocation()).multiply(0.2);
                vector.add(vector2).normalize().multiply(0.8);
                armorStand.teleport(armorStand.getLocation().add(vector).setDirection(vector2));
                armorStand.setHeadPose(new EulerAngle(Math.toRadians(armorStand.getLocation().getPitch()), 0.0, 0.0));
                Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)PumpkinKing.this.rand.nextInt(180), (int)217, (int)202), Color.BLACK, PumpkinKing.this.rand.nextFloat());
                int n = 0;
                while (n < 3) {
                    armorStand.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, armorStand.getEyeLocation().add(PumpkinKing.this.rand.nextDouble() / 2.0 - 0.25, 2.2 + (PumpkinKing.this.rand.nextDouble() / 2.0 - 0.25), PumpkinKing.this.rand.nextDouble() / 2.0 - 0.25), 1, 0.0, 0.0, 0.0, 0.001, (Object)dustTransition);
                    ++n;
                }
                if (nArray[0] % 5 == 0) {
                    armorStand.getWorld().playSound(armorStand.getLocation(), Sound.ENTITY_GHAST_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.5f);
                }
                if (armorStand.getLocation().distanceSquared(livingEntity.getLocation()) < 1.0) {
                    PumpkinKing.this.createSoulBombExplosion(armorStand.getLocation().add(0.0, 1.0, 0.0), dArray[0]);
                    if (!Utils.isEntityImmunePlayer((Entity)livingEntity)) {
                        Utils.pureDamageEntity(livingEntity, 4.0, "dd-soulbombdeath", false, (Entity)PumpkinKing.this.entity);
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0, true, false, false));
                        if (bl) {
                            livingEntity.setVelocity(Utils.getVectorTowards(location, livingEntity.getLocation()).setY(0.6));
                        }
                    }
                    armorStand.getWorld().playSound(armorStand.getLocation(), Sound.ENTITY_GHAST_HURT, SoundCategory.HOSTILE, 2.0f, 0.5f);
                    armorStand.remove();
                    this.cancel();
                    return;
                }
            }
        };
    }

    private void createSoulBombExplosion(final Location location, final double d) {
        Vector vector = new Vector(1, 0, 0);
        final World world = location.getWorld();
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            int n = 0;
            while (n < 18) {
                Vector vector2 = vector.clone();
                int n2 = 0;
                while (n2 < 18) {
                    Location location2 = location.clone().add(vector2);
                    Vector vector3 = Utils.getVectorTowards(location, location2).multiply(d / 30.0);
                    world.spawnParticle(Particle.CLOUD, location2, 0, vector3.getX(), vector3.getY(), vector3.getZ());
                    vector2.rotateAroundZ(Math.toRadians(20.0));
                    ++n2;
                }
                vector.rotateAroundY(Math.toRadians(20.0));
                ++n;
            }
        });
        final double[] dArray = new double[]{0.0};
        new RepeatingTask(this.plugin, 5, 1){

            @Override
            public void run() {
                dArray[0] = dArray[0] + d / 20.0;
                for (Entity entity2 : world.getNearbyEntities(location, dArray[0], dArray[0], dArray[0], entity -> !entity.isDead() && !entity.hasMetadata("dd-halloweenmobs"))) {
                    double d2 = entity2.getLocation().distance(location);
                    if (d2 > dArray[0]) continue;
                    if (entity2 instanceof LivingEntity && !Utils.isEntityImmunePlayer(entity2)) {
                        if (!Utils.rayTraceEntityConeForSolid(entity2, location)) continue;
                        entity2.setVelocity(Utils.getVectorTowards(location, entity2.getLocation().add(0.0, entity2.getHeight() / 2.0, 0.0)).multiply(0.05 * d * (1.0 - d2 / d)));
                        if (((LivingEntity)entity2).getNoDamageTicks() == 0) {
                            Utils.pureDamageEntity((LivingEntity)entity2, 2.0, "dd-soulbombdeath", false, (Entity)PumpkinKing.this.entity);
                        }
                        ((LivingEntity)entity2).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0, true, false, false));
                        continue;
                    }
                    if (!Utils.rayTraceForSolid(location, entity2.getLocation())) continue;
                    entity2.setVelocity(Utils.getVectorTowards(location, entity2.getLocation().add(0.0, entity2.getHeight() / 2.0, 0.0)).multiply(0.05 * d * (1.0 - d2 / d)));
                }
                if (dArray[0] >= d) {
                    this.cancel();
                }
            }
        };
    }

    private void throwPumpkin(LivingEntity livingEntity, final boolean bl) {
        this.pumpkin = Utils.lockArmorStand((ArmorStand)this.entity.getWorld().spawnEntity(this.entity.getLocation().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND), true, false, true);
        this.pumpkin.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.projectile = (Slime)this.entity.getWorld().spawn(this.entity.getLocation().add(0.0, 100.0, 0.0), Slime.class, slime -> {
            slime.setSize(0);
            slime.setSilent(true);
            slime.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(100.0);
            slime.setHealth(100.0);
            slime.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(0.0);
            slime.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
            slime.teleport((Entity)this.entity);
            slime.teleport(slime.getLocation().add(0.0, 1.0, 0.0));
            slime.setGravity(false);
        });
        Location location = livingEntity.getLocation().add(0.0, livingEntity.getHeight() / 2.0, 0.0);
        final Vector vector = Utils.getVectorTowards(this.projectile.getLocation(), location);
        vector.setX(vector.getX() / 3.0);
        vector.setZ(vector.getZ() / 3.0);
        vector.setY(location.distance(this.entity.getLocation()) / 13.0 + (location.getY() - this.entity.getLocation().getY()) / 30.0);
        this.entity.getEquipment().setItemInOffHand(new ItemStack(Material.AIR));
        this.entity.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        if (this.plugin.mcVersion >= 1.16) {
            this.entity.setInvisible(true);
        }
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                if (PumpkinKing.this.pumpkin == null || PumpkinKing.this.pumpkin.isDead() || PumpkinKing.this.projectile == null || PumpkinKing.this.projectile.isDead() || PumpkinKing.this.entity == null) {
                    if (PumpkinKing.this.pumpkin != null) {
                        PumpkinKing.this.pumpkin.remove();
                    }
                    PumpkinKing.this.pumpkin = null;
                    if (PumpkinKing.this.projectile != null) {
                        PumpkinKing.this.projectile.remove();
                    }
                    if (PumpkinKing.this.entity != null && !PumpkinKing.this.entity.isDead()) {
                        PumpkinKing.this.entity.getEquipment().setItemInOffHand(ItemsHandler.etherealLanternBoss);
                        PumpkinKing.this.entity.removePotionEffect(PotionEffectType.INVISIBILITY);
                        PumpkinKing.this.entity.getWorld().playSound(PumpkinKing.this.entity.getLocation(), Sound.ENTITY_ZOGLIN_ANGRY, SoundCategory.HOSTILE, 2.0f, 0.5f);
                        if (((PumpkinKing)PumpkinKing.this).plugin.mcVersion >= 1.16) {
                            PumpkinKing.this.entity.setInvisible(false);
                        }
                    }
                    this.cancel();
                    return;
                }
                PumpkinKing.this.projectile.teleport(PumpkinKing.this.projectile.getLocation().add(vector));
                PumpkinKing.this.pumpkin.teleport(PumpkinKing.this.projectile.getLocation().add(0.0, -2.0, 0.0).setDirection(vector));
                PumpkinKing.this.entity.teleport(PumpkinKing.this.pumpkin.getLocation().add(0.0, 3.0, 0.0));
                PumpkinKing.this.entity.setFallDistance(0.0f);
                double d = Math.abs(vector.getX());
                if (Math.abs(vector.getZ()) > d) {
                    d = Math.abs(vector.getZ());
                }
                double d2 = Math.toDegrees(Math.atan2(Math.abs(vector.getY()), d));
                if (vector.getY() >= 0.0) {
                    PumpkinKing.this.pumpkin.setHeadPose(new EulerAngle(Math.toRadians(360.0 - d2), 0.0, 0.0));
                } else {
                    PumpkinKing.this.pumpkin.setHeadPose(new EulerAngle(Math.toRadians(360.0 + d2), 0.0, 0.0));
                }
                PumpkinKing.this.pumpkin.getWorld().spawnParticle(Particle.BLOCK_CRACK, PumpkinKing.this.pumpkin.getLocation().add(0.0, 2.0, 0.0), 2, 0.1, 0.1, 0.1, 1.0, (Object)Material.JACK_O_LANTERN.createBlockData());
                if (!PumpkinKing.this.projectile.getLocation().getBlock().isPassable()) {
                    PumpkinKing.this.pumpkin.remove();
                    PumpkinKing.this.projectile.remove();
                    if (PumpkinKing.this.entity != null && !PumpkinKing.this.entity.isDead()) {
                        PumpkinKing.this.entity.getEquipment().setItemInOffHand(ItemsHandler.etherealLanternBoss);
                        PumpkinKing.this.entity.removePotionEffect(PotionEffectType.INVISIBILITY);
                        PumpkinKing.this.entity.getWorld().playSound(PumpkinKing.this.entity.getLocation(), Sound.ENTITY_ZOGLIN_ANGRY, SoundCategory.HOSTILE, 2.0f, 0.5f);
                        if (((PumpkinKing)PumpkinKing.this).plugin.mcVersion >= 1.16) {
                            PumpkinKing.this.entity.setInvisible(false);
                        }
                    }
                    PumpkinKing.this.pumpkin = null;
                    PumpkinKing.this.projectile.getWorld().createExplosion(PumpkinKing.this.projectile.getLocation(), 6.0f, true, bl, (Entity)PumpkinKing.this.entity);
                    this.cancel();
                    final int[] nArray = new int[]{20};
                    final Location location = PumpkinKing.this.projectile.getLocation();
                    new RepeatingTask(PumpkinKing.this.plugin, 0, 2){

                        @Override
                        public void run() {
                            location.getWorld().spawnParticle(Particle.REDSTONE, location, 30, 4.0, 2.0, 4.0, 0.001, (Object)new Particle.DustOptions(Color.ORANGE, 1.0f));
                            location.getWorld().spawnParticle(Particle.REDSTONE, location, 30, 4.0, 2.0, 4.0, 0.001, (Object)new Particle.DustOptions(Color.BLACK, 1.0f));
                            nArray[0] = nArray[0] - 1;
                            if (nArray[0] <= 0) {
                                this.cancel();
                            }
                        }
                    };
                    return;
                }
                vector.multiply(0.99);
                vector.setY(vector.getY() - (double)0.05f);
                for (Entity entity : PumpkinKing.this.projectile.getNearbyEntities(0.5, 0.5, 0.5)) {
                    if (!(entity instanceof LivingEntity) || entity instanceof ArmorStand || entity.equals(PumpkinKing.this.entity) || entity instanceof Player && Utils.isPlayerImmune((Player)entity)) continue;
                    PumpkinKing.this.pumpkin.remove();
                    PumpkinKing.this.projectile.remove();
                    if (PumpkinKing.this.entity != null && !PumpkinKing.this.entity.isDead()) {
                        PumpkinKing.this.entity.getEquipment().setItemInOffHand(ItemsHandler.etherealLanternBoss);
                        PumpkinKing.this.entity.removePotionEffect(PotionEffectType.INVISIBILITY);
                        PumpkinKing.this.entity.getWorld().playSound(PumpkinKing.this.entity.getLocation(), Sound.ENTITY_ZOGLIN_ANGRY, SoundCategory.HOSTILE, 2.0f, 0.5f);
                        if (((PumpkinKing)PumpkinKing.this).plugin.mcVersion >= 1.16) {
                            PumpkinKing.this.entity.setInvisible(false);
                        }
                    }
                    PumpkinKing.this.pumpkin = null;
                    PumpkinKing.this.projectile.getWorld().createExplosion(PumpkinKing.this.projectile.getLocation(), 4.0f, true, bl, (Entity)PumpkinKing.this.entity);
                    this.cancel();
                    final int[] nArray = new int[]{20};
                    final Location location = PumpkinKing.this.projectile.getLocation();
                    new RepeatingTask(PumpkinKing.this.plugin, 0, 2){

                        @Override
                        public void run() {
                            location.getWorld().spawnParticle(Particle.REDSTONE, location, 30, 4.0, 2.0, 4.0, 0.001, (Object)new Particle.DustOptions(Color.ORANGE, 1.0f));
                            location.getWorld().spawnParticle(Particle.REDSTONE, location, 30, 4.0, 2.0, 4.0, 0.001, (Object)new Particle.DustOptions(Color.BLACK, 1.0f));
                            nArray[0] = nArray[0] - 1;
                            if (nArray[0] <= 0) {
                                this.cancel();
                            }
                        }
                    };
                    return;
                }
            }
        };
    }

    private void createBloodCircle(Block block, int n, int n2) {
        final Location location = block.getLocation().add(0.5, 1.0, 0.5);
        final World world = location.getWorld();
        world.playSound(location, Sound.ITEM_FIRECHARGE_USE, SoundCategory.HOSTILE, 1.0f, 0.5f);
        final int[] nArray = new int[]{n, n2};
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                double d;
                int n = 0;
                while (n < 50) {
                    d = Math.toRadians(7.2 * (double)n);
                    world.spawnParticle(Particle.FLAME, location.clone().add(Math.cos(d) * 2.0, 0.0, Math.sin(d) * 2.0), 1, 0.0, 0.0, 0.0, 1.0E-4);
                    ++n;
                }
                world.spawnParticle(Particle.LAVA, location, 4, 0.5, 0.05, 0.5, 0.1);
                n = 0;
                while (n < 5) {
                    d = Math.toRadians(72.0 * (double)n);
                    double d2 = Math.toRadians(72.0 * (double)(n + 2));
                    double d3 = Math.cos(d) * 2.5;
                    double d4 = Math.sin(d) * 2.5;
                    double d5 = Math.cos(d2) * 2.5 - d3;
                    double d6 = Math.sin(d2) * 2.5 - d4;
                    double d7 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * d6);
                    double d8 = 0.0;
                    while (d8 < d7 / 6.7) {
                        world.spawnParticle(Particle.FLAME, location.clone().add(d3 + d5 * d8, 0.0, d4 + d6 * d8), 1, 0.0, 0.0, 0.0, 1.0E-4);
                        d8 += 0.05;
                    }
                    ++n;
                }
                if (nArray[1] > 0) {
                    nArray[1] = nArray[1] - 1;
                    return;
                }
                Iterator iterator = world.getNearbyEntities(location, 1.0, 2.0, 1.0, entity -> entity instanceof Player && !Utils.isPlayerImmune((Player)entity)).iterator();
                if (iterator.hasNext()) {
                    Entity entity2 = (Entity)iterator.next();
                    PumpkinKing.this.createBloodWorm(location, (LivingEntity)entity2);
                    this.cancel();
                    return;
                }
                if (nArray[0] % 15 == 0) {
                    world.playSound(location, Sound.BLOCK_FIRE_AMBIENT, SoundCategory.HOSTILE, 2.0f, 0.5f);
                }
                if ((nArray[0] = nArray[0] - 1) <= 0) {
                    this.cancel();
                    return;
                }
            }
        };
    }

    private void createBloodWorm(final Location location, final LivingEntity livingEntity) {
        final FallingBlock[] fallingBlockArray = new FallingBlock[30];
        final ArmorStand[] armorStandArray = new ArmorStand[16];
        final int[] nArray = new int[4];
        final double[] dArray = new double[]{0.0};
        final Location location2 = location.clone();
        final BlockData blockData = Material.REDSTONE_BLOCK.createBlockData();
        final World world = location2.getWorld();
        final EvokerFangs[] evokerFangsArray = new EvokerFangs[]{(EvokerFangs)world.spawnEntity(livingEntity.getLocation().subtract(0.0, 0.5, 0.0), EntityType.EVOKER_FANGS)};
        final Vector[] vectorArray = new Vector[60];
        final boolean[] blArray = new boolean[]{true};
        world.playSound(location, Sound.ITEM_FIRECHARGE_USE, SoundCategory.HOSTILE, 1.0f, 0.5f);
        int n = 0;
        while (n < 30) {
            vectorArray[n] = new Vector(0.005, 0.0, 0.005);
            vectorArray[n + 30] = vectorArray[n].clone().multiply(10);
            ++n;
        }
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                int n;
                int n2;
                FallingBlock[] fallingBlockArray2;
                if (livingEntity.isDead()) {
                    blArray[0] = false;
                }
                int n3 = 0;
                while (n3 < 30) {
                    if (fallingBlockArray[n3] != null) {
                        fallingBlockArray[n3].setVelocity(fallingBlockArray[n3].getVelocity().add(vectorArray[n3]));
                        if (vectorArray[n3 + 30].getX() > 0.0 && fallingBlockArray[n3].getVelocity().getX() >= vectorArray[n3 + 30].getX() || vectorArray[n3 + 30].getX() < 0.0 && fallingBlockArray[n3].getVelocity().getX() <= vectorArray[n3 + 30].getX()) {
                            vectorArray[n3].multiply(-1);
                            vectorArray[n3 + 30].multiply(-1);
                        }
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < 16) {
                    if (armorStandArray[n3] != null) {
                        armorStandArray[n3].teleport(fallingBlockArray[Math.max(0, n3 * 2 - 1)].getLocation());
                        armorStandArray[n3].setHeadPose(armorStandArray[n3].getHeadPose().add(Math.toRadians(PumpkinKing.this.rand.nextInt(6) - 3), 0.0, 0.0));
                    }
                    ++n3;
                }
                int n4 = nArray[3];
                nArray[3] = n4 + 1;
                if (n4 == 10) {
                    nArray[3] = 0;
                    if (((PumpkinKing)PumpkinKing.this).plugin.mcVersion >= 1.2) {
                        world.playSound(location, Sound.BLOCK_SCULK_SHRIEKER_SHRIEK, SoundCategory.HOSTILE, 1.0f, 0.5f);
                    }
                    world.playSound(location, Sound.BLOCK_FIRE_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.5f);
                }
                if (nArray[1] <= 0) {
                    n3 = 0;
                    while (n3 < 30) {
                        if (fallingBlockArray[n3] != null) {
                            fallingBlockArray[n3].setVelocity(fallingBlockArray[n3].getVelocity().setY(0.32));
                        }
                        ++n3;
                    }
                    if (nArray[0] % 2 == 0) {
                        fallingBlockArray[nArray[0] / 2] = PumpkinKing.this.createBlockForBloodWorm(location2.clone().subtract((PumpkinKing.this.rand.nextDouble() - 0.5) / 4.0, 0.0, (PumpkinKing.this.rand.nextDouble() - 0.5) / 4.0));
                    }
                    if (nArray[0] > 4 && nArray[0] % 4 == 0 && PumpkinKing.this.rand.nextInt(2) == 0) {
                        armorStandArray[nArray[0] / 4] = PumpkinKing.this.createStandForBloodWorm(fallingBlockArray[nArray[0] / 2].getLocation());
                    }
                    nArray[0] = nArray[0] + 1;
                    evokerFangsArray[0].remove();
                    evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(fallingBlockArray[0].getLocation().clone().add(0.0, 1.5, 0.0), EntityType.EVOKER_FANGS);
                    evokerFangsArray[0].setSilent(true);
                    dArray[0] = dArray[0] + 1.6666666666666667;
                    if (fallingBlockArray[29] != null || !blArray[0] || livingEntity.getLocation().add(0.0, 2.0, 0.0).getBlock().getType().isSolid()) {
                        nArray[1] = 1;
                        evokerFangsArray[0].setSilent(false);
                        fallingBlockArray2 = fallingBlockArray;
                        n2 = fallingBlockArray.length;
                        n = 0;
                        while (n < n2) {
                            FallingBlock fallingBlock = fallingBlockArray2[n];
                            if (fallingBlock != null) {
                                fallingBlock.setVelocity(fallingBlock.getVelocity().setY(0));
                            }
                            ++n;
                        }
                    }
                    if (!(!blArray[0] || livingEntity.isDead() || evokerFangsArray[0].isDead() || livingEntity instanceof Player && Utils.isPlayerImmune((Player)livingEntity))) {
                        if (!livingEntity.getWorld().equals(world) || livingEntity.getLocation().distanceSquared(evokerFangsArray[0].getLocation()) >= 3.0) {
                            livingEntity.teleport(evokerFangsArray[0].getLocation());
                            if (((PumpkinKing)PumpkinKing.this).plugin.mcVersion >= 1.2 && PumpkinKing.this.rand.nextInt(3) == 0) {
                                world.playSound(livingEntity.getLocation().add(0.0, 4.0, 0.0), Sound.BLOCK_SCULK_SHRIEKER_SHRIEK, SoundCategory.HOSTILE, 1.0f, 0.5f);
                            }
                        }
                        try {
                            livingEntity.setVelocity(Utils.getVectorTowards(livingEntity.getLocation(), evokerFangsArray[0].getLocation()).multiply(0.3).setY(evokerFangsArray[0].getLocation().getY() - livingEntity.getLocation().getY()));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return;
                        }
                    }
                } else {
                    if (nArray[0] <= 0) {
                        if (nArray[0] == -2) {
                            evokerFangsArray[0].remove();
                            this.cancel();
                            nArray[2] = 1;
                            return;
                        }
                        Location location3 = evokerFangsArray[0].getLocation().subtract(0.0, 0.4, 0.0);
                        evokerFangsArray[0].remove();
                        evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(location3, EntityType.EVOKER_FANGS);
                        nArray[0] = nArray[0] - 1;
                    } else if (nArray[1] >= 40) {
                        n3 = 0;
                        while (n3 < 30) {
                            if (fallingBlockArray[n3] != null) {
                                fallingBlockArray[n3].setVelocity(fallingBlockArray[n3].getVelocity().setY(-0.4));
                            }
                            ++n3;
                        }
                        if (fallingBlockArray[0] != null) {
                            evokerFangsArray[0].remove();
                            evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(fallingBlockArray[0].getLocation().clone().add(0.0, 1.5, 0.0), EntityType.EVOKER_FANGS);
                            evokerFangsArray[0].setSilent(true);
                        } else {
                            Location location4 = evokerFangsArray[0].getLocation().subtract(0.0, 0.4, 0.0);
                            evokerFangsArray[0].remove();
                            evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(location4, EntityType.EVOKER_FANGS);
                        }
                        nArray[0] = nArray[0] - 1;
                        if (nArray[0] % 2 == 0 && fallingBlockArray[nArray[0] / 2] != null) {
                            fallingBlockArray[nArray[0] / 2].remove();
                            PumpkinKing.this.toRemove.remove(fallingBlockArray[nArray[0] / 2]);
                            fallingBlockArray[nArray[0] / 2] = null;
                        }
                        if (nArray[0] % 4 == 0 && armorStandArray[nArray[0] / 4] != null) {
                            armorStandArray[nArray[0] / 4].remove();
                            PumpkinKing.this.toRemove.remove(armorStandArray[nArray[0] / 4]);
                            armorStandArray[nArray[0] / 4] = null;
                        }
                        if (!(!blArray[0] || livingEntity.isDead() || evokerFangsArray[0].isDead() || livingEntity instanceof Player && Utils.isPlayerImmune((Player)livingEntity))) {
                            if (!livingEntity.getWorld().equals(world) || livingEntity.getLocation().distanceSquared(evokerFangsArray[0].getLocation()) >= 3.0) {
                                livingEntity.teleport(evokerFangsArray[0].getLocation());
                                if (((PumpkinKing)PumpkinKing.this).plugin.mcVersion >= 1.2 && PumpkinKing.this.rand.nextInt(3) == 0) {
                                    world.playSound(livingEntity.getLocation().subtract(0.0, 1.0, 0.0), Sound.BLOCK_SCULK_SHRIEKER_SHRIEK, SoundCategory.HOSTILE, 1.0f, 0.5f);
                                }
                            }
                            livingEntity.setVelocity(Utils.getVectorTowards(livingEntity.getLocation(), evokerFangsArray[0].getLocation().subtract(0.0, 2.0, 0.0)).multiply(0.3).setY(evokerFangsArray[0].getLocation().getY() - 0.5 - livingEntity.getLocation().getY()));
                            livingEntity.setFallDistance(0.0f);
                        }
                    } else if (nArray[1] <= 25) {
                        evokerFangsArray[0].remove();
                        if (nArray[1] != 25) {
                            evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(fallingBlockArray[0].getLocation().clone().add(0.0, 1.5, 0.0), EntityType.EVOKER_FANGS);
                            evokerFangsArray[0].setSilent(true);
                        } else {
                            evokerFangsArray[0] = (EvokerFangs)world.spawnEntity(fallingBlockArray[0].getLocation().clone().add(0.0, 1.0, 0.0), EntityType.EVOKER_FANGS);
                            evokerFangsArray[0].setMetadata("dd-pumpkinkingbloodfang", (MetadataValue)((PumpkinKing)PumpkinKing.this).plugin.fixedData);
                        }
                        if (!(!blArray[0] || livingEntity.isDead() || evokerFangsArray[0].isDead() || livingEntity instanceof Player && Utils.isPlayerImmune((Player)livingEntity))) {
                            if (!livingEntity.getWorld().equals(world) || livingEntity.getLocation().distanceSquared(evokerFangsArray[0].getLocation()) >= 3.0) {
                                livingEntity.teleport(evokerFangsArray[0].getLocation());
                            }
                            livingEntity.setVelocity(Utils.getVectorTowards(livingEntity.getLocation(), evokerFangsArray[0].getLocation().subtract(0.0, 2.0, 0.0)).multiply(0.3).setY(evokerFangsArray[0].getLocation().getY() - livingEntity.getLocation().getY()));
                        }
                    } else if (!(!blArray[0] || livingEntity.isDead() || evokerFangsArray[0].isDead() || livingEntity instanceof Player && Utils.isPlayerImmune((Player)livingEntity))) {
                        if (!livingEntity.getWorld().equals(world) || livingEntity.getLocation().distanceSquared(evokerFangsArray[0].getLocation()) >= 3.0) {
                            livingEntity.teleport(evokerFangsArray[0].getLocation());
                        }
                        livingEntity.setVelocity(Utils.getVectorTowards(livingEntity.getLocation(), evokerFangsArray[0].getLocation().subtract(0.0, 2.0, 0.0)).multiply(0.3).setY(evokerFangsArray[0].getLocation().getY() - livingEntity.getLocation().getY()));
                    }
                    nArray[1] = nArray[1] + 1;
                }
                fallingBlockArray2 = fallingBlockArray;
                n2 = fallingBlockArray.length;
                n = 0;
                while (n < n2) {
                    FallingBlock fallingBlock = fallingBlockArray2[n];
                    if (fallingBlock != null) {
                        world.spawnParticle(Particle.BLOCK_DUST, fallingBlock.getLocation().clone().add(0.0, 1.5, 0.0), 1, 0.1, 0.1, 0.1, 0.1, (Object)blockData);
                    }
                    ++n;
                }
            }
        };
        final Location location3 = location.clone();
        new AsyncRepeatingTask(this.plugin, 1, 1){

            @Override
            public void run() {
                double d;
                if (nArray[2] == 1) {
                    this.cancel();
                    return;
                }
                int n = 0;
                while (n < 50) {
                    d = Math.toRadians(7.2 * (double)n);
                    world.spawnParticle(Particle.FLAME, location3.clone().add(Math.cos(d) * 2.0, 0.0, Math.sin(d) * 2.0), 1, 0.0, 0.0, 0.0, 1.0E-4);
                    ++n;
                }
                world.spawnParticle(Particle.LAVA, location3, 4, 0.5, 0.05, 0.5, 0.1);
                n = 0;
                while (n < 5) {
                    d = Math.toRadians(72.0 * (double)n);
                    double d2 = Math.toRadians(72.0 * (double)(n + 2));
                    double d3 = Math.cos(d) * 2.5;
                    double d4 = Math.sin(d) * 2.5;
                    double d5 = Math.cos(d2) * 2.5 - d3;
                    double d6 = Math.sin(d2) * 2.5 - d4;
                    double d7 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * d6);
                    double d8 = 0.0;
                    while (d8 < d7 / 6.7) {
                        world.spawnParticle(Particle.FLAME, location3.clone().add(d3 + d5 * d8, 0.0, d4 + d6 * d8), 1, 0.0, 0.0, 0.0, 1.0E-4);
                        d8 += 0.05;
                    }
                    ++n;
                }
            }
        };
    }

    private FallingBlock createBlockForBloodWorm(Location location) {
        FallingBlock fallingBlock = location.getWorld().spawnFallingBlock(location, Material.CHAIN.createBlockData());
        fallingBlock.setGravity(false);
        fallingBlock.setDropItem(false);
        fallingBlock.setMetadata("dd-fbcancel", (MetadataValue)this.plugin.fixedData);
        this.toRemove.add((Entity)fallingBlock);
        return fallingBlock;
    }

    private ArmorStand createStandForBloodWorm(Location location) {
        location.setYaw((float)this.rand.nextInt(360));
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setGravity(false);
        armorStand.setMarker(true);
        armorStand.setSmall(true);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        armorStand.getEquipment().setHelmet(CustomHead.BLOODWORMEYE.getHead());
        armorStand.setHeadPose(new EulerAngle(Math.toRadians(this.rand.nextInt(180)), 0.0, 0.0));
        armorStand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.toRemove.add((Entity)armorStand);
        return armorStand;
    }

    public ArmorStand spawnTarget(Location location) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setMarker(true);
        armorStand.setGravity(false);
        armorStand.setSmall(true);
        armorStand.setCollidable(false);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        armorStand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        return armorStand;
    }

    public static boolean summonPumpkinKing(Main main, Block block) {
        DeathParade deathParade2;
        Object object;
        pumpkinBasketBlocks.add(block);
        World world = block.getWorld();
        Location location = Utils.findSmartYSpawn(block.getLocation(), Utils.getSpotInSquareRadius(block.getLocation(), 30), 2, 15);
        int n = 0;
        while (n < 30) {
            if (location != null && location.getBlock().isPassable()) break;
            location = Utils.findSmartYSpawn(block.getLocation(), Utils.getSpotInSquareRadius(block.getLocation(), 30), 2, 15);
            ++n;
        }
        if (location == null) {
            return false;
        }
        for (Player player : world.getPlayers()) {
            player.sendMessage(Utils.chat(ChatColor.RED + Languages.getString("halloween.deathParade")));
        }
        WitherSkeleton witherSkeleton = (WitherSkeleton)world.spawnEntity(location.clone().add(150.0, 300.0, 0.0), EntityType.WITHER_SKELETON, false);
        witherSkeleton.setRemoveWhenFarAway(false);
        witherSkeleton.teleport(location);
        PumpkinKing pumpkinKing = new PumpkinKing((Mob)witherSkeleton, main, main.random);
        main.handler.addEntity(pumpkinKing);
        if (main.noteBlockAPIEnabled && ((Boolean)CustomEntityType.PUMPKINKING.grabCustomSetting("play_boss_music")).booleanValue()) {
            object = new SongPlayer(NBSongs.HALLOWEEN_BOSS);
            for (DeathParade deathParade2 : world.getNearbyEntities(block.getLocation(), 30.0, 30.0, 30.0)) {
                if (!(deathParade2 instanceof Player)) continue;
                ((SongPlayer)object).addPlayer((Player)deathParade2);
            }
            ((SongPlayer)object).setLooping(true);
            ((SongPlayer)object).setVolume((byte)((Double)CustomEntityType.PUMPKINKING.grabCustomSetting("boss_music_volume") * 100.0));
            ((SongPlayer)object).setPlaying(true);
            pumpkinKing.songPlayer = object;
        }
        object = pumpkinKing.spawnTarget(block.getLocation().add(0.5, 0.5, 0.5));
        pumpkinKing.basketTarget = object;
        deathParade2 = new DeathParade(5);
        deathParade2.kingUUID = witherSkeleton.getUniqueId();
        pumpkinKing.parade = deathParade2;
        deathParade2.start(location, null);
        Object object2 = new boolean[1];
        object2[0] = false;
        new RepeatingTask(main, 0, 1, (boolean[])object2, main, world, block){
            private final /* synthetic */ boolean[] val$end;
            private final /* synthetic */ Main val$plugin;
            private final /* synthetic */ World val$world;
            private final /* synthetic */ Block val$block;
            {
                this.val$end = blArray;
                this.val$plugin = main;
                this.val$world = world;
                this.val$block = block;
                super(javaPlugin, n, n2);
            }

            @Override
            public void run() {
                if (this.val$end[0]) {
                    this.cancel();
                    return;
                }
                int n = 0;
                while (n < 8) {
                    Particle.DustTransition dustTransition = new Particle.DustTransition(Color.BLACK, Color.fromRGB((int)255, (int)(this.val$plugin.random.nextInt(40) + 80), (int)0), this.val$plugin.random.nextFloat() / 2.0f);
                    this.val$world.spawnParticle(Particle.DUST_COLOR_TRANSITION, this.val$block.getLocation().add(0.5, 0.3, 0.5).add(this.val$plugin.random.nextDouble() / 1.5 - 0.3, this.val$plugin.random.nextDouble() / 1.5 - 0.3, this.val$plugin.random.nextDouble() / 1.5 - 0.3), 1, 0.0, 0.0, 0.0, 0.001, (Object)dustTransition);
                    ++n;
                }
            }
        };
        main.getServer().getScheduler().runTaskLater((Plugin)main, () -> PumpkinKing.lambda$11(block, world, witherSkeleton, (ArmorStand)object, (boolean[])object2), 300L);
        return true;
    }

    private static /* synthetic */ void lambda$11(Block block, World world, WitherSkeleton witherSkeleton, ArmorStand armorStand, boolean[] blArray) {
        pumpkinBasketBlocks.remove(block);
        block.setType(Material.AIR);
        world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 0.3, 0.5), 30, 0.2, 0.2, 0.2, 1.0E-4, (Object)Material.ORANGE_WOOL.createBlockData());
        world.playSound(block.getLocation().add(0.5, 0.3, 0.5), Sound.BLOCK_WOOL_BREAK, SoundCategory.BLOCKS, 1.0f, 0.5f);
        witherSkeleton.setRemoveWhenFarAway(true);
        armorStand.remove();
        blArray[0] = true;
    }
}

