/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.halloweenentities;

import deadlydisasters.Main;
import deadlydisasters.entities.AnimatedEntity;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.AnimationHandler;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Scarecrow
extends AnimatedEntity {
    private int cooldown;
    private Random rand;
    private UUID standUUID;
    private AnimationHandler throwAnimation;
    private boolean throwing;
    private Slime projectile;
    private ArmorStand pumpkin;
    private Location step;

    public Scarecrow(Zombie zombie, Main main, Random random) {
        super((Mob)zombie, main);
        this.entityType = CustomEntityType.SCARECROW;
        this.rand = random;
        this.species = this.entityType.species;
        this.entity.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.entity.setMetadata("dd-scarecrow", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        this.entity.setMetadata("dd-halloweenmobs", (MetadataValue)main.fixedData);
        this.entity.getEquipment().setHelmetDropChance(0.0f);
        this.entity.setCanPickupItems(false);
        this.entity.setSilent(true);
        this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        this.entity.setHealth(this.entityType.getHealth());
        this.entity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.5);
        this.entity.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        this.entity.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        this.entity.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
        this.stand = (ArmorStand)this.entity.getWorld().spawnEntity(this.entity.getLocation().clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        this.stand = Utils.lockArmorStand(this.stand, false, true, true);
        this.stand.setBasePlate(false);
        this.stand.getEquipment().setItemInMainHand(new ItemStack(Material.JACK_O_LANTERN));
        ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), CustomHead.SCARECROW.getHead()};
        int n = 0;
        while (n < 3) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStackArray[n].getItemMeta();
            leatherArmorMeta.setColor(Color.fromRGB((int)105, (int)68, (int)31));
            itemStackArray[n].setItemMeta((ItemMeta)leatherArmorMeta);
            ++n;
        }
        this.stand.getEquipment().setArmorContents(itemStackArray);
        this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.standUUID = this.stand.getUniqueId();
        if (!zombie.isAdult()) {
            this.stand.setSmall(true);
        }
        if (this.entity.getCustomName() == null) {
            this.entity.setCustomName(Languages.getString("halloween.scarecrow"));
        }
        this.walkAnimation = new AnimationHandler(true, true, true);
        this.walkAnimation.setContinueFrame(1);
        AnimationHandler.Animation[] animationArray = new AnimationHandler.Animation[5];
        AnimationHandler animationHandler = this.walkAnimation;
        animationHandler.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray = new AnimationHandler.AnimationCheckpoint[5];
        AnimationHandler animationHandler2 = this.walkAnimation;
        animationHandler2.getClass();
        animationCheckpointArray[0] = new AnimationHandler.AnimationCheckpoint(animationHandler2, AnimationHandler.BodyPart.RIGHT_LEG, 0.0, 0.0, 0.0, -30.0, 0.0, 10.0, 12, false, 0.5, 0.5);
        AnimationHandler animationHandler3 = this.walkAnimation;
        animationHandler3.getClass();
        animationCheckpointArray[1] = new AnimationHandler.AnimationCheckpoint(animationHandler3, AnimationHandler.BodyPart.LEFT_LEG, 0.0, 0.0, 0.0, 30.0, 0.0, -10.0, 12, false, 0.5, 0.5);
        AnimationHandler animationHandler4 = this.walkAnimation;
        animationHandler4.getClass();
        animationCheckpointArray[2] = new AnimationHandler.AnimationCheckpoint(animationHandler4, AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, 20.0, 0.0, 10.0, 12, false, 0.5, 0.5);
        AnimationHandler animationHandler5 = this.walkAnimation;
        animationHandler5.getClass();
        animationCheckpointArray[3] = new AnimationHandler.AnimationCheckpoint(animationHandler5, AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, -20.0, 0.0, -10.0, 12, false, 0.5, 0.5);
        AnimationHandler animationHandler6 = this.walkAnimation;
        animationHandler6.getClass();
        animationCheckpointArray[4] = new AnimationHandler.AnimationCheckpoint(animationHandler6, AnimationHandler.BodyPart.HEAD, 0.0, 0.0, 0.0, 0.0, 0.0, 30.0, 12, false, 0.5, 0.5);
        animationArray[0] = new AnimationHandler.Animation(animationHandler, animationCheckpointArray);
        AnimationHandler animationHandler7 = this.walkAnimation;
        animationHandler7.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray2 = new AnimationHandler.AnimationCheckpoint[5];
        AnimationHandler animationHandler8 = this.walkAnimation;
        animationHandler8.getClass();
        animationCheckpointArray2[0] = new AnimationHandler.AnimationCheckpoint(animationHandler8, AnimationHandler.BodyPart.RIGHT_LEG, -30.0, 0.0, 10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler9 = this.walkAnimation;
        animationHandler9.getClass();
        animationCheckpointArray2[1] = new AnimationHandler.AnimationCheckpoint(animationHandler9, AnimationHandler.BodyPart.LEFT_LEG, 30.0, 0.0, -10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler10 = this.walkAnimation;
        animationHandler10.getClass();
        animationCheckpointArray2[2] = new AnimationHandler.AnimationCheckpoint(animationHandler10, AnimationHandler.BodyPart.RIGHT_ARM, 20.0, 0.0, 10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler11 = this.walkAnimation;
        animationHandler11.getClass();
        animationCheckpointArray2[3] = new AnimationHandler.AnimationCheckpoint(animationHandler11, AnimationHandler.BodyPart.LEFT_ARM, -20.0, 0.0, -10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler12 = this.walkAnimation;
        animationHandler12.getClass();
        animationCheckpointArray2[4] = new AnimationHandler.AnimationCheckpoint(animationHandler12, AnimationHandler.BodyPart.HEAD, 0.0, 0.0, 30.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        animationArray[1] = new AnimationHandler.Animation(animationHandler7, animationCheckpointArray2);
        AnimationHandler animationHandler13 = this.walkAnimation;
        animationHandler13.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray3 = new AnimationHandler.AnimationCheckpoint[5];
        AnimationHandler animationHandler14 = this.walkAnimation;
        animationHandler14.getClass();
        animationCheckpointArray3[0] = new AnimationHandler.AnimationCheckpoint(animationHandler14, AnimationHandler.BodyPart.RIGHT_LEG, 0.0, 0.0, 0.0, 30.0, 0.0, 10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler15 = this.walkAnimation;
        animationHandler15.getClass();
        animationCheckpointArray3[1] = new AnimationHandler.AnimationCheckpoint(animationHandler15, AnimationHandler.BodyPart.LEFT_LEG, 0.0, 0.0, 0.0, -30.0, 0.0, -10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler16 = this.walkAnimation;
        animationHandler16.getClass();
        animationCheckpointArray3[2] = new AnimationHandler.AnimationCheckpoint(animationHandler16, AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, -20.0, 0.0, 10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler17 = this.walkAnimation;
        animationHandler17.getClass();
        animationCheckpointArray3[3] = new AnimationHandler.AnimationCheckpoint(animationHandler17, AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, 20.0, 0.0, -10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler18 = this.walkAnimation;
        animationHandler18.getClass();
        animationCheckpointArray3[4] = new AnimationHandler.AnimationCheckpoint(animationHandler18, AnimationHandler.BodyPart.HEAD, 0.0, 0.0, 0.0, 0.0, 0.0, -30.0, 12, false, 0.0, 0.5);
        animationArray[2] = new AnimationHandler.Animation(animationHandler13, animationCheckpointArray3);
        AnimationHandler animationHandler19 = this.walkAnimation;
        animationHandler19.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray4 = new AnimationHandler.AnimationCheckpoint[5];
        AnimationHandler animationHandler20 = this.walkAnimation;
        animationHandler20.getClass();
        animationCheckpointArray4[0] = new AnimationHandler.AnimationCheckpoint(animationHandler20, AnimationHandler.BodyPart.RIGHT_LEG, 30.0, 0.0, 10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler21 = this.walkAnimation;
        animationHandler21.getClass();
        animationCheckpointArray4[1] = new AnimationHandler.AnimationCheckpoint(animationHandler21, AnimationHandler.BodyPart.LEFT_LEG, -30.0, 0.0, -10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler22 = this.walkAnimation;
        animationHandler22.getClass();
        animationCheckpointArray4[2] = new AnimationHandler.AnimationCheckpoint(animationHandler22, AnimationHandler.BodyPart.RIGHT_ARM, -20.0, 0.0, 10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler23 = this.walkAnimation;
        animationHandler23.getClass();
        animationCheckpointArray4[3] = new AnimationHandler.AnimationCheckpoint(animationHandler23, AnimationHandler.BodyPart.LEFT_ARM, 20.0, 0.0, -10.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        AnimationHandler animationHandler24 = this.walkAnimation;
        animationHandler24.getClass();
        animationCheckpointArray4[4] = new AnimationHandler.AnimationCheckpoint(animationHandler24, AnimationHandler.BodyPart.HEAD, 0.0, 0.0, -30.0, 0.0, 0.0, 0.0, 12, false, 0.5, 0.0);
        animationArray[3] = new AnimationHandler.Animation(animationHandler19, animationCheckpointArray4);
        AnimationHandler animationHandler25 = this.walkAnimation;
        animationHandler25.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray5 = new AnimationHandler.AnimationCheckpoint[5];
        AnimationHandler animationHandler26 = this.walkAnimation;
        animationHandler26.getClass();
        animationCheckpointArray5[0] = new AnimationHandler.AnimationCheckpoint(animationHandler26, AnimationHandler.BodyPart.RIGHT_LEG, 0.0, 0.0, 0.0, -30.0, 0.0, 10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler27 = this.walkAnimation;
        animationHandler27.getClass();
        animationCheckpointArray5[1] = new AnimationHandler.AnimationCheckpoint(animationHandler27, AnimationHandler.BodyPart.LEFT_LEG, 0.0, 0.0, 0.0, 30.0, 0.0, -10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler28 = this.walkAnimation;
        animationHandler28.getClass();
        animationCheckpointArray5[2] = new AnimationHandler.AnimationCheckpoint(animationHandler28, AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, 20.0, 0.0, 10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler29 = this.walkAnimation;
        animationHandler29.getClass();
        animationCheckpointArray5[3] = new AnimationHandler.AnimationCheckpoint(animationHandler29, AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, -20.0, 0.0, -10.0, 12, false, 0.0, 0.5);
        AnimationHandler animationHandler30 = this.walkAnimation;
        animationHandler30.getClass();
        animationCheckpointArray5[4] = new AnimationHandler.AnimationCheckpoint(animationHandler30, AnimationHandler.BodyPart.HEAD, 0.0, 0.0, 0.0, 0.0, 0.0, 30.0, 12, false, 0.0, 0.5);
        animationArray[4] = new AnimationHandler.Animation(animationHandler25, animationCheckpointArray5);
        this.walkAnimation.setAnimations(animationArray);
        this.rotationSpeed = 20.0f;
        this.throwAnimation = new AnimationHandler(true, true, false);
        AnimationHandler.Animation[] animationArray2 = new AnimationHandler.Animation[3];
        AnimationHandler animationHandler31 = this.throwAnimation;
        animationHandler31.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray6 = new AnimationHandler.AnimationCheckpoint[5];
        AnimationHandler animationHandler32 = this.throwAnimation;
        animationHandler32.getClass();
        animationCheckpointArray6[0] = new AnimationHandler.AnimationCheckpoint(animationHandler32, AnimationHandler.BodyPart.RIGHT_LEG, 0.0, 0.0, 0.0, -10.0, 0.0, 5.0, 8, true, 0.5, 0.5);
        AnimationHandler animationHandler33 = this.throwAnimation;
        animationHandler33.getClass();
        animationCheckpointArray6[1] = new AnimationHandler.AnimationCheckpoint(animationHandler33, AnimationHandler.BodyPart.LEFT_LEG, 0.0, 0.0, 0.0, 10.0, 0.0, -5.0, 8, true, 0.5, 0.5);
        AnimationHandler animationHandler34 = this.throwAnimation;
        animationHandler34.getClass();
        animationCheckpointArray6[2] = new AnimationHandler.AnimationCheckpoint(animationHandler34, AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, -360.0, 0.0, 15.0, 20, false, 0.5, 0.5);
        AnimationHandler animationHandler35 = this.throwAnimation;
        animationHandler35.getClass();
        animationCheckpointArray6[3] = new AnimationHandler.AnimationCheckpoint(animationHandler35, AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, -10.0, 0.0, -5.0, 8, true, 0.5, 0.5);
        AnimationHandler animationHandler36 = this.throwAnimation;
        animationHandler36.getClass();
        animationCheckpointArray6[4] = new AnimationHandler.AnimationCheckpoint(animationHandler36, AnimationHandler.BodyPart.HEAD, 0.0, 0.0, 0.0, 0.0, 0.0, 20.0, 8, true, 0.5, 0.5);
        animationArray2[0] = new AnimationHandler.Animation(animationHandler31, animationCheckpointArray6);
        AnimationHandler animationHandler37 = this.throwAnimation;
        animationHandler37.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray7 = new AnimationHandler.AnimationCheckpoint[5];
        AnimationHandler animationHandler38 = this.throwAnimation;
        animationHandler38.getClass();
        animationCheckpointArray7[0] = new AnimationHandler.AnimationCheckpoint(animationHandler38, AnimationHandler.BodyPart.RIGHT_LEG, 0.0, 0.0, 0.0, 10.0, 0.0, 5.0, 6, true, 0.5, 0.5);
        AnimationHandler animationHandler39 = this.throwAnimation;
        animationHandler39.getClass();
        animationCheckpointArray7[1] = new AnimationHandler.AnimationCheckpoint(animationHandler39, AnimationHandler.BodyPart.LEFT_LEG, 0.0, 0.0, 0.0, -10.0, 0.0, -5.0, 6, true, 0.5, 0.5);
        AnimationHandler animationHandler40 = this.throwAnimation;
        animationHandler40.getClass();
        animationCheckpointArray7[2] = new AnimationHandler.AnimationCheckpoint(animationHandler40, AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, -360.0, 0.0, 15.0, 12, false, 0.5, 0.5);
        AnimationHandler animationHandler41 = this.throwAnimation;
        animationHandler41.getClass();
        animationCheckpointArray7[3] = new AnimationHandler.AnimationCheckpoint(animationHandler41, AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, 10.0, 0.0, -5.0, 6, true, 0.5, 0.5);
        AnimationHandler animationHandler42 = this.throwAnimation;
        animationHandler42.getClass();
        animationCheckpointArray7[4] = new AnimationHandler.AnimationCheckpoint(animationHandler42, AnimationHandler.BodyPart.HEAD, 0.0, 0.0, 0.0, 0.0, 0.0, -15.0, 6, true, 0.5, 0.5);
        animationArray2[1] = new AnimationHandler.Animation(animationHandler37, animationCheckpointArray7);
        AnimationHandler animationHandler43 = this.throwAnimation;
        animationHandler43.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray8 = new AnimationHandler.AnimationCheckpoint[5];
        AnimationHandler animationHandler44 = this.throwAnimation;
        animationHandler44.getClass();
        animationCheckpointArray8[0] = new AnimationHandler.AnimationCheckpoint(animationHandler44, AnimationHandler.BodyPart.RIGHT_LEG, 0.0, 0.0, 0.0, -10.0, 0.0, 5.0, 4, true, 0.5, 0.5);
        AnimationHandler animationHandler45 = this.throwAnimation;
        animationHandler45.getClass();
        animationCheckpointArray8[1] = new AnimationHandler.AnimationCheckpoint(animationHandler45, AnimationHandler.BodyPart.LEFT_LEG, 0.0, 0.0, 0.0, 10.0, 0.0, -5.0, 4, true, 0.5, 0.5);
        AnimationHandler animationHandler46 = this.throwAnimation;
        animationHandler46.getClass();
        animationCheckpointArray8[2] = new AnimationHandler.AnimationCheckpoint(animationHandler46, AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, -380.0, 0.0, 15.0, 6, false, 0.5, 0.5);
        AnimationHandler animationHandler47 = this.throwAnimation;
        animationHandler47.getClass();
        animationCheckpointArray8[3] = new AnimationHandler.AnimationCheckpoint(animationHandler47, AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, -10.0, 0.0, -5.0, 4, true, 0.5, 0.5);
        AnimationHandler animationHandler48 = this.throwAnimation;
        animationHandler48.getClass();
        animationCheckpointArray8[4] = new AnimationHandler.AnimationCheckpoint(animationHandler48, AnimationHandler.BodyPart.HEAD, 0.0, 0.0, 0.0, 0.0, 0.0, 15.0, 4, true, 0.5, 0.5);
        animationArray2[2] = new AnimationHandler.Animation(animationHandler43, animationCheckpointArray8);
        this.throwAnimation.setAnimations(animationArray2);
        this.step = this.entity.getLocation();
    }

    @Override
    public void tick() {
        if (this.entity == null || this.stand == null) {
            return;
        }
        super.tick();
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_WITHER_SKELETON_HURT, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
        if (this.step.distanceSquared(this.entity.getLocation()) > 6.0 && this.entity.isOnGround()) {
            this.step = this.entity.getLocation();
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_WITHER_SKELETON_STEP, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        Vector vector = this.entity.getVelocity().multiply(this.stand.getLocation().getDirection().setY(1.0));
        this.entity.setVelocity(vector);
        if (vector.setY(0).lengthSquared() > 0.005) {
            this.walkAnimation.setFrameRate(2);
        } else {
            this.walkAnimation.setFrameRate(1);
        }
        if (this.throwing) {
            this.throwAnimation.tick(this.stand);
            if (this.throwAnimation.isFinished()) {
                this.throwing = false;
                if (this.entity.getTarget() != null && this.entity.getTarget().getWorld().equals(this.entity.getWorld()) && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) < 400.0) {
                    this.throwPumpkin(this.entity.getTarget());
                }
            }
        }
        this.entity.getWorld().spawnParticle(Particle.BLOCK_DUST, this.entity.getLocation().clone().add(0.0, 1.1, 0.0), 1, 0.2, 0.4, 0.2, 1.0, (Object)Material.JACK_O_LANTERN.createBlockData());
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.stand == null) {
            this.clean();
            iterator.remove();
            return;
        }
        this.stand = (ArmorStand)this.plugin.getServer().getEntity(this.standUUID);
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.getWorld().spawnParticle(Particle.SOUL, this.entity.getLocation().add(0.0, 0.5, 0.0), 15, 0.3, 0.5, 0.3, 0.03);
            }
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_WITHER_SKELETON_DEATH, SoundCategory.HOSTILE, 2.0f, 0.5f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        if (this.rand.nextInt(6) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_WITHER_SKELETON_AMBIENT, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (Utils.isTargetInRange(this.entity, 25.0, 225.0, true)) {
            this.cooldown = 8;
            this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 60, 5, true, false, false));
            this.throwAnimation.startAnimation(this.stand);
            this.throwing = true;
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_WITHER_AMBIENT, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
    }

    @Override
    public void clean() {
        super.clean();
        if (this.pumpkin != null) {
            this.pumpkin.remove();
        }
        if (this.projectile != null) {
            this.projectile.remove();
        }
    }

    private void throwPumpkin(LivingEntity livingEntity) {
        this.pumpkin = Utils.lockArmorStand((ArmorStand)this.entity.getWorld().spawnEntity(this.entity.getLocation().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND), true, false, true);
        this.pumpkin.getEquipment().setHelmet(new ItemStack(Material.JACK_O_LANTERN));
        this.pumpkin.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.projectile = (Slime)this.entity.getWorld().spawn(this.entity.getLocation().add(0.0, 100.0, 0.0), Slime.class, slime -> {
            slime.setSize(0);
            slime.setSilent(true);
            slime.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(100.0);
            slime.setHealth(100.0);
            slime.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(0.0);
            slime.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
            slime.teleport((Entity)this.entity);
            slime.teleport(slime.getLocation().add(0.0, 1.0, 0.0));
            slime.setGravity(false);
        });
        Location location = livingEntity.getLocation().add(0.0, livingEntity.getHeight() / 2.0, 0.0);
        final Vector vector = Utils.getVectorTowards(this.projectile.getLocation(), location);
        vector.setX(vector.getX() / 3.0);
        vector.setZ(vector.getZ() / 3.0);
        vector.setY(location.distance(this.entity.getLocation()) / 13.0 + (location.getY() - this.entity.getLocation().getY()) / 30.0);
        this.stand.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
        this.attack();
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                if (Scarecrow.this.pumpkin == null || Scarecrow.this.pumpkin.isDead() || Scarecrow.this.projectile == null || Scarecrow.this.projectile.isDead() || Scarecrow.this.entity == null) {
                    if (Scarecrow.this.pumpkin != null) {
                        Scarecrow.this.pumpkin.remove();
                    }
                    Scarecrow.this.pumpkin = null;
                    if (Scarecrow.this.projectile != null) {
                        Scarecrow.this.projectile.remove();
                    }
                    if (Scarecrow.this.stand != null && !Scarecrow.this.stand.isDead()) {
                        Scarecrow.this.stand.getEquipment().setItemInMainHand(new ItemStack(Material.JACK_O_LANTERN));
                    }
                    this.cancel();
                    return;
                }
                Scarecrow.this.projectile.teleport(Scarecrow.this.projectile.getLocation().add(vector));
                Scarecrow.this.pumpkin.teleport(Scarecrow.this.projectile.getLocation().add(0.0, -2.0, 0.0));
                double d = Math.abs(vector.getX());
                if (Math.abs(vector.getZ()) > d) {
                    d = Math.abs(vector.getZ());
                }
                double d2 = Math.toDegrees(Math.atan2(Math.abs(vector.getY()), d));
                if (vector.getY() >= 0.0) {
                    Scarecrow.this.pumpkin.setHeadPose(new EulerAngle(Math.toRadians(360.0 - d2), 0.0, 0.0));
                } else {
                    Scarecrow.this.pumpkin.setHeadPose(new EulerAngle(Math.toRadians(360.0 + d2), 0.0, 0.0));
                }
                Scarecrow.this.pumpkin.getWorld().spawnParticle(Particle.BLOCK_CRACK, Scarecrow.this.pumpkin.getLocation().add(0.0, 2.0, 0.0), 2, 0.1, 0.1, 0.1, 1.0, (Object)Material.JACK_O_LANTERN.createBlockData());
                if (!Scarecrow.this.projectile.getLocation().getBlock().isPassable()) {
                    Scarecrow.this.pumpkin.remove();
                    Scarecrow.this.projectile.remove();
                    if (Scarecrow.this.stand != null && !Scarecrow.this.stand.isDead()) {
                        Scarecrow.this.stand.getEquipment().setItemInMainHand(new ItemStack(Material.JACK_O_LANTERN));
                    }
                    Scarecrow.this.pumpkin = null;
                    Scarecrow.this.projectile.getWorld().createExplosion(Scarecrow.this.projectile.getLocation(), 4.0f, true, true, (Entity)Scarecrow.this.entity);
                    this.cancel();
                    final int[] nArray = new int[]{20};
                    final Location location = Scarecrow.this.projectile.getLocation();
                    new RepeatingTask(Scarecrow.this.plugin, 0, 2){

                        @Override
                        public void run() {
                            location.getWorld().spawnParticle(Particle.REDSTONE, location, 30, 2.0, 2.0, 2.0, 0.001, (Object)new Particle.DustOptions(Color.ORANGE, 1.0f));
                            location.getWorld().spawnParticle(Particle.REDSTONE, location, 30, 2.0, 2.0, 2.0, 0.001, (Object)new Particle.DustOptions(Color.BLACK, 1.0f));
                            nArray[0] = nArray[0] - 1;
                            if (nArray[0] <= 0) {
                                this.cancel();
                            }
                        }
                    };
                    return;
                }
                vector.multiply(0.99);
                vector.setY(vector.getY() - (double)0.05f);
                for (Entity entity : Scarecrow.this.projectile.getNearbyEntities(0.5, 0.5, 0.5)) {
                    if (!(entity instanceof LivingEntity) || entity instanceof ArmorStand || entity.equals(Scarecrow.this.entity) || entity instanceof Player && Utils.isPlayerImmune((Player)entity)) continue;
                    Scarecrow.this.pumpkin.remove();
                    Scarecrow.this.projectile.remove();
                    if (Scarecrow.this.stand != null && !Scarecrow.this.stand.isDead()) {
                        Scarecrow.this.stand.getEquipment().setItemInMainHand(new ItemStack(Material.JACK_O_LANTERN));
                    }
                    Scarecrow.this.pumpkin = null;
                    Scarecrow.this.projectile.getWorld().createExplosion(Scarecrow.this.projectile.getLocation(), 4.0f, true, true, (Entity)Scarecrow.this.entity);
                    this.cancel();
                    final int[] nArray = new int[]{20};
                    final Location location = Scarecrow.this.projectile.getLocation();
                    new RepeatingTask(Scarecrow.this.plugin, 0, 2){

                        @Override
                        public void run() {
                            location.getWorld().spawnParticle(Particle.REDSTONE, location, 30, 2.0, 2.0, 2.0, 0.001, (Object)new Particle.DustOptions(Color.ORANGE, 1.0f));
                            location.getWorld().spawnParticle(Particle.REDSTONE, location, 30, 2.0, 2.0, 2.0, 0.001, (Object)new Particle.DustOptions(Color.BLACK, 1.0f));
                            nArray[0] = nArray[0] - 1;
                            if (nArray[0] <= 0) {
                                this.cancel();
                            }
                        }
                    };
                    return;
                }
            }
        };
    }
}

