/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.halloweenentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Zombie;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Vampire
extends CustomEntity {
    private boolean batForm;
    private Zombie zombie;
    public UUID zombieUUID;
    private double healthBarrier;
    private Random rand;

    public Vampire(Mob mob, Main main) {
        super(mob, main);
        this.rand = main.random;
        this.entityType = CustomEntityType.VAMPIRE;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.healthBarrier = this.entityType.getHealth() / 3.0;
        mob.setCanPickupItems(false);
        mob.setSilent(true);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        if (mob.getType() != EntityType.BAT) {
            mob.setAI(false);
            mob.setMetadata("dd-vampire", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
            this.zombie = (Zombie)mob.getWorld().spawn(mob.getLocation(), Zombie.class, false, zombie -> {
                zombie.setCanPickupItems(false);
                zombie.setSilent(true);
                zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
                zombie.setHealth(this.entityType.getHealth());
                zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
                zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
                zombie.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
                zombie.setMetadata("dd-vampire", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
                zombie.setMetadata("dd-halloweenmobs", (MetadataValue)main.fixedData);
                zombie.setMetadata("dd-customentity", (MetadataValue)main.fixedData);
                zombie.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, -1, 0, true, false));
                if (zombie.getCustomName() == null) {
                    zombie.setCustomName(Languages.getString("halloween.vampire"));
                }
            });
            this.zombieUUID = this.zombie.getUniqueId();
        } else {
            mob.setMetadata("dd-vampirebat", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        }
        mob.setMetadata("dd-halloweenmobs", (MetadataValue)main.fixedData);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("halloween.vampire"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null || this.entity.isDead()) {
            return;
        }
        if (!this.batForm) {
            if (this.zombie == null || this.zombie.isDead()) {
                return;
            }
            if (this.entity.getNoDamageTicks() == 20) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_EVOKER_HURT, SoundCategory.HOSTILE, 2.0f, 0.5f);
            }
            this.entity.teleport((Entity)this.zombie);
            if (this.zombie.getHealth() < this.entity.getHealth()) {
                this.entity.damage(1.0E-5);
                this.entity.setHealth(this.zombie.getHealth());
            } else if (this.entity.getHealth() < this.zombie.getHealth()) {
                this.zombie.setHealth(this.entity.getHealth());
            }
            if (this.entity.getHealth() <= this.healthBarrier) {
                this.batForm = true;
                Bat bat2 = (Bat)this.entity.getWorld().spawn(this.entity.getLocation(), Bat.class, bat -> {
                    bat.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
                    bat.setHealth(this.entity.getHealth());
                    bat.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
                    bat.setMetadata("dd-vampirebat", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
                    if (bat.getCustomName() == null) {
                        bat.setCustomName(Languages.getString("halloween.vampire"));
                    }
                });
                this.entity.getWorld().spawnParticle(Particle.SMOKE_NORMAL, this.entity.getLocation(), 15, 0.7, 0.7, 0.7, 0.001);
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_EVOKER_CAST_SPELL, SoundCategory.HOSTILE, 2.0f, 0.5f);
                this.entity.remove();
                this.zombie.remove();
                this.entity = bat2;
                this.entityUUID = bat2.getUniqueId();
            }
            return;
        }
        if (this.entity.getHealth() > this.healthBarrier) {
            this.batForm = false;
            Mob mob = (Mob)this.entity.getWorld().spawn(this.entity.getLocation(), Evoker.class, false, evoker -> {
                evoker.setCanPickupItems(false);
                evoker.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
                evoker.setHealth(this.entity.getHealth());
                evoker.setAI(false);
                evoker.setSilent(true);
                evoker.setMetadata("dd-vampire", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
                evoker.setMetadata("dd-halloweenmobs", (MetadataValue)this.plugin.fixedData);
                evoker.setMetadata("dd-customentity", (MetadataValue)this.plugin.fixedData);
                evoker.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
                if (evoker.getCustomName() == null) {
                    evoker.setCustomName(Languages.getString("halloween.vampire"));
                }
            });
            this.zombie = (Zombie)this.entity.getWorld().spawn(this.entity.getLocation(), Zombie.class, false, zombie -> {
                zombie.setCanPickupItems(false);
                zombie.setSilent(true);
                zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
                zombie.setHealth(this.entity.getHealth());
                zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
                zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
                zombie.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
                zombie.setMetadata("dd-vampire", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
                zombie.setMetadata("dd-halloweenmobs", (MetadataValue)this.plugin.fixedData);
                zombie.setMetadata("dd-customentity", (MetadataValue)this.plugin.fixedData);
                zombie.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, -1, 0, true, false));
                if (zombie.getCustomName() == null) {
                    zombie.setCustomName(Languages.getString("halloween.vampire"));
                }
            });
            this.zombieUUID = this.zombie.getUniqueId();
            this.entity.getWorld().spawnParticle(Particle.SMOKE_NORMAL, this.entity.getLocation().add(0.0, 1.0, 0.0), 15, 0.7, 1.0, 0.7, 0.001);
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_EVOKER_CAST_SPELL, SoundCategory.HOSTILE, 2.0f, 0.5f);
            this.entity.remove();
            this.entity = mob;
            this.entityUUID = mob.getUniqueId();
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.zombieUUID != null) {
            this.zombie = (Zombie)this.plugin.getServer().getEntity(this.zombieUUID);
        }
        if (this.entity == null) {
            iterator.remove();
            this.clean();
            return;
        }
        if (this.entity.isDead()) {
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_EVOKER_DEATH, SoundCategory.HOSTILE, 2.0f, 0.5f);
            iterator.remove();
            this.clean();
            return;
        }
        if (this.batForm) {
            this.entity.setHealth(Math.min(this.entity.getHealth() + 1.0, this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
            this.entity.getWorld().spawnParticle(Particle.COMPOSTER, this.entity.getLocation().add(0.0, 0.2, 0.0), 3, 0.3, 0.3, 0.3, 0.001);
        } else if (this.rand.nextInt(6) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_EVOKER_AMBIENT, SoundCategory.HOSTILE, 2.0f, 0.5f);
        }
    }

    @Override
    public void clean() {
        if (this.zombie != null) {
            this.zombie.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    public void bite(Entity entity) {
        this.entity.getWorld().spawnParticle(Particle.BLOCK_DUST, this.entity.getLocation().clone().add(0.0, 1.1, 0.0).add(Utils.getVectorTowards(this.entity.getLocation(), entity.getLocation()).multiply(0.8)), 20, 0.2, 0.2, 0.2, 1.0, (Object)Material.REDSTONE_BLOCK.createBlockData());
        this.entity.setHealth(Math.min(this.entity.getHealth() + this.entityType.getDamage() / 2.0, this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
        if (this.zombie != null) {
            this.zombie.setHealth(this.entity.getHealth());
        }
    }
}

