/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.infestedcavesentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class InfestedDevourer
extends CustomEntity {
    private ArmorStand stand;
    private Random rand;
    private double speed;
    private double damage;
    private LivingEntity target;
    private Location targetLoc;
    private int cooldown = 5;
    private int ticks = 0;
    private int damageTicks = 0;
    private Material material;
    private ArmorStand tempTarget;
    private Vector backVec;
    private boolean isAlpha;
    private ArmorStand targetBlock;
    private Location locationObject;
    public static Queue<Location> blockTargets = new ArrayDeque<Location>();

    public InfestedDevourer(Zombie zombie, Main main, Random random) {
        super((Mob)zombie, main);
        this.rand = random;
        this.entityType = CustomEntityType.INFESTEDDEVOURER;
        this.species = this.entityType.species;
        Utils.clearEntityOfItems((LivingEntity)zombie);
        if (main.mcVersion >= 1.16) {
            zombie.setBaby();
        } else {
            zombie.setBaby(true);
        }
        zombie.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        zombie.setCanPickupItems(false);
        zombie.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(25.0);
        zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(0.0);
        zombie.setMetadata("dd-infesteddevourer", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        zombie.setCustomName(Languages.getString("entities.infestedDevourer"));
        zombie.setSilent(true);
        if (random.nextDouble() * 100.0 < (Double)this.entityType.grabCustomSetting("alpha_spawn_chance")) {
            this.isAlpha = true;
            zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth() * 2.0);
            zombie.setHealth(this.entityType.getHealth() * 1.5);
            this.damage = this.entityType.getDamage() * 2.0;
            zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
        } else {
            zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
            zombie.setHealth(this.entityType.getHealth());
            this.damage = this.entityType.getDamage();
            zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
        }
        this.speed = zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getValue();
        this.spawnHeadStand();
        this.material = main.mcVersion >= 1.19 ? Material.SCULK : Material.NETHERRACK;
    }

    @Override
    public void tick() {
        if (this.entity == null || this.entity.isDead() || this.stand == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_FOX_EAT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        if (this.targetBlock != null && this.targetBlock.getLocation().getBlock().getType() == Material.AIR) {
            if (this.entity.getTarget() == this.targetBlock) {
                this.entity.setTarget(null);
            }
            this.targetBlock.remove();
            this.targetBlock = null;
        }
        if (this.ticks > 0) {
            Location location;
            --this.ticks;
            if (this.ticks <= 0) {
                this.entity.setAI(true);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.entity.setInvulnerable(false), 10L);
                this.entity.setGravity(true);
                this.entity.setTarget(this.target);
                location = null;
                Vector vector = null;
                double d = 0.0;
                int n = 0;
                while (n < 10) {
                    Vector vector2 = new Vector(this.rand.nextDouble() * 2.0 - 1.0, this.rand.nextDouble() * 2.0 - 1.0, this.rand.nextDouble() * 2.0 - 1.0).normalize().multiply(0.8);
                    Location location2 = this.targetLoc.clone().add(vector2);
                    int n2 = 0;
                    while (n2 < 6) {
                        if (!location2.getBlock().isPassable()) {
                            if (location2.getBlock().getType() != this.material) break;
                            double d2 = this.targetLoc.distanceSquared(location2);
                            if (location != null && !(d2 < d)) break;
                            location = location2;
                            vector = vector2;
                            d = d2;
                            break;
                        }
                        location2.add(vector2);
                        ++n2;
                    }
                    ++n;
                }
                if (location == null) {
                    this.entity.setVelocity(this.backVec);
                } else {
                    this.stand.remove();
                    this.entity.teleport(location.getBlock().getLocation().add(0.5, 0.5, 0.5));
                    this.spawnHeadStand();
                    this.entity.setVelocity(vector.clone().multiply(-0.5));
                }
            }
            this.stand.teleport(this.entity.getLocation().subtract(0.0, 0.6, 0.0));
            if (this.entity.getTarget() != null) {
                location = this.entity.getLocation().setDirection(this.entity.getTarget().getLocation().toVector().subtract(this.entity.getLocation().toVector()));
                this.stand.setRotation(location.getYaw(), 0.0f);
                this.stand.setHeadPose(new EulerAngle(Math.toRadians(location.getPitch()), 0.0, 0.0));
            } else {
                this.stand.setHeadPose(new EulerAngle(Math.toRadians(this.entity.getLocation().getPitch()), 0.0, 0.0));
            }
            return;
        }
        if (this.damageTicks > 0) {
            --this.damageTicks;
        }
        if (this.tempTarget != null) {
            this.entity.setTarget((LivingEntity)this.tempTarget);
            if (this.entity.getLocation().distanceSquared(this.tempTarget.getLocation()) <= 3.5) {
                this.entity.setAI(false);
                this.entity.setInvulnerable(true);
                this.entity.setGravity(false);
                this.backVec = Utils.getVectorTowards(this.entity.getLocation(), this.tempTarget.getLocation()).multiply(-0.3);
                this.entity.teleport(this.tempTarget.getLocation().subtract(0.0, 0.3, 0.0));
                this.tempTarget.remove();
                this.tempTarget = null;
                this.entity.setTarget(null);
                this.ticks = 60;
            } else if (this.tempTarget.getTicksLived() >= 160) {
                this.tempTarget.remove();
                this.tempTarget = null;
                this.entity.setTarget(this.target);
            }
        } else if (this.entity.getTarget() != null) {
            if (this.entity.isOnGround()) {
                this.entity.setVelocity(Utils.getVectorTowards(this.entity.getLocation(), this.entity.getTarget().getLocation()).multiply(this.speed).setY(0.45));
                if (this.plugin.mcVersion >= 1.19) {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_SCULK_STEP, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
            if (this.damageTicks <= 0 && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 1.25) {
                if (this.entity.getTarget() == this.targetBlock) {
                    if (!Utils.isBlockImmune(this.targetBlock.getLocation().getBlock().getType())) {
                        this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.targetBlock.getLocation(), 10, 0.5, 0.5, 0.5, 0.1, (Object)this.targetBlock.getLocation().getBlock().getBlockData());
                        this.targetBlock.getLocation().getBlock().setType(Material.AIR);
                        this.entity.setVelocity(Utils.getVectorTowards(this.entity.getLocation(), this.targetBlock.getLocation()).multiply(0.5));
                        this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_FOX_BITE, SoundCategory.HOSTILE, 1.0f, 0.5f);
                    }
                    blockTargets.remove(this.locationObject);
                    this.targetBlock.remove();
                    this.targetBlock = null;
                    this.entity.setTarget(null);
                    this.updateTarget();
                    this.damageTicks = 15;
                } else if (this.entity.hasLineOfSight((Entity)this.entity.getTarget())) {
                    Utils.damageEntity(this.entity.getTarget(), this.damage, "dd-devourdeath", false);
                    this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation().add(this.entity.getLocation().getDirection().multiply(0.3)), 5, 0.2, 0.2, 0.2, 0.1, (Object)Material.REDSTONE_BLOCK.createBlockData());
                    this.damageTicks = 15;
                    this.cooldown = 8;
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_FOX_BITE, SoundCategory.HOSTILE, 1.0f, 0.5f);
                }
            }
        }
        this.stand.teleport(this.entity.getLocation().subtract(0.0, 0.6, 0.0));
        if (this.entity.getTarget() != null) {
            Location location = this.entity.getLocation().setDirection(this.entity.getTarget().getLocation().toVector().subtract(this.entity.getLocation().toVector()));
            this.stand.setRotation(location.getYaw(), 0.0f);
            this.stand.setHeadPose(new EulerAngle(Math.toRadians(location.getPitch()), 0.0, 0.0));
        } else {
            this.stand.setHeadPose(new EulerAngle(Math.toRadians(this.entity.getLocation().getPitch()), 0.0, 0.0));
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        this.stand = (ArmorStand)this.plugin.getServer().getEntity(this.stand.getUniqueId());
        if (this.entity == null || this.stand == null) {
            this.clean();
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.19) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_SCULK_SHRIEKER_BREAK, SoundCategory.HOSTILE, 2.0f, 0.5f);
            }
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        if (this.ticks <= 0 && this.tempTarget == null && this.entity.getTarget() != null) {
            if (this.entity.getTarget().equals(this.target)) {
                --this.cooldown;
            } else {
                this.target = this.entity.getTarget();
                this.cooldown = 8;
            }
            if (this.cooldown <= 0) {
                int n = 0;
                block0: while (n < 10) {
                    Vector vector = new Vector(this.rand.nextDouble() * 2.0 - 1.0, 0.0, this.rand.nextDouble() * 2.0 - 1.0).normalize().setY((this.rand.nextDouble() / 2.0 - 0.7) / 2.0).multiply(0.8);
                    Location location = this.entity.getLocation().add(0.0, 1.0, 0.0).add(vector);
                    int n2 = 0;
                    while (n2 < 6) {
                        if (!location.getBlock().isPassable()) {
                            if (location.getBlock().getType() != this.material) break;
                            this.tempTarget = this.spawnTarget(location.getBlock().getLocation().add(0.5, 0.5, 0.5));
                            this.targetLoc = this.target.getLocation().add(0.0, 1.0, 0.0);
                            break block0;
                        }
                        location.add(vector);
                        ++n2;
                    }
                    ++n;
                }
                this.cooldown = 5;
            }
        }
        if (this.rand.nextInt(8) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_FOX_AGGRO, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
    }

    @Override
    public void clean() {
        if (this.stand != null) {
            this.stand.remove();
        }
        if (this.tempTarget != null) {
            this.tempTarget.remove();
        }
        if (this.targetBlock != null) {
            this.targetBlock.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private ArmorStand spawnTarget(Location location) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setMarker(true);
        armorStand.setGravity(false);
        armorStand.setSmall(true);
        armorStand.setCollidable(false);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        armorStand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        return armorStand;
    }

    private void spawnHeadStand() {
        this.stand = (ArmorStand)this.entity.getWorld().spawnEntity(this.entity.getLocation().clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        if (this.plugin.mcVersion >= 1.16) {
            this.stand.setInvisible(true);
        } else {
            this.stand.setVisible(false);
        }
        this.stand.setMarker(true);
        this.stand.setGravity(false);
        this.stand.setSmall(true);
        if (this.plugin.mcVersion >= 1.16) {
            this.stand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        if (this.isAlpha) {
            this.stand.getEquipment().setHelmet(CustomHead.INFESTEDDEVOURERALPHA.getHead());
        } else {
            this.stand.getEquipment().setHelmet(CustomHead.INFESTEDDEVOURER.getHead());
        }
        this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
    }

    public void updateTarget() {
        if (this.entity == null || this.entity.isDead() || this.entity.getTarget() == this.tempTarget) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Location location = null;
                double d = 0.0;
                for (Location location2 : blockTargets) {
                    if (!location2.getWorld().equals(InfestedDevourer.this.entity.getWorld()) || location != null && !(location.distanceSquared(InfestedDevourer.this.entity.getLocation()) < d)) continue;
                    location = location2;
                    d = location.distanceSquared(InfestedDevourer.this.entity.getLocation());
                }
                if (location == null || d > 400.0) {
                    return;
                }
                InfestedDevourer.this.locationObject = location;
                InfestedDevourer.this.plugin.getServer().getScheduler().runTask((Plugin)InfestedDevourer.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        (this).InfestedDevourer.this.targetBlock = InfestedDevourer.this.spawnTarget((this).InfestedDevourer.this.locationObject.clone().add(0.5, 0.5, 0.5));
                        InfestedDevourer.this.entity.setTarget((LivingEntity)(this).InfestedDevourer.this.targetBlock);
                    }
                });
            }
        });
    }
}

