/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.infestedcavesentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.events.disasters.InfestedCaves;
import deadlydisasters.handlers.Languages;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Warden;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;

public class InfestedHowler
extends CustomEntity {
    private ArmorStand stand;
    private ArmorStand eyes;
    private Random rand;
    private int cooldown = 5;
    private int shriek;
    private double animation = -0.6;
    private boolean animActive;
    private BlockData data;

    public InfestedHowler(Zombie zombie, Main main, Random random) {
        super((Mob)zombie, main);
        this.rand = random;
        this.entityType = CustomEntityType.INFESTEDHOWLER;
        this.species = this.entityType.species;
        Utils.clearEntityOfItems((LivingEntity)zombie);
        if (main.mcVersion >= 1.16) {
            zombie.setBaby();
        } else {
            zombie.setBaby(true);
        }
        zombie.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        zombie.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        zombie.setCanPickupItems(false);
        zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        zombie.setHealth(this.entityType.getHealth());
        zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.15);
        zombie.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(30.0);
        zombie.setMetadata("dd-infestedhowler", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        zombie.setCustomName(Languages.getString("entities.infestedHowler"));
        zombie.setSilent(true);
        this.stand = (ArmorStand)zombie.getWorld().spawnEntity(zombie.getLocation().clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        if (main.mcVersion >= 1.16) {
            this.stand.setInvisible(true);
        } else {
            this.stand.setVisible(false);
        }
        this.stand.setMarker(true);
        this.stand.setGravity(false);
        if (main.mcVersion >= 1.16) {
            this.stand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        this.stand.getEquipment().setHelmet(CustomHead.INFESTEDHOWLER.getHead());
        this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.spawnEyes();
        this.data = main.mcVersion >= 1.19 ? Material.SCULK.createBlockData() : Material.NETHERRACK.createBlockData();
    }

    @Override
    public void tick() {
        if (this.entity == null || this.stand == null || this.eyes == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20 && this.plugin.mcVersion >= 1.19) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_SCULK_SHRIEKER_BREAK, SoundCategory.HOSTILE, 1.0f, 0.8f);
        }
        this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation(), 1, 0.2, 0.05, 0.2, 0.1, (Object)this.data);
        if (this.shriek > 0) {
            if (this.shriek % 5 == 0 && this.plugin.mcVersion >= 1.19) {
                this.entity.getWorld().spawnParticle(Particle.SHRIEK, this.entity.getEyeLocation(), 1, 0.0, 0.0, 0.0, 0.1, (Object)0);
            }
            --this.shriek;
            if (this.shriek == 0 && this.entity.getTarget() != null && !this.entity.getTarget().isDead()) {
                for (Entity object : this.entity.getNearbyEntities(25.0, 25.0, 25.0)) {
                    if (!(object instanceof Mob) || ((Mob)object).getTarget() != null) continue;
                    ((Mob)object).setTarget(this.entity.getTarget());
                }
                for (InfestedCaves infestedCaves : DeathMessages.infestedcaves) {
                    if (!infestedCaves.getLocation().getWorld().equals(this.entity.getWorld()) || !(infestedCaves.getLocation().distanceSquared(this.entity.getLocation()) <= infestedCaves.getSizeSquared())) continue;
                    infestedCaves.shriekEvent(this.entity.getTarget(), this.rand.nextDouble() * 100.0 < (Double)this.entityType.grabCustomSetting("warden_notify_chance"));
                    infestedCaves.closeRoute(this.entity.getTarget(), 8, Utils.getVectorTowards(this.entity.getLocation(), this.entity.getTarget().getLocation().add(0.0, 1.0, 0.0)));
                    return;
                }
                if (this.plugin.mcVersion >= 1.19 && this.rand.nextInt(4) == 0) {
                    this.spawnWarden(this.entity.getLocation(), this.entity.getTarget());
                }
            }
        }
        if (this.animActive) {
            if (this.animation < -0.1) {
                this.animation += 0.02;
            }
        } else if (this.animation > -0.6) {
            this.animation -= 0.02;
        }
        this.stand.teleport(this.entity.getLocation().subtract(0.0, 1.4, 0.0));
        this.eyes.teleport(this.entity.getLocation().add(0.0, this.animation, 0.0));
        if (this.entity.getTarget() != null) {
            Location location = this.entity.getLocation().setDirection(this.entity.getTarget().getEyeLocation().subtract(0.0, 1.0, 0.0).toVector().subtract(this.entity.getLocation().toVector()));
            this.eyes.setRotation(location.getYaw(), 0.0f);
            this.eyes.setHeadPose(new EulerAngle(Math.toRadians(location.getPitch()), 0.0, 0.0));
        } else {
            this.eyes.setHeadPose(new EulerAngle(Math.toRadians(this.entity.getLocation().getPitch()), 0.0, 0.0));
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        this.stand = (ArmorStand)this.plugin.getServer().getEntity(this.stand.getUniqueId());
        this.eyes = (ArmorStand)this.plugin.getServer().getEntity(this.eyes.getUniqueId());
        if (this.entity == null || this.stand == null || this.eyes == null) {
            this.clean();
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.19) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_SCULK_SHRIEKER_SHRIEK, SoundCategory.HOSTILE, 1.0f, 2.0f);
            }
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.entity.getTarget() != null && this.entity.getLocation().distanceSquared(this.entity.getTarget().getLocation()) <= 36.0 && this.entity.hasLineOfSight((Entity)this.entity.getTarget())) {
            if (!this.animActive) {
                this.eyes.getEquipment().setHelmet(CustomHead.INFESTEDHOWLEREYES.getHead());
                this.animActive = true;
            }
            this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 30, 10, true, false));
            if (this.cooldown <= 0) {
                this.cooldown = 10;
                this.shriek = 40;
                this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 50, 10, true, false));
                if (this.plugin.mcVersion >= 1.19) {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_SCULK_SHRIEKER_SHRIEK, SoundCategory.HOSTILE, 10.0f, 0.5f);
                }
            }
        } else {
            this.animActive = false;
            if (this.animation <= -0.6 && this.eyes != null) {
                this.eyes.getEquipment().setHelmet(new ItemStack(Material.AIR));
            }
        }
    }

    @Override
    public void clean() {
        if (this.stand != null) {
            this.stand.remove();
        }
        if (this.eyes != null) {
            this.eyes.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void spawnEyes() {
        this.eyes = (ArmorStand)this.entity.getWorld().spawnEntity(this.entity.getLocation().clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        if (this.plugin.mcVersion >= 1.16) {
            this.eyes.setInvisible(true);
        } else {
            this.eyes.setVisible(false);
        }
        this.eyes.setMarker(true);
        this.eyes.setGravity(false);
        this.eyes.setSmall(true);
        if (this.plugin.mcVersion >= 1.16) {
            this.eyes.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.eyes.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.eyes.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.eyes.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.eyes.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.eyes.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        this.eyes.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
    }

    private void spawnWarden(Location location, LivingEntity livingEntity) {
        int n = 1;
        while (n < 30) {
            Location location2 = Utils.findSmartYSpawn(location, location.clone().add((double)(this.rand.nextInt(n) - n / 2 + 1), 0.0, (double)(this.rand.nextInt(n) - n / 2 + 1)), 3, 10);
            if (!(location2 == null || location2.getBlock().getRelative(BlockFace.DOWN).isPassable() || location2.getBlock().getRelative(BlockFace.DOWN, 2).isPassable() || location2.getBlock().getRelative(BlockFace.DOWN, 3).isPassable())) {
                LivingEntity livingEntity2 = (LivingEntity)location.getWorld().spawnEntity(location2, EntityType.WARDEN);
                livingEntity2.setInvisible(true);
                Utils.mergeEntityData((Entity)livingEntity2, "{Brain:{memories:{\"minecraft:dig_cooldown\":{ttl:1200L,value:{}},\"minecraft:is_emerging\":{ttl:134L,value:{}}}}}");
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> livingEntity2.setInvisible(false), 10L);
                ((Warden)livingEntity2).setAnger((Entity)livingEntity, 60);
                break;
            }
            ++n;
        }
    }
}

