/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.infestedcavesentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;

public class InfestedSkeleton
extends CustomEntity {
    public InfestedSkeleton(Mob mob, Main main) {
        super(mob, main);
        this.entityType = CustomEntityType.INFESTEDSKELETON;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        Utils.clearEntityOfItems((LivingEntity)mob);
        mob.getEquipment().setHelmet(CustomHead.INFESTEDSKELETON.getHead());
        mob.getEquipment().setHelmetDropChance(0.0f);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        mob.setCanPickupItems(false);
        mob.setMetadata("dd-infestedskeleton", (MetadataValue)main.fixedData);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.infestedSkeleton"));
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.entity.isDead()) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

