/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.infestedcavesentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class InfestedTribesman
extends CustomEntity {
    private boolean archer;
    private boolean noStack;
    private int cooldown = 2;
    private int maxStack = 0;
    private Random rand;

    public InfestedTribesman(Zombie zombie, Main main, Random random) {
        super((Mob)zombie, main);
        this.rand = random;
        this.entityType = CustomEntityType.INFESTEDTRIBESMAN;
        this.species = this.entityType.species;
        zombie.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        Utils.clearEntityOfItems((LivingEntity)zombie);
        ItemStack itemStack = null;
        itemStack = random.nextInt(3) != 0 ? CustomHead.INFESTEDTRIBESMAN1.getHead() : CustomHead.INFESTEDTRIBESMAN2.getHead();
        ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), itemStack};
        int n = random.nextInt(60) + 25;
        int n2 = 0;
        while (n2 < 3) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStackArray[n2].getItemMeta();
            leatherArmorMeta.setColor(Color.fromBGR((int)(n - 20), (int)n, (int)1));
            itemStackArray[n2].setItemMeta((ItemMeta)leatherArmorMeta);
            ++n2;
        }
        zombie.getEquipment().setArmorContents(itemStackArray);
        zombie.getEquipment().setHelmetDropChance(0.0f);
        zombie.getEquipment().setChestplateDropChance(0.0f);
        zombie.getEquipment().setLeggingsDropChance(0.0f);
        zombie.getEquipment().setBootsDropChance(0.0f);
        zombie.setCanPickupItems(false);
        zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        zombie.setHealth(this.entityType.getHealth());
        zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
        zombie.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(25.0);
        if (main.mcVersion >= 1.16) {
            zombie.setBaby();
        } else {
            zombie.setBaby(true);
        }
        zombie.setSilent(true);
        zombie.setMetadata("dd-infestedtribesman", (MetadataValue)main.fixedData);
        if (zombie.getCustomName() == null) {
            zombie.setCustomName(Languages.getString("entities.infestedTribesman"));
        }
        if (random.nextDouble() * 100.0 < (Double)this.entityType.grabCustomSetting("archer_spawn_chance")) {
            zombie.getEquipment().setItemInMainHand(new ItemStack(Material.BOW));
            this.archer = true;
            zombie.setMetadata("dd-infestedtribesmanarcher", (MetadataValue)main.fixedData);
            if (random.nextInt(4) == 0) {
                this.noStack = true;
            } else if (random.nextInt(3) == 0) {
                this.maxStack = 1;
            }
        } else {
            n2 = random.nextInt(3);
            if (n2 == 1) {
                zombie.getEquipment().setItemInMainHand(new ItemStack(Material.WOODEN_SWORD));
            } else if (n2 == 2) {
                zombie.getEquipment().setItemInMainHand(new ItemStack(Material.STONE_SWORD));
            }
        }
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20 && this.plugin.mcVersion >= 1.19) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_SCULK_SENSOR_BREAK, SoundCategory.HOSTILE, 1.0f, 1.5f);
        }
        if (this.archer && this.cooldown <= 0 && this.entity.getTarget() != null && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 81.0 && this.entity.hasLineOfSight((Entity)this.entity.getTarget())) {
            this.cooldown = 3;
            this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 20, 10, true, false));
            Arrow arrow = (Arrow)this.entity.getWorld().spawnEntity(this.entity.getLocation().add(this.entity.getLocation().getDirection().multiply(0.1).setY(0.7)), EntityType.ARROW);
            arrow.addCustomEffect(new PotionEffect(PotionEffectType.POISON, 120, 1), false);
            arrow.setShooter((ProjectileSource)this.entity);
            Location location = this.entity.getTarget().getLocation().add(0.0, this.entity.getTarget().getHeight() / 2.0, 0.0);
            Vector vector = Utils.getVectorTowards(arrow.getLocation(), location);
            vector.setX(vector.getX() / 3.0);
            vector.setZ(vector.getZ() / 3.0);
            vector.setY(location.distance(this.entity.getLocation()) / 13.0 + (location.getY() - this.entity.getLocation().getY()) / 30.0);
            arrow.setVelocity(vector);
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.19) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_VILLAGER_DEATH, SoundCategory.HOSTILE, 1.0f, 2.0f);
            }
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.archer) {
            if (!this.noStack && !this.entity.isInsideVehicle()) {
                for (Entity entity : this.entity.getNearbyEntities(1.0, 1.0, 1.0)) {
                    if (entity.isInsideVehicle() || entity.getPassengers().size() > this.maxStack || !entity.hasMetadata("dd-infestedtribesman") || entity.hasMetadata("dd-infestedtribesmanarcher")) continue;
                    if (entity.getPassengers().isEmpty()) {
                        entity.addPassenger((Entity)this.entity);
                        continue;
                    }
                    if (!((Entity)entity.getPassengers().get(0)).isEmpty()) continue;
                    ((Entity)entity.getPassengers().get(0)).addPassenger((Entity)this.entity);
                }
            }
            if (this.entity.getTarget() != null && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 81.0 && this.entity.hasLineOfSight((Entity)this.entity.getTarget())) {
                this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 30, 10, true, false));
            }
        }
        if (this.rand.nextInt(6) == 0 && this.plugin.mcVersion >= 1.19) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_SCULK_CATALYST_BLOOM, SoundCategory.HOSTILE, 1.0f, this.rand.nextFloat() + 0.5f);
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

