/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.infestedcavesentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.events.disasters.InfestedCaves;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Warden;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class InfestedWorm
extends CustomEntity {
    private Location loc;
    private Location staring;
    private Location particleLoc;
    private Location tpOffset;
    private Block block;
    private Block blockBelow;
    private BlockFace face;
    private ArmorStand[] stands = new ArmorStand[5];
    private boolean isAnimation;
    private boolean swingDirection;
    private boolean noUpdate;
    public boolean shouldRemove;
    private Vector vec;
    private Vector peekVec;
    private Vector staringTowards;
    private float[] rotation = new float[3];
    private int peekingTicks = 80;
    private int frame;
    private int swingTimes;
    private Material blockMaterial;
    private Material headMaterial;
    private Random rand;
    private BoundingBox box;
    private double dX = 0.2;
    private double dY = 0.2;
    private double dZ = 0.2;
    private double swing;
    private double lastSwing = 0.8;
    private double swingVel;
    private double playerLockOffset;
    private Player player;
    private ArmorStand entityStand;
    public static Set<Block> immuneBlocks = new HashSet<Block>();

    public InfestedWorm(Block block, BlockFace blockFace, Main main, Random random) {
        super(null, main);
        this.rand = random;
        this.entityType = CustomEntityType.INFESTEDWORM;
        this.species = this.entityType.species;
        this.entityStand = this.spawnStand(block.getLocation().add(0.5, 0.5, 0.5), new ItemStack(Material.AIR), 0);
        this.entityUUID = this.entityStand.getUniqueId();
        this.entityStand.setSmall(true);
        this.entityStand.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.entityStand.getPersistentDataContainer().set(main.handler.globalKey, PersistentDataType.BYTE, (Object)0);
        this.entityStand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.updateLocation(block, blockFace);
        Location location = this.loc.clone().add(this.vec.clone().multiply(4));
        this.box = new BoundingBox((double)(location.getBlockX() - 4), (double)(location.getBlockY() - 4), (double)(location.getBlockZ() - 4), (double)(location.getBlockX() + 4), (double)(location.getBlockY() + 4), (double)(location.getBlockZ() + 4));
        this.headMaterial = main.mcVersion >= 1.19 ? Material.SCULK_SHRIEKER : Material.STICKY_PISTON;
        this.blockMaterial = block.getType();
        this.stands[0] = this.spawnStand(this.loc.clone().add(100.0, 100.0, 0.0), new ItemStack(this.headMaterial), 0);
        this.stands[0].setHeadPose(new EulerAngle((double)this.rotation[1], 0.0, 0.0));
        this.stands[1] = this.spawnStand(this.loc.clone().add(100.0, 100.0, 0.0), new ItemStack(Material.AIR), 1);
        main.getServer().getScheduler().runTaskLater((Plugin)main, () -> {
            if (this.stands[1] != null && !this.stands[1].isDead()) {
                this.stands[1].getEquipment().setHelmet(CustomHead.INFESTEDWORMBODY.getHead());
            }
        }, 8L);
        this.stands[1].setHeadPose(new EulerAngle((double)this.rotation[1], 0.0, 0.0));
        this.stands[1].setSmall(true);
        this.peekVec = this.face == BlockFace.UP || this.face == BlockFace.DOWN ? new Vector(0, 0, 0) : this.vec.clone().multiply(-0.1);
        this.staring = this.loc.clone().add(this.vec.clone().multiply(5));
        this.staringTowards = this.staring.toVector().subtract(this.loc.toVector());
        block.getWorld().playSound(block.getLocation().add(this.vec), Sound.BLOCK_CHORUS_FLOWER_DEATH, SoundCategory.HOSTILE, 1.0f, 0.75f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        Player player2;
        if (this.shouldRemove) {
            return;
        }
        if (this.player != null && this.player.isDead()) {
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                player2.showPlayer((Plugin)this.plugin, this.player);
            }
            if (this.blockBelow != null) {
                this.player.sendBlockChange(this.blockBelow.getLocation(), this.blockBelow.getBlockData());
            }
            this.player = null;
        }
        if (this.noUpdate) {
            this.particleLoc.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.particleLoc, 3, this.dX, this.dY, this.dZ, 1.0, (Object)this.blockMaterial.createBlockData());
            if (this.frame >= 0) {
                if (!this.swingDirection) {
                    if (this.frame < 9) {
                        if (this.frame % 3 == 0) {
                            int n = this.frame / 3;
                            if (this.frame == 0) {
                                this.stands[n] = this.spawnStand(this.loc.clone().add(100.0, 100.0, 0.0), new ItemStack(this.headMaterial), n);
                                this.stands[n].teleport(this.loc.clone().add(this.vec.clone().multiply(-0.5)).subtract(0.0, 1.8, 0.0).setDirection(this.staringTowards));
                                if (this.plugin.mcVersion >= 1.19) {
                                    this.block.getWorld().playSound(this.stands[0].getLocation(), Sound.ENTITY_WARDEN_EMERGE, SoundCategory.HOSTILE, 0.2f, 2.0f);
                                }
                            } else {
                                this.stands[n] = this.spawnStand(this.loc.clone().add(100.0, 100.0, 0.0), CustomHead.INFESTEDWORMBODY.getHead(), n);
                                this.stands[n].setSmall(true);
                                switch (this.face) {
                                    case UP: {
                                        this.stands[n].teleport(this.tpOffset.clone().add(this.peekVec).add(this.vec.clone().multiply(-0.6)).setDirection(this.staringTowards));
                                        break;
                                    }
                                    case DOWN: {
                                        this.stands[n].teleport(this.tpOffset.clone().add(this.peekVec).add(this.vec.clone().multiply(-0.6)).setDirection(this.staringTowards));
                                        break;
                                    }
                                    default: {
                                        this.stands[n].teleport(this.tpOffset.clone().add(this.peekVec).add(this.vec.clone().multiply(-0.45)).setDirection(this.staringTowards));
                                    }
                                }
                            }
                            this.stands[n].setHeadPose(new EulerAngle((double)this.rotation[1], 0.0, 0.0));
                        }
                        player2 = this.vec.clone().multiply(0.2);
                        ArmorStand[] armorStandArray = this.stands;
                        int n = this.stands.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ArmorStand n7 = armorStandArray[n2];
                            if (n7 != null) {
                                n7.teleport(n7.getLocation().add((Vector)player2));
                            }
                            ++n2;
                        }
                    } else if (this.frame >= 25) {
                        this.frame = 7;
                        this.swingDirection = true;
                        this.player = null;
                    }
                    ++this.frame;
                } else {
                    if (this.frame % 3 == 0) {
                        this.stands[this.frame / 3].remove();
                    }
                    --this.frame;
                    player2 = this.vec.clone().multiply(-0.2);
                    ArmorStand[] armorStandArray = this.stands;
                    int n = this.stands.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ArmorStand armorStand = armorStandArray[n3];
                        if (armorStand != null && !armorStand.isDead()) {
                            armorStand.teleport(armorStand.getLocation().add((Vector)player2));
                        }
                        ++n3;
                    }
                    if (this.frame < 0) {
                        this.clean();
                        this.shouldRemove = true;
                        return;
                    }
                }
            }
            if (this.player != null) {
                if (this.stands[0] == null || this.stands[0].isDead()) {
                    this.player.teleport(this.block.getLocation().add(0.5, -1.0, 0.5));
                } else {
                    player2 = this.stands[0].getLocation();
                    player2.setPitch(this.rotation[2]);
                    player2.add(player2.getDirection().multiply(1.2));
                    player2.setDirection(this.stands[0].getLocation().toVector().subtract(this.player.getLocation().toVector()));
                    this.player.teleport((Location)player2);
                    if (this.blockBelow != null) {
                        this.player.sendBlockChange(this.blockBelow.getLocation(), this.blockBelow.getBlockData());
                        this.blockBelow = null;
                    }
                }
            }
            return;
        }
        if (!this.isAnimation) {
            if (this.peekingTicks > -100) {
                --this.peekingTicks;
                if (this.stands[0] != null && this.stands[1] != null && !this.stands[0].isDead() && !this.stands[1].isDead()) {
                    this.stands[0].teleport(this.loc.clone().add(this.peekVec).subtract(0.0, 1.8, 0.0).setDirection(this.staringTowards));
                    switch (this.face) {
                        case UP: {
                            this.stands[1].teleport(this.loc.clone().add(this.peekVec).subtract(0.0, 0.95, 0.0).add(this.vec.clone().multiply(-0.6)));
                            break;
                        }
                        case DOWN: {
                            this.stands[1].teleport(this.loc.clone().add(this.peekVec).subtract(0.0, 1.2, 0.0).add(this.vec.clone().multiply(-0.6)));
                            break;
                        }
                        default: {
                            this.stands[1].teleport(this.loc.clone().add(this.peekVec).subtract(0.0, 1.1, 0.0).add(this.vec.clone().multiply(-0.45)));
                        }
                    }
                }
                if (this.peekingTicks > 60) {
                    this.peekVec.add(this.vec.clone().multiply(0.055));
                    this.particleLoc.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.particleLoc, 3, this.dX, this.dY, this.dZ, 1.0, (Object)this.blockMaterial.createBlockData());
                } else if (this.peekingTicks > 0) {
                    Iterator iterator;
                    if (this.stands[0] != null && !this.stands[0].isDead() && (iterator = this.loc.getWorld().getNearbyEntities(this.box, entity -> entity instanceof Player).iterator()).hasNext()) {
                        player2 = (Entity)iterator.next();
                        this.staring = player2.getLocation().add(0.0, 0.5, 0.0);
                        this.staringTowards = this.staring.toVector().subtract(this.stands[0].getLocation().toVector());
                        Location location = this.stands[0].getLocation().setDirection(this.staringTowards);
                        this.stands[0].teleport(this.stands[0].getLocation().add(this.staringTowards.clone().multiply(0.1)));
                        this.stands[0].setRotation(location.getYaw(), 0.0f);
                        this.stands[0].setHeadPose(new EulerAngle(Math.toRadians(location.getPitch() + 90.0f), 0.0, 0.0));
                    }
                    if (this.peekingTicks < 20) {
                        this.peekVec.add(this.vec.clone().multiply(-0.058));
                        this.particleLoc.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.particleLoc, 3, this.dX, this.dY, this.dZ, 1.0, (Object)this.blockMaterial.createBlockData());
                    } else if (this.peekingTicks == 20) {
                        this.block.getWorld().playSound(this.block.getLocation().add(this.vec), Sound.BLOCK_CHORUS_FLOWER_DEATH, SoundCategory.HOSTILE, 1.0f, 0.75f);
                    }
                } else if (this.peekingTicks == 0) {
                    if (this.stands[0] != null) {
                        this.stands[0].remove();
                    }
                    if (this.stands[1] != null) {
                        this.stands[1].remove();
                    }
                }
            }
            if (this.block.getType() == this.blockMaterial && this.block.getRelative(this.face).getType() == Material.AIR) {
                int n = 1;
                while (n < 5) {
                    if (this.block.getWorld().getNearbyEntities(this.loc.clone().add(this.vec.clone().multiply(n)), 0.5, 0.5, 0.5, entity -> entity instanceof Player && !entity.isDead() && !Utils.isPlayerImmune((Player)entity)).size() > 0) {
                        this.clean();
                        this.isAnimation = true;
                        this.peekVec = this.face == BlockFace.UP || this.face == BlockFace.DOWN ? new Vector(0, 0, 0) : this.vec.clone().multiply(-0.1);
                        this.staring = this.loc.clone().add(this.vec.clone().multiply(5));
                        this.staringTowards = this.staring.toVector().subtract(this.loc.toVector());
                        immuneBlocks.add(this.block);
                        if (this.plugin.mcVersion >= 1.19) {
                            this.block.getWorld().playSound(this.block.getLocation().add(this.vec), Sound.ENTITY_WARDEN_EMERGE, SoundCategory.HOSTILE, 0.2f, 2.0f);
                            this.block.getWorld().playSound(this.block.getLocation().add(this.vec), Sound.ENTITY_WARDEN_ROAR, SoundCategory.HOSTILE, 1.0f, 2.0f);
                        }
                        return;
                    }
                    ++n;
                }
            }
        } else {
            int n;
            ArmorStand[] armorStandArray;
            this.particleLoc.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.particleLoc, 3, this.dX, this.dY, this.dZ, 1.0, (Object)this.blockMaterial.createBlockData());
            if (this.frame < 15 && this.swingTimes == 0) {
                if (this.frame % 3 == 0) {
                    int n4 = this.frame / 3;
                    if (this.frame == 0) {
                        this.stands[n4] = this.spawnStand(this.loc.clone().add(100.0, 100.0, 0.0), new ItemStack(this.headMaterial), n4);
                        this.stands[n4].teleport(this.loc.clone().add(this.vec.clone().multiply(-0.5)).subtract(0.0, 1.8, 0.0).setDirection(this.staringTowards));
                    } else {
                        this.stands[n4] = this.spawnStand(this.loc.clone().add(100.0, 100.0, 0.0), CustomHead.INFESTEDWORMBODY.getHead(), n4);
                        this.stands[n4].setSmall(true);
                        switch (this.face) {
                            case UP: {
                                this.stands[n4].teleport(this.tpOffset.clone().add(this.peekVec).add(this.vec.clone().multiply(-0.6)).setDirection(this.staringTowards));
                                break;
                            }
                            case DOWN: {
                                this.stands[n4].teleport(this.tpOffset.clone().add(this.peekVec).add(this.vec.clone().multiply(-0.6)).setDirection(this.staringTowards));
                                break;
                            }
                            default: {
                                this.stands[n4].teleport(this.tpOffset.clone().add(this.peekVec).add(this.vec.clone().multiply(-0.45)).setDirection(this.staringTowards));
                            }
                        }
                    }
                    this.stands[n4].setHeadPose(new EulerAngle((double)this.rotation[1], 0.0, 0.0));
                }
                player2 = this.vec.clone().multiply(0.15);
                armorStandArray = this.stands;
                n = this.stands.length;
                int n5 = 0;
                while (n5 < n) {
                    ArmorStand armorStand = armorStandArray[n5];
                    if (armorStand != null) {
                        armorStand.teleport(armorStand.getLocation().add((Vector)player2));
                    }
                    ++n5;
                }
                ++this.frame;
            } else if (this.swingTimes < 5) {
                if (!this.swingDirection) {
                    this.swing += this.swingVel;
                    if (this.swing > this.lastSwing) {
                        this.swingDirection = true;
                        ++this.swingTimes;
                        this.swingVel = -0.2;
                        if (this.swingTimes == 3 && this.plugin.mcVersion >= 1.19) {
                            this.block.getWorld().playSound(this.block.getLocation().add(this.vec), Sound.ENTITY_WARDEN_DIG, SoundCategory.HOSTILE, 0.6f, 1.2f);
                        }
                        if (this.swingTimes >= 5) {
                            switch (this.face) {
                                case UP: {
                                    this.playerLockOffset = 1.5;
                                    break;
                                }
                                case DOWN: {
                                    this.playerLockOffset = 1.8;
                                    break;
                                }
                                default: {
                                    this.playerLockOffset = 1.5;
                                }
                            }
                            if (this.plugin.mcVersion >= 1.19) {
                                this.block.getWorld().playSound(this.block.getLocation().add(this.vec), Sound.ENTITY_WARDEN_ROAR, SoundCategory.HOSTILE, 1.0f, 2.0f);
                            }
                        } else if (this.player != null) {
                            Utils.damageEntity((LivingEntity)this.player, this.entityType.getDamage(), "dd-infestedwormdeath", false);
                            if (this.plugin.mcVersion >= 1.19) {
                                this.block.getWorld().playSound(this.player.getLocation(), Sound.ENTITY_WARDEN_ATTACK_IMPACT, SoundCategory.HOSTILE, 0.5f, 1.2f);
                            }
                        }
                    }
                } else {
                    this.swing -= this.swingVel;
                    if (this.swing < -0.8) {
                        this.swingDirection = false;
                        ++this.swingTimes;
                        if (this.swingTimes >= 4) {
                            this.lastSwing = 0.0;
                            this.frame = 14;
                            this.swingVel = -0.2;
                        }
                        if (this.player != null) {
                            Utils.damageEntity((LivingEntity)this.player, this.entityType.getDamage(), "dd-infestedwormdeath", false);
                            if (this.plugin.mcVersion >= 1.19) {
                                this.block.getWorld().playSound(this.player.getLocation(), Sound.ENTITY_WARDEN_ATTACK_IMPACT, SoundCategory.HOSTILE, 0.5f, 1.2f);
                            }
                        }
                    }
                }
                if (this.swingVel < 0.25) {
                    this.swingVel += 0.05;
                }
                player2 = this.vec.clone().multiply(0.4);
                if (this.face == BlockFace.UP || this.face == BlockFace.DOWN) {
                    void var2_11;
                    boolean bl = true;
                    while (var2_11 < this.stands.length) {
                        if (var2_11 < this.stands.length - 1) {
                            this.stands[var2_11].teleport(this.tpOffset.clone().add(player2.clone().multiply(this.stands.length - var2_11 - 2)).add(this.vec.clone().rotateAroundX(this.swing / 5.0 * (double)(this.stands.length - var2_11))).setDirection(this.stands[var2_11].getLocation().toVector().subtract(this.stands[var2_11 + true].getLocation().toVector())));
                        } else {
                            this.stands[var2_11].teleport(this.tpOffset.clone().add(player2.clone().multiply(this.stands.length - var2_11 - 2)).add(this.vec.clone().rotateAroundX(this.swing / 5.0 * (double)(this.stands.length - var2_11))).setDirection(this.stands[var2_11].getLocation().toVector().subtract(this.loc.toVector())));
                        }
                        ++var2_11;
                    }
                    this.stands[0].teleport(this.loc.clone().subtract(0.0, 1.8, 0.0).add(player2.clone().multiply((double)this.stands.length - 1.5)).add(this.vec.clone().rotateAroundX(this.swing / 5.0 * (double)this.stands.length)).setDirection(this.stands[0].getLocation().toVector().subtract(this.loc.toVector())));
                } else {
                    void var2_13;
                    boolean bl = true;
                    while (var2_13 < this.stands.length) {
                        if (var2_13 < this.stands.length - 1) {
                            this.stands[var2_13].teleport(this.tpOffset.clone().add(player2.clone().multiply(this.stands.length - var2_13 - 2)).add(this.vec.clone().rotateAroundY(this.swing / 5.0 * (double)(this.stands.length - var2_13))).setDirection(this.stands[var2_13].getLocation().toVector().subtract(this.stands[var2_13 + true].getLocation().toVector())));
                        } else {
                            this.stands[var2_13].teleport(this.tpOffset.clone().add(player2.clone().multiply(this.stands.length - var2_13 - 2)).add(this.vec.clone().rotateAroundY(this.swing / 5.0 * (double)(this.stands.length - var2_13))).setDirection(this.stands[var2_13].getLocation().toVector().subtract(this.loc.toVector())));
                        }
                        ++var2_13;
                    }
                    this.stands[0].teleport(this.loc.clone().subtract(0.0, 1.8, 0.0).add(player2.clone().multiply((double)this.stands.length - 1.5)).add(this.vec.clone().rotateAroundY(this.swing)).setDirection(this.stands[0].getLocation().toVector().subtract(this.loc.toVector())));
                }
            } else {
                if (this.frame % 3 == 0) {
                    this.stands[this.frame / 3].remove();
                }
                --this.frame;
                player2 = this.vec.clone().multiply(-0.2);
                armorStandArray = this.stands;
                n = this.stands.length;
                int n6 = 0;
                while (n6 < n) {
                    ArmorStand armorStand = armorStandArray[n6];
                    if (armorStand != null && !armorStand.isDead()) {
                        armorStand.teleport(armorStand.getLocation().add((Vector)player2));
                    }
                    ++n6;
                }
                if (this.frame < 0) {
                    this.clean();
                    this.noUpdate = true;
                    this.swingDirection = false;
                    if (this.player != null) {
                        for (final InfestedCaves infestedCaves : DeathMessages.infestedcaves) {
                            if (infestedCaves.warden == null || !infestedCaves.getLocation().getWorld().equals(this.loc.getWorld()) || !(infestedCaves.getLocation().distanceSquared(this.loc) <= infestedCaves.getSizeSquared())) continue;
                            Location location = infestedCaves.warden.getLocation().add(0.0, 2.0, 0.0);
                            int n7 = -1;
                            while (n7 <= 1) {
                                int n8 = -1;
                                while (n8 <= 1) {
                                    Chunk chunk = location.getWorld().getChunkAt(location.getChunk().getX() + n7, location.getChunk().getZ() + n8);
                                    if (!chunk.isLoaded()) {
                                        chunk.load(true);
                                    }
                                    ++n8;
                                }
                                ++n7;
                            }
                            this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, new Runnable(){

                                @Override
                                public void run() {
                                    Location location = infestedCaves.warden.getLocation().add(0.0, 2.0, 0.0);
                                    ArrayList<BlockFace> arrayList = new ArrayList<BlockFace>(Arrays.asList(BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST));
                                    int n = 0;
                                    while (n < 50) {
                                        Location location2 = location.clone();
                                        Vector vector = new Vector(InfestedWorm.this.rand.nextDouble() * 2.0 - 1.0, InfestedWorm.this.rand.nextDouble() * 1.6 - 0.8, InfestedWorm.this.rand.nextDouble() * 2.0 - 1.0).normalize();
                                        int n2 = 0;
                                        while (n2 < 11) {
                                            location2.add(vector);
                                            Block block = location2.getBlock();
                                            if (!block.isPassable()) {
                                                BlockFace blockFace2;
                                                if (n2 < 7 || block.getType() != infestedCaves.material) break;
                                                int n3 = 0;
                                                for (BlockFace blockFace2 : arrayList) {
                                                    if (block.getRelative(blockFace2).isPassable()) continue;
                                                    ++n3;
                                                }
                                                if (n3 < 3 || n3 > 5) break;
                                                blockFace2 = null;
                                                int n4 = 0;
                                                while (n4 < arrayList.size()) {
                                                    block8: {
                                                        BlockFace blockFace3 = (BlockFace)arrayList.get(InfestedWorm.this.rand.nextInt(arrayList.size()));
                                                        if (block.getRelative(blockFace3).isPassable()) {
                                                            int n5 = 1;
                                                            while (n5 < 4) {
                                                                if (block.getRelative(blockFace3, n5).isPassable() && (n5 != 3 || blockFace3 == BlockFace.UP || blockFace3 == BlockFace.DOWN || block.getRelative(blockFace3, n5).getRelative(BlockFace.DOWN).isPassable())) {
                                                                    ++n5;
                                                                    continue;
                                                                }
                                                                break block8;
                                                            }
                                                            blockFace2 = blockFace3;
                                                            break;
                                                        }
                                                    }
                                                    ++n4;
                                                }
                                                if (blockFace2 == null) break;
                                                InfestedWorm.this.updateLocation(block, blockFace2);
                                                InfestedWorm.this.frame = 0;
                                                return;
                                            }
                                            ++n2;
                                        }
                                        ++n;
                                    }
                                    InfestedWorm.this.shouldRemove = true;
                                }
                            }, 20L);
                            for (Player player3 : this.loc.getWorld().getPlayers()) {
                                if (player3.equals(this.player)) continue;
                                player3.hidePlayer((Plugin)this.plugin, this.player);
                            }
                            immuneBlocks.remove(this.block);
                            this.frame = -1;
                            if (this.block.getRelative(BlockFace.DOWN).isPassable()) {
                                this.blockBelow = this.block.getRelative(BlockFace.DOWN);
                                this.player.sendBlockChange(this.blockBelow.getLocation(), this.blockMaterial.createBlockData());
                            }
                            ((Warden)infestedCaves.warden).increaseAnger((Entity)this.player, 50);
                            return;
                        }
                    }
                    immuneBlocks.remove(this.block);
                    this.shouldRemove = true;
                }
            }
            if (this.stands[0] != null) {
                if (this.player == null) {
                    Iterator iterator = this.block.getWorld().getNearbyEntities(this.stands[0].getEyeLocation(), 0.75, 1.0, 0.75, entity -> entity instanceof Player && !entity.isDead() && !Utils.isPlayerImmune((Player)entity)).iterator();
                    while (iterator.hasNext()) {
                        this.player = player2 = (Entity)iterator.next();
                    }
                } else {
                    if (this.player.isSwimming()) {
                        this.player.setSwimming(false);
                    }
                    player2 = this.stands[0].getLocation();
                    player2.setPitch(this.rotation[2]);
                    player2.add(player2.getDirection().multiply(this.playerLockOffset));
                    player2.setDirection(this.stands[0].getLocation().toVector().subtract(this.player.getLocation().toVector()));
                    this.player.teleport((Location)player2);
                }
            }
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        if (this.shouldRemove || !this.loc.getChunk().isLoaded()) {
            iterator.remove();
            this.clean();
            return;
        }
        this.refreshReferences((Entity[])this.stands);
        if (!this.isAnimation) {
            if (this.block.getType() != this.blockMaterial || this.block.getRelative(this.face).getType() != Material.AIR) {
                iterator.remove();
                this.clean();
                return;
            }
            if (this.peekingTicks <= -100 && this.rand.nextInt(3) == 0) {
                this.peekingTicks = 80;
                this.stands[0] = this.spawnStand(this.loc.clone().add(100.0, 100.0, 0.0), new ItemStack(this.headMaterial), 0);
                this.stands[0].setHeadPose(new EulerAngle((double)this.rotation[1], 0.0, 0.0));
                this.stands[1] = this.spawnStand(this.loc.clone().add(100.0, 100.0, 0.0), new ItemStack(Material.AIR), 1);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.stands[1].getEquipment().setHelmet(CustomHead.INFESTEDWORMBODY.getHead()), 8L);
                this.stands[1].setHeadPose(new EulerAngle((double)this.rotation[1], 0.0, 0.0));
                this.stands[1].setSmall(true);
                this.peekVec = this.face == BlockFace.UP || this.face == BlockFace.DOWN ? new Vector(0, 0, 0) : this.vec.clone().multiply(-0.1);
                this.staring = this.loc.clone().add(this.vec.clone().multiply(5));
                this.staringTowards = this.staring.toVector().subtract(this.loc.toVector());
                this.block.getWorld().playSound(this.block.getLocation().add(this.vec), Sound.BLOCK_CHORUS_FLOWER_DEATH, SoundCategory.HOSTILE, 1.0f, 0.75f);
            }
        }
    }

    @Override
    public void clean() {
        if (this.entityStand != null) {
            this.entityStand.remove();
        }
        ArmorStand[] armorStandArray = this.stands;
        int n = this.stands.length;
        int n2 = 0;
        while (n2 < n) {
            ArmorStand armorStand = armorStandArray[n2];
            if (armorStand != null) {
                armorStand.remove();
            }
            ++n2;
        }
        if (this.player != null) {
            for (ArmorStand armorStand : Bukkit.getOnlinePlayers()) {
                armorStand.showPlayer((Plugin)this.plugin, this.player);
            }
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private ArmorStand spawnStand(Location location, ItemStack itemStack, int n) {
        if (this.stands[n] != null) {
            this.stands[n].remove();
        }
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location.clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setMarker(true);
        armorStand.setGravity(false);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> armorStand.getEquipment().setHelmet(itemStack), 4L);
        armorStand.teleport(location);
        armorStand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        return armorStand;
    }

    private void updateLocation(Block block, BlockFace blockFace) {
        this.block = block;
        this.face = blockFace;
        this.particleLoc = block.getRelative(this.face).getLocation();
        switch (blockFace) {
            default: {
                this.vec = new Vector(0, 1, 0);
                this.rotation[0] = 0.0f;
                this.rotation[1] = (float)Math.toRadians(0.0);
                this.rotation[2] = -90.0f;
                this.loc = block.getLocation().add(0.5, 0.7, 0.5);
                this.dY = 0.05;
                this.particleLoc.add(0.5, 0.0, 0.5);
                this.tpOffset = this.loc.clone().subtract(0.0, 0.95, 0.0);
                this.playerLockOffset = 1.0;
                this.peekVec = new Vector(0, 0, 0);
                break;
            }
            case DOWN: {
                this.vec = new Vector(0, -1, 0);
                this.rotation[0] = 0.0f;
                this.rotation[1] = (float)Math.toRadians(180.0);
                this.rotation[2] = 90.0f;
                this.loc = block.getLocation().add(0.5, 1.0, 0.5);
                this.dY = 0.05;
                this.particleLoc.add(0.5, 1.0, 0.5);
                this.tpOffset = this.loc.clone().subtract(0.0, 1.2, 0.0);
                this.playerLockOffset = 1.5;
                this.peekVec = new Vector(0, 0, 0);
                break;
            }
            case NORTH: {
                this.vec = new Vector(0, 0, -1);
                this.rotation[0] = 180.0f;
                this.rotation[1] = (float)Math.toRadians(90.0);
                this.rotation[2] = 0.0f;
                this.loc = block.getLocation().add(0.5, 0.9, 0.5);
                this.dZ = 0.05;
                this.particleLoc.add(0.5, 0.5, 1.0);
                this.tpOffset = this.loc.clone().subtract(0.0, 1.1, 0.0);
                this.playerLockOffset = 1.15;
                this.peekVec = this.vec.clone().multiply(-0.1);
                break;
            }
            case EAST: {
                this.vec = new Vector(1, 0, 0);
                this.rotation[0] = -90.0f;
                this.rotation[1] = (float)Math.toRadians(90.0);
                this.rotation[2] = 0.0f;
                this.loc = block.getLocation().add(0.5, 0.9, 0.5);
                this.dX = 0.05;
                this.particleLoc.add(0.0, 0.5, 0.5);
                this.tpOffset = this.loc.clone().subtract(0.0, 1.1, 0.0);
                this.playerLockOffset = 1.15;
                this.peekVec = this.vec.clone().multiply(-0.1);
                break;
            }
            case SOUTH: {
                this.vec = new Vector(0, 0, 1);
                this.rotation[0] = 0.0f;
                this.rotation[1] = (float)Math.toRadians(90.0);
                this.rotation[2] = 0.0f;
                this.loc = block.getLocation().add(0.5, 0.9, 0.5);
                this.dZ = 0.05;
                this.particleLoc.add(0.5, 0.5, 0.0);
                this.tpOffset = this.loc.clone().subtract(0.0, 1.1, 0.0);
                this.playerLockOffset = 1.15;
                this.peekVec = this.vec.clone().multiply(-0.1);
                break;
            }
            case WEST: {
                this.vec = new Vector(-1, 0, 0);
                this.rotation[0] = 90.0f;
                this.rotation[1] = (float)Math.toRadians(90.0);
                this.rotation[2] = 0.0f;
                this.loc = block.getLocation().add(0.5, 0.9, 0.5);
                this.dX = 0.05;
                this.particleLoc.add(1.0, 0.5, 0.5);
                this.tpOffset = this.loc.clone().subtract(0.0, 1.1, 0.0);
                this.playerLockOffset = 1.15;
                this.peekVec = this.vec.clone().multiply(-0.1);
            }
        }
        this.loc.setYaw(this.rotation[0]);
    }
}

