/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.infestedcavesentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class InfestedZombie
extends CustomEntity {
    private BlockData data;
    private double height;

    public InfestedZombie(Mob mob, Main main) {
        super(mob, main);
        this.entityType = CustomEntityType.INFESTEDZOMBIE;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        Utils.clearEntityOfItems((LivingEntity)mob);
        mob.getEquipment().setHelmet(CustomHead.INFESTEDZOMBIE.getHead());
        mob.getEquipment().setHelmetDropChance(0.0f);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        mob.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        mob.setCanPickupItems(false);
        mob.setMetadata("dd-infestedzombie", (MetadataValue)main.fixedData);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.infestedZombie"));
        }
        this.data = main.mcVersion >= 1.19 ? Material.SCULK.createBlockData() : Material.NETHERRACK.createBlockData();
        this.height = mob.getHeight() / 4.0;
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, this.entity.getLocation().add(0.0, this.height * 1.5, 0.0), 10, 0.3, this.height, 0.3, 0.1, (Object)this.data);
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.entity.isDead()) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

