/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.purgeentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import java.util.Iterator;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Mob;
import org.bukkit.persistence.PersistentDataType;

public class PrimedCreeper
extends CustomEntity {
    public PrimedCreeper(Mob mob, Main main) {
        super(mob, main);
        this.entityType = CustomEntityType.PRIMEDCREEPER;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        ((Creeper)this.entity).setMaxFuseTicks(1);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.setRemoveWhenFarAway(true);
    }

    @Override
    public void tick() {
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Creeper)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.entity.getTarget() != null && this.entity.getWorld().equals(this.entity.getTarget().getWorld()) && this.entity.getTarget().getLocation().distanceSquared(this.entity.getEyeLocation()) <= 16.0) {
            if (this.plugin.mcVersion >= 1.16) {
                ((Creeper)this.entity).explode();
            }
            iterator.remove();
            return;
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

