/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.purgeentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TunnellerZombie
extends CustomEntity {
    private LivingEntity target;
    private Queue<Block> blocks = new ArrayDeque<Block>();

    public TunnellerZombie(Zombie zombie, LivingEntity livingEntity, Main main) {
        super((Mob)zombie, main);
        this.entityType = CustomEntityType.TUNNELLER;
        this.species = this.entityType.species;
        zombie.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        zombie.getEquipment().setItemInMainHand(new ItemStack(Material.DIAMOND_PICKAXE));
        zombie.getEquipment().setItemInMainHandDropChance(0.03f);
        zombie.getEquipment().setItemInOffHand(new ItemStack(Material.COBBLESTONE));
        zombie.getEquipment().setHelmet(new ItemStack(Material.IRON_HELMET));
        zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        zombie.setHealth(this.entityType.getHealth());
        zombie.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
        zombie.setCanPickupItems(false);
        if (main.mcVersion >= 1.16) {
            if (!zombie.isAdult()) {
                zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.2);
            }
        } else if (zombie.isBaby()) {
            zombie.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.2);
        }
        if (zombie.getCustomName() == null) {
            zombie.setCustomName(Languages.getString("entities.tunnellerZombie"));
        }
    }

    @Override
    public void tick() {
        Location location;
        if (this.entity == null) {
            return;
        }
        if (this.entity.getVelocity().getY() < -0.5 && this.entity.getLocation().clone().subtract(0.0, 3.0, 0.0).getBlock().getType().isSolid() && this.entity.getLocation().clone().subtract(0.0, 2.0, 0.0).getBlock().isPassable() && !Utils.passStrengthTest((location = this.entity.getLocation().clone().subtract(0.0, 2.0, 0.0)).getBlock().getType()) && !Utils.isZoneProtected(location)) {
            location.getBlock().setType(Material.WATER);
            this.entity.getEquipment().setItemInMainHand(new ItemStack(Material.WATER_BUCKET));
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    location.getBlock().setType(Material.AIR);
                    TunnellerZombie.this.entity.getEquipment().setItemInMainHand(new ItemStack(Material.DIAMOND_PICKAXE));
                }
            }, 9L);
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.entity.isDead()) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            new RepeatingTask(this.plugin, 100, 20){

                @Override
                public void run() {
                    if (TunnellerZombie.this.blocks.isEmpty()) {
                        this.cancel();
                    } else {
                        Block block = TunnellerZombie.this.blocks.poll();
                        if (block.getType() == Material.COBBLESTONE) {
                            block.getWorld().spawnParticle(Particle.BLOCK_CRACK, block.getLocation().clone().add(0.5, 0.5, 0.5), 7, 0.0, 0.0, 0.0, 0.01, (Object)block.getBlockData());
                            block.breakNaturally(new ItemStack(Material.AIR));
                        }
                    }
                }
            };
            return;
        }
        if (this.target != null && (!this.entity.getWorld().equals(this.target.getWorld()) || this.target instanceof Player && Utils.isPlayerImmune((Player)this.target))) {
            this.target = null;
            return;
        }
        if (this.entity.getTarget() == null) {
            if (this.target == null) {
                return;
            }
            this.entity.setTarget(this.target);
        } else if (this.target == null) {
            this.target = this.entity.getTarget();
        }
        if (this.entity.getVelocity().getX() < 0.08 && this.entity.getVelocity().getZ() < 0.08) {
            Location location = this.entity.getLocation().clone().add(0.0, 2.0, 0.0);
            if (!(location.getBlock().isPassable() || Utils.passStrengthTest(location.getBlock().getType()) || Utils.isZoneProtected(location))) {
                location.getBlock().breakNaturally();
                if (this.plugin.mcVersion >= 1.16) {
                    this.entity.swingMainHand();
                }
                return;
            }
            Location location2 = this.entity.getLocation();
            Location location3 = this.target.getLocation().clone();
            if (!location2.getWorld().equals(location3.getWorld())) {
                return;
            }
            location3.setY(location2.getY());
            if (this.target.getLocation().getBlockY() - 1 > location2.getBlockY() && this.entity.getVelocity().getY() > -0.5 && (location2.distanceSquared(location3) <= 4.0 || this.entity.getVelocity().getX() <= 0.0 && this.entity.getVelocity().getZ() <= 0.0)) {
                if (!Utils.passStrengthTest(location.getBlock().getType()) && !Utils.isZoneProtected(location)) {
                    this.entity.setVelocity(new Vector(0.0, 0.45, 0.0));
                    location2.getBlock().setType(Material.COBBLESTONE);
                    this.entity.getWorld().playSound(location, Sound.BLOCK_STONE_PLACE, 1.0f, 1.0f);
                    if (this.plugin.mcVersion >= 1.16) {
                        this.entity.swingOffHand();
                    }
                    this.blocks.add(location2.getBlock());
                    return;
                }
            } else if (this.entity.getVelocity().getX() <= 0.0 && this.entity.getVelocity().getZ() <= 0.0) {
                if (this.target.getLocation().getBlockY() < location2.getBlockY()) {
                    Location location4 = location2.clone().subtract(0.0, 1.0, 0.0);
                    if (!Utils.passStrengthTest(location4.getBlock().getType()) && !Utils.isZoneProtected(location4)) {
                        location4.getBlock().breakNaturally();
                        if (this.plugin.mcVersion >= 1.16) {
                            this.entity.swingMainHand();
                        }
                        return;
                    }
                } else {
                    location = this.entity.getLocation().clone().add(new Vector(location3.getX() - location2.getX(), location3.getY() - location2.getY(), location3.getZ() - location2.getZ()).normalize().multiply(1.25));
                    location.setY(location.getY() - 1.0);
                    if (location.getBlock().isPassable() && !Utils.passStrengthTest(location.getBlock().getType()) && !Utils.isZoneProtected(location)) {
                        location.getBlock().setType(Material.COBBLESTONE);
                        this.entity.getWorld().playSound(location, Sound.BLOCK_STONE_PLACE, 1.0f, 1.0f);
                        if (this.plugin.mcVersion >= 1.16) {
                            this.entity.swingOffHand();
                        }
                        this.blocks.add(location.getBlock());
                        return;
                    }
                }
            }
            location3 = this.target.getLocation();
            location = this.entity.getLocation().clone().add(new Vector(location3.getX() - location2.getX(), location3.getY() - location2.getY(), location3.getZ() - location2.getZ()).normalize().multiply(1.25));
            if (location.getBlock().equals(location2.getBlock()) && !Utils.passStrengthTest(location2.getBlock().getType()) && !Utils.isZoneProtected(location2)) {
                location.getBlock().breakNaturally();
                if (this.plugin.mcVersion >= 1.16) {
                    this.entity.swingMainHand();
                }
                return;
            }
            if (location3.getBlockY() - 1 > this.entity.getLocation().getBlockY()) {
                location.setY(this.entity.getLocation().getY() + 3.0);
            } else {
                location.setY(this.entity.getLocation().getY() + 2.0);
            }
            int n = 0;
            while (n < 3) {
                if (!(location.getBlock().isPassable() || Utils.passStrengthTest(location.getBlock().getType()) || Utils.isZoneProtected(location))) {
                    location.getBlock().breakNaturally();
                    if (!(this.plugin.mcVersion >= 1.16)) break;
                    this.entity.swingMainHand();
                    break;
                }
                location.setY(location.getY() - 1.0);
                ++n;
            }
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

