/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.sandstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AncientMummy
extends CustomEntity {
    private Random rand;
    private BlockData bd = Material.OBSIDIAN.createBlockData();
    private int cooldown;

    public AncientMummy(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.ANCIENTMUMMY;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.rand = random;
        mob.setMetadata("dd-ancientmummy", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.getEquipment().setHelmet(CustomHead.MUMMY.getHead());
        mob.getEquipment().setHelmetDropChance(0.0f);
        mob.setCanPickupItems(false);
        mob.setSilent(true);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.ancientMummy"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_HUSK_HURT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        this.entity.getWorld().spawnParticle(Particle.FALLING_DUST, this.entity.getLocation().clone().add(0.0, 1.6, 0.0), 4, 0.4, 0.5, 0.4, 1.0, (Object)this.bd);
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.getWorld().spawnParticle(Particle.SOUL, this.entity.getLocation().add(0.0, 1.5, 0.0), 5, 0.3, 0.3, 0.3, 1.0E-4);
            }
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_HUSK_DEATH, SoundCategory.HOSTILE, 1.0f, 0.6f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.rand.nextInt(5) == 0 && Tag.WOODEN_DOORS.getValues().contains(this.entity.getLocation().add(this.entity.getLocation().getDirection()).getBlock().getType()) && !Utils.isZoneProtected(this.entity.getLocation().add(this.entity.getLocation().getDirection()))) {
            this.entity.getLocation().add(this.entity.getLocation().getDirection()).getBlock().breakNaturally();
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_BREAK_WOODEN_DOOR, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        if (this.rand.nextInt(10) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_HUSK_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.7f);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            if (this.cooldown == 9) {
                this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.25);
            }
            return;
        }
        if (this.entity.getTarget() == null || this.entity.getLocation().distanceSquared(this.entity.getTarget().getLocation()) > 100.0) {
            return;
        }
        this.cooldown = 12;
        this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.45);
        this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMAN_SCREAM, SoundCategory.HOSTILE, 1.5f, 0.5f);
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

