/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.sandstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Skeleton;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class AncientSkeleton
extends CustomEntity {
    private int cooldown;
    private int timer;
    private int spellLife;
    private Skeleton[] mobs = new Skeleton[3];
    private LivingEntity lockedTarget;
    private Location spell;
    private Vector motion;
    private BlockData bd = Material.SAND.createBlockData();
    private Random rand;

    public AncientSkeleton(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.ANCIENTSKELETON;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.rand = random;
        mob.setMetadata("dd-ancientskeleton", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.getEquipment().setHelmet(CustomHead.ANCIENTSKELETON.getHead());
        mob.getEquipment().setHelmetDropChance(0.0f);
        mob.setCanPickupItems(false);
        mob.setSilent(true);
        mob.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.ancientSkeleton"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_SKELETON_HURT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        this.entity.getWorld().spawnParticle(Particle.FLAME, this.entity.getLocation().clone().add(0.0, 1.3, 0.0), 1, 0.25, 0.45, 0.25, 0.01);
        if (this.timer > 0) {
            Skeleton[] skeletonArray = this.mobs;
            int n = this.mobs.length;
            int n2 = 0;
            while (n2 < n) {
                Skeleton skeleton = skeletonArray[n2];
                skeleton.teleport(skeleton.getLocation().clone().add(0.0, 0.035, 0.0));
                skeleton.getWorld().spawnParticle(Particle.BLOCK_DUST, skeleton.getLocation(), 5, 0.5, 0.5, 0.5, 0.01, (Object)this.bd);
                ++n2;
            }
        }
        if (this.spellLife > 0) {
            --this.spellLife;
            this.spell.add(this.motion);
            this.spell.getWorld().spawnParticle(Particle.FLAME, this.spell, 10, 1.0, 1.0, 1.0, 0.05);
            this.spell.getWorld().spawnParticle(Particle.BLOCK_DUST, this.spell, 7, 1.0, 1.0, 1.0, 0.1, (Object)this.bd);
            for (Skeleton skeleton : this.spell.getWorld().getNearbyEntities(this.spell, 1.5, 1.5, 1.5)) {
                if (!(skeleton instanceof LivingEntity)) continue;
                skeleton.setFireTicks(80);
                skeleton.setVelocity(this.motion.clone().multiply(0.5));
            }
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        Skeleton skeleton;
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            this.entity.getWorld().spawnParticle(Particle.FLAME, this.entity.getLocation().add(0.0, 1.0, 0.0), 15, 0.3, 0.5, 0.3, 0.2);
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_SKELETON_DEATH, SoundCategory.HOSTILE, 1.0f, 0.5f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        if (this.rand.nextInt(8) == 0) {
            if (this.rand.nextInt(2) == 0) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_SKELETON_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.5f);
            } else {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_SKELETON_STEP, SoundCategory.HOSTILE, 1.0f, 0.5f);
            }
        }
        if (this.timer > 0) {
            int n;
            --this.timer;
            if (this.timer == 2) {
                Skeleton[] skeletonArray = this.mobs;
                int n2 = this.mobs.length;
                n = 0;
                while (n < n2) {
                    skeleton = skeletonArray[n];
                    skeleton.setInvulnerable(false);
                    ++n;
                }
            } else if (this.timer == 0) {
                Skeleton[] skeletonArray = this.mobs;
                int n3 = this.mobs.length;
                n = 0;
                while (n < n3) {
                    skeleton = skeletonArray[n];
                    skeleton.setAI(true);
                    skeleton.setGravity(true);
                    if (this.lockedTarget != null) {
                        skeleton.setTarget(this.lockedTarget);
                    }
                    ++n;
                }
                this.entity.setAI(true);
                if (this.lockedTarget != null) {
                    this.entity.setTarget(this.lockedTarget);
                }
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.entity.getTarget() == null || this.entity.getLocation().distanceSquared(this.entity.getTarget().getLocation()) > 49.0) {
            return;
        }
        if (this.entity.isOnGround() && (this.mobs[0] == null || this.mobs[0].isDead() && this.mobs[1].isDead() && this.mobs[2].isDead())) {
            this.timer = 3;
            this.cooldown = 17;
            this.lockedTarget = this.entity.getTarget();
            this.entity.setAI(false);
            this.entity.setVelocity(new Vector(0, 0, 0));
            skeleton = this.entity.getLocation().clone().add(this.entity.getLocation().getDirection().multiply(2).setY(this.entity.getLocation().getBlockY()));
            Vector vector = this.entity.getLocation().getDirection().setY(0);
            this.mobs[0] = this.attemptSpawn((Location)skeleton);
            this.mobs[1] = this.attemptSpawn(this.entity.getLocation().clone().add(vector.clone().setX(-vector.getZ()).setZ(vector.getX()).multiply(1.5)));
            this.mobs[2] = this.attemptSpawn(this.entity.getLocation().clone().add(vector.clone().setX(vector.getZ()).setZ(-vector.getX()).multiply(1.5)));
            if (this.plugin.mcVersion >= 1.17) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_SKELETON_CONVERTED_TO_STRAY, SoundCategory.HOSTILE, 1.0f, 0.5f);
            }
        } else {
            this.cooldown = 10;
            this.spellLife = 20;
            this.motion = this.entity.getLocation().getDirection().clone().multiply(0.7);
            this.spell = this.entity.getEyeLocation().clone().add(this.motion.clone().multiply(4));
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.swingMainHand();
            }
            this.entity.getWorld().playSound(this.spell, Sound.ITEM_FIRECHARGE_USE, SoundCategory.HOSTILE, 1.0f, 0.6f);
        }
    }

    @Override
    public void clean() {
        Skeleton[] skeletonArray = this.mobs;
        int n = this.mobs.length;
        int n2 = 0;
        while (n2 < n) {
            Skeleton skeleton = skeletonArray[n2];
            if (skeleton != null) {
                skeleton.remove();
            }
            ++n2;
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
        this.clean();
    }

    private Skeleton spawnSkeleton(Location location) {
        Skeleton skeleton = (Skeleton)location.getWorld().spawnEntity(location, EntityType.SKELETON);
        skeleton.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
        skeleton.setAI(false);
        skeleton.setInvulnerable(true);
        skeleton.setGravity(false);
        skeleton.setMetadata("dd-unburnable", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
        skeleton.setMetadata("dd-ancientminion", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
        Location location2 = this.entity.getLocation();
        skeleton.setRotation(location2.getYaw(), location2.getPitch());
        return skeleton;
    }

    private Skeleton attemptSpawn(Location location) {
        Block block = location.getBlock();
        block = block.isPassable() ? Utils.getBlockBelow(location) : Utils.getBlockAbove(location);
        return this.spawnSkeleton(block.getRelative(BlockFace.DOWN).getLocation());
    }
}

