/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.soulstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;

public class LostSoul
extends CustomEntity {
    private Random rand;
    private ArmorStand stand;
    private UUID standUUID;

    public LostSoul(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.LOSTSOUL;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.rand = random;
        mob.setMetadata("dd-lostsoul", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        this.stand = (ArmorStand)mob.getWorld().spawnEntity(mob.getLocation().clone().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND);
        if (main.mcVersion >= 1.16) {
            this.stand.setInvisible(true);
        } else {
            this.stand.setVisible(false);
        }
        this.stand.setMarker(true);
        this.stand.setGravity(false);
        this.stand.setSmall(true);
        if (main.mcVersion >= 1.16) {
            this.stand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            this.stand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        this.standUUID = this.stand.getUniqueId();
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.setSilent(true);
        int n = random.nextInt(4);
        if (n == 0) {
            this.stand.getEquipment().setHelmet(CustomHead.SOUL1.getHead());
        } else if (n == 1) {
            this.stand.getEquipment().setHelmet(CustomHead.SOUL2.getHead());
        } else if (n == 2) {
            this.stand.getEquipment().setHelmet(CustomHead.SOUL3.getHead());
        } else {
            this.stand.getEquipment().setHelmet(CustomHead.SOUL4.getHead());
        }
        mob.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        mob.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.lostSoul"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null || this.stand == null) {
            return;
        }
        this.stand.teleport(this.entity.getLocation().subtract(0.0, 0.3, 0.0));
        this.stand.setHeadPose(new EulerAngle(Math.toRadians(this.entity.getLocation().getPitch()), 0.0, 0.0));
        if (this.plugin.mcVersion >= 1.16) {
            this.entity.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, this.entity.getLocation(), 1, 0.2, 0.2, 0.2, 0.05);
        }
        this.entity.getWorld().spawnParticle(Particle.SMOKE_NORMAL, this.entity.getLocation().clone().add(0.0, 0.4, 0.0), 2, 0.025, 0.1, 0.025, 0.015);
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null || this.stand == null) {
            this.clean();
            iterator.remove();
            return;
        }
        this.stand = (ArmorStand)this.plugin.getServer().getEntity(this.standUUID);
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.getWorld().spawnParticle(Particle.SOUL, this.entity.getLocation().add(0.0, 0.5, 0.0), 15, 0.3, 0.5, 0.3, 0.03);
            }
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_VEX_DEATH, SoundCategory.HOSTILE, 1.0f, 0.7f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.clean();
            iterator.remove();
            return;
        }
        if (this.rand.nextInt(8) == 0) {
            if (this.rand.nextInt(2) == 0) {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_VEX_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.5f);
            } else {
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_VEX_CHARGE, SoundCategory.HOSTILE, 1.0f, 0.5f);
            }
        }
    }

    @Override
    public void clean() {
        if (this.stand != null) {
            this.stand.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

