/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.DisasterEvent;
import deadlydisasters.events.disasters.ExtremeWinds;
import deadlydisasters.handlers.DifficultyLevel;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.BlockRegenHandler;
import deadlydisasters.utils.ChannelDataHolder;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class WeatherDisaster
extends DisasterEvent {
    public static Queue<World> currentWorlds = new ArrayDeque<World>();
    protected int delay;
    protected int time;
    public Main plugin = Main.getInstance();
    public double volume;
    public boolean RegionWeather;

    public WeatherDisaster(int n) {
        this.level = n;
        if (this.level > 5 && !(this instanceof ExtremeWinds)) {
            this.level = 5;
        }
        this.configFile = this.plugin.getConfig();
        this.dropItems = this.configFile.getBoolean("regeneration.drop_container_items");
    }

    public WeatherDisaster(int n, World world) {
        this.level = n;
        if (this.level > 5 && !(this instanceof ExtremeWinds)) {
            this.level = 5;
        }
        this.configFile = WorldObject.findWorldObject((World)world).configFile;
        this.dropItems = this.configFile.getBoolean("regeneration.drop_container_items");
    }

    public void triggerRegen(boolean bl) {
        RepeatingTask[] repeatingTaskArray;
        if (WorldObject.findWorldObject((World)this.world).difficulty != DifficultyLevel.CUSTOM || (Integer)WorldObject.findWorldObject((World)this.world).settings.get("regenDelay") < 0) {
            return;
        }
        this.UUIDToFalling.forEach((uUID, block) -> {
            if (Bukkit.getEntity((UUID)uUID) != null) {
                Bukkit.getEntity((UUID)uUID).remove();
            }
        });
        regeneratingDisasters.add(this);
        final WeatherDisaster weatherDisaster = this;
        if (bl) {
            this.reverseList();
        }
        this.damagedBlocks.putAll(this.physicBlocks);
        final double d = this.type.getDefaultRegenTickRate() * this.configFile.getDouble(String.valueOf(this.type.name().toLowerCase()) + ".regen_rate");
        final double[] dArray = new double[]{0.0};
        final HashMap hashMap = new HashMap();
        repeatingTaskArray = new RepeatingTask[]{new RepeatingTask(this.plugin, (Integer)WorldObject.findWorldObject((World)this.world).settings.get("regenDelay") * 20, 1){

            @Override
            public void run() {
                dArray[0] = dArray[0] + d;
                while (dArray[0] >= 1.0) {
                    dArray[0] = dArray[0] - 1.0;
                    if (WeatherDisaster.this.damagedBlocks.isEmpty()) {
                        this.cancel();
                        regeneratingTasks.remove(repeatingTaskArray[0]);
                        regeneratingDisasters.remove(weatherDisaster);
                        BlockRegenHandler.gravityHold.removeAll(WeatherDisaster.this.gravityHoldBlocks);
                        break;
                    }
                    try {
                        Map.Entry entry = WeatherDisaster.this.damagedBlocks.entrySet().iterator().next();
                        Block block = (Block)entry.getKey();
                        Iterator iterator = WeatherDisaster.this.blockToBlock.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry2 = iterator.next();
                            if (((Block)entry2.getKey()).equals(block)) {
                                Block block2 = (Block)entry2.getValue();
                                if (block.equals(block2)) {
                                    iterator.remove();
                                    break;
                                }
                                if (block2.getState() instanceof InventoryHolder) {
                                    ItemStack[] itemStackArray = ((InventoryHolder)block2.getState()).getInventory().getContents();
                                    WeatherDisaster.this.plugin.getServer().getScheduler().runTaskLater((Plugin)WeatherDisaster.this.plugin, () -> ((InventoryHolder)block.getState()).getInventory().setContents(itemStackArray), 7L);
                                }
                                block2.setType(Material.AIR);
                                iterator.remove();
                                while (iterator.hasNext()) {
                                    entry2 = iterator.next();
                                    if (!((Block)entry2.getValue()).equals(block)) continue;
                                    if (block.getState() instanceof InventoryHolder) {
                                        hashMap.put((Block)entry2.getKey(), ((InventoryHolder)block.getState()).getInventory().getContents());
                                    }
                                    iterator.remove();
                                }
                                break;
                            }
                            if (!((Block)entry2.getValue()).equals(block)) continue;
                            if (block.getState() instanceof InventoryHolder) {
                                hashMap.put((Block)entry2.getKey(), ((InventoryHolder)block.getState()).getInventory().getContents());
                            }
                            iterator.remove();
                        }
                        if (Utils.isMaterialGravity(((BlockState)entry.getValue()).getType())) {
                            WeatherDisaster.this.gravityHoldBlocks.add(block);
                            BlockRegenHandler.gravityHold.add(block);
                        }
                        ((BlockState)entry.getValue()).update(true);
                        if (hashMap.containsKey(block)) {
                            WeatherDisaster.this.plugin.getServer().getScheduler().runTaskLater((Plugin)WeatherDisaster.this.plugin, () -> ((InventoryHolder)block.getState()).getInventory().setContents((ItemStack[])hashMap.get(block)), 7L);
                        }
                        WeatherDisaster.this.damagedBlocks.remove(block);
                        disasterBlocks.remove(block);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Utils.sendDebugMessage();
                    }
                }
            }
        }};
        regeneratingTasks.put(repeatingTaskArray[0], weatherDisaster);
    }

    public void awardPlayersInSet(Set<ChannelDataHolder> set, int n, String string) {
        if (!this.plugin.achievementsHandler.isEnabled) {
            return;
        }
        for (ChannelDataHolder channelDataHolder : set) {
            this.plugin.achievementsHandler.awardToWeatherSurvivalChannel(channelDataHolder, n, string);
        }
    }

    public void awardPlayersInSet(Set<ChannelDataHolder> set, int n, String string, int n2) {
        if (!this.plugin.achievementsHandler.isEnabled) {
            return;
        }
        for (ChannelDataHolder channelDataHolder : set) {
            this.plugin.achievementsHandler.awardToWeatherSurvivalChannel(channelDataHolder, n, string, n2);
        }
    }

    public void addPlayersToWeatherSurvivalChannel(World world, Set<ChannelDataHolder> set) {
        if (!this.plugin.achievementsHandler.isEnabled) {
            return;
        }
        for (Player player : world.getPlayers()) {
            if (Utils.isPlayerImmune(player)) continue;
            ChannelDataHolder channelDataHolder = new ChannelDataHolder(player);
            channelDataHolder.setWorld(world);
            set.add(channelDataHolder);
            this.plugin.achievementsHandler.addToWeatherSurvivalChannel(channelDataHolder);
        }
    }

    public void removePlayersFromWeatherSurvivalChannel(Set<ChannelDataHolder> set) {
        for (ChannelDataHolder channelDataHolder : set) {
            this.plugin.achievementsHandler.removeFromWeatherSurvivalChannel(channelDataHolder);
        }
    }

    public Disaster getType() {
        return this.type;
    }

    public World getWorld() {
        return this.world;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public boolean isRegionWeatherEffects() {
        return this.RegionWeather;
    }

    public void setRegionWeatherEffects(boolean bl) {
        this.RegionWeather = bl;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double d) {
        this.volume = d;
    }

    public abstract void clear();

    public abstract void start(World var1, Player var2, boolean var3);

    public void updateWeatherSettings() {
        this.RegionWeather = (Boolean)WorldObject.findWorldObject((World)this.world).settings.get("ignore_weather_effects_in_regions");
    }

    public void createTimedStart(int n, final World world, final Player player) {
        this.world = world;
        currentWorlds.add(world);
        this.inputPlayerToMap(n, player);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                currentWorlds.remove(world);
                WorldObject worldObject = WorldObject.findWorldObject(world);
                if (Utils.isPlayerImmune(player) || !worldObject.naturalAllowed || !worldObject.allowed.contains((Object)WeatherDisaster.this.type)) {
                    return;
                }
                WeatherDisaster.this.start(world, player, true);
                Metrics.incrementValue(Metrics.disasterOccurredMap, WeatherDisaster.this.type.getMetricsLabel());
            }
        }, (long)(n * 20 - this.delay));
    }
}

