/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class BlackPlague
extends WeatherDisaster {
    private static BukkitTask id;
    private Random rand;
    private List<EntityType> priorities = new ArrayList<EntityType>();
    private int range = 50;
    private Set<EntityType> blacklisted = new HashSet<EntityType>();
    public static Map<UUID, Integer> time;
    public static int maxInfectedMobs;
    private static Set<UUID> infectedPlayers;

    static {
        time = new HashMap<UUID, Integer>();
        infectedPlayers = new HashSet<UUID>();
    }

    public BlackPlague(int n) {
        super(n);
        if (maxInfectedMobs == 0) {
            maxInfectedMobs = this.configFile.getInt("plague.max_infected_mobs");
        }
        this.rand = this.plugin.random;
        HashSet<String> hashSet = new HashSet<String>();
        EntityType[] entityTypeArray = EntityType.values();
        int n2 = entityTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object = entityTypeArray[n3];
            hashSet.add(object.toString());
            ++n3;
        }
        for (Object object : this.configFile.getStringList("plague.blacklisted_mobs")) {
            if (hashSet.contains(((String)object).toUpperCase())) {
                this.blacklisted.add(EntityType.valueOf((String)((String)object).toUpperCase()));
                continue;
            }
            if (!this.plugin.debug) continue;
            Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: Unreconized entity &d'" + (String)object + "' &ein config under \nplague:\n    blacklisted_mobs:\n        " + (String)object));
        }
        this.priorities.addAll(Arrays.asList(EntityType.VILLAGER, EntityType.ZOMBIE));
        if (this.plugin.mcVersion >= 1.14) {
            this.priorities.add(EntityType.WANDERING_TRADER);
        }
        this.type = Disaster.PLAGUE;
    }

    @Override
    public void start(final World world, final Player player, boolean bl) {
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            String string = Utils.chat(this.configFile.getString("messages.misc.plague.started"));
            if (this.configFile.getBoolean("messages.disaster_tips")) {
                string = String.valueOf(string) + "\n" + this.type.getTip();
            }
            for (Player player2 : world.getPlayers()) {
                player2.sendMessage(string);
            }
            Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + string + ChatColor.GREEN + " (" + world.getName() + ")");
        }
        this.infectRandomMobs(1, world);
        if (id == null) {
            this.createTask();
        }
        if (player != null) {
            this.infectNearTarget((LivingEntity)player, 50.0, 15.0, 50.0, this.priorities.get(this.rand.nextInt(this.priorities.size())));
            new RepeatingTask(this.plugin, 200, this.rand.nextInt(800) + 200){

                @Override
                public void run() {
                    if (player.getWorld() == world) {
                        BlackPlague.this.infectNearTarget((LivingEntity)player, BlackPlague.this.range, 15.0, BlackPlague.this.range, BlackPlague.this.priorities.get(BlackPlague.this.rand.nextInt(BlackPlague.this.priorities.size())));
                    } else {
                        BlackPlague.this.infectRandomMobs(1, world);
                    }
                    BlackPlague.this.range -= 10;
                    --BlackPlague.this.level;
                    if (BlackPlague.this.level <= 0) {
                        this.cancel();
                    }
                }
            };
        } else {
            this.infectRandomMobs(this.level - 1, world);
        }
    }

    private void createTask() {
        final Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)0, (int)0, (int)0), 0.5f);
        id = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (time.isEmpty()) {
                    id.cancel();
                    id = null;
                    return;
                }
                HashMap<UUID, Integer> hashMap = new HashMap<UUID, Integer>();
                Iterator<Map.Entry<UUID, Integer>> iterator = time.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<UUID, Integer> entry = iterator.next();
                    LivingEntity livingEntity = (LivingEntity)Bukkit.getEntity((UUID)entry.getKey());
                    if (livingEntity == null || livingEntity.isDead()) {
                        if (livingEntity == null && infectedPlayers.contains(entry.getKey())) continue;
                        if (livingEntity != null && livingEntity.hasMetadata("dd-plague")) {
                            livingEntity.removeMetadata("dd-plague", (Plugin)BlackPlague.this.plugin);
                        }
                        iterator.remove();
                        continue;
                    }
                    int n = entry.getValue();
                    if (n <= 0) {
                        livingEntity.damage(0.001);
                        livingEntity.setHealth(0.0);
                        livingEntity.setMetadata("dd-plaguedeath", (MetadataValue)new FixedMetadataValue((Plugin)BlackPlague.this.plugin, (Object)"protected"));
                        infectedPlayers.remove(livingEntity.getUniqueId());
                        iterator.remove();
                        continue;
                    }
                    if (WorldObject.findWorldObject((World)livingEntity.getWorld()).curePlagueInRegions && Utils.isZoneProtected(livingEntity.getLocation())) {
                        livingEntity.removeMetadata("dd-plague", (Plugin)BlackPlague.this.plugin);
                        infectedPlayers.remove(livingEntity.getUniqueId());
                        iterator.remove();
                        continue;
                    }
                    livingEntity.getWorld().spawnParticle(Particle.REDSTONE, livingEntity.getLocation().clone().add(0.0, livingEntity.getHeight() / 2.0, 0.0), 8, 0.4, livingEntity.getHeight() / 4.0, 0.4, 1.0, (Object)dustOptions);
                    if (n <= 250) {
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 40, 1, true, false));
                    }
                    if (n <= 200) {
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 40, 3, true, false));
                    }
                    if (n <= 150) {
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 40, 2, true, false));
                    }
                    if (n <= 100) {
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 40, 2, true));
                    }
                    if (n <= 60) {
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 100, 1, true));
                    }
                    if (n <= 20) {
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 40, 2, true));
                    }
                    if (n <= 150 && livingEntity instanceof Player && BlackPlague.this.rand.nextInt(4) == 0) {
                        ((Player)livingEntity).playSound(livingEntity.getLocation(), Sound.ENTITY_HORSE_BREATHE, 0.3f, 0.5f);
                    }
                    if (time.size() < maxInfectedMobs) {
                        for (Entity entity : livingEntity.getNearbyEntities(1.0, 1.0, 1.0)) {
                            if (!(entity instanceof LivingEntity) || entity.isDead() || BlackPlague.this.blacklisted.contains(entity.getType()) || entity.hasMetadata("dd-plague")) continue;
                            if (entity instanceof Player) {
                                if (Utils.isPlayerImmune((Player)entity)) continue;
                                ((Player)entity).sendMessage(Utils.chat("&c" + Languages.getString("misc.plagueCatch")));
                                infectedPlayers.add(entity.getUniqueId());
                            }
                            hashMap.put(entity.getUniqueId(), 300);
                            entity.setMetadata("dd-plague", (MetadataValue)new FixedMetadataValue((Plugin)BlackPlague.this.plugin, (Object)"protected"));
                        }
                    }
                    time.replace(livingEntity.getUniqueId(), n - 1);
                }
                time.putAll(hashMap);
            }
        }, 0L, 20L);
    }

    public boolean isMobAvailable(World world) {
        for (LivingEntity livingEntity : world.getLivingEntities()) {
            if (this.blacklisted.contains(livingEntity.getType()) || livingEntity.hasMetadata("dd-plague") || livingEntity instanceof Player || livingEntity.isInvulnerable() || this.plugin.RegionProtection && Utils.isZoneProtected(livingEntity.getLocation())) continue;
            return true;
        }
        return false;
    }

    public void infectNearTarget(LivingEntity livingEntity, double d, double d2, double d3, EntityType entityType) {
        ArrayList<LivingEntity> arrayList = new ArrayList<LivingEntity>();
        for (Entity entity2 : livingEntity.getNearbyEntities(d, d2, d3)) {
            if (!(entity2 instanceof LivingEntity) || entity2 instanceof Player || this.blacklisted.contains(entity2.getType()) || entity2.hasMetadata("dd-plague")) continue;
            arrayList.add((LivingEntity)entity2);
        }
        for (LivingEntity livingEntity2 : arrayList) {
            if (livingEntity2.getType() != entityType) continue;
            time.put(livingEntity2.getUniqueId(), 300);
            livingEntity2.setMetadata("dd-plague", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
            return;
        }
        if (arrayList.isEmpty()) {
            this.infectRandomMobs(1, this.world);
            return;
        }
        LivingEntity livingEntity3 = (LivingEntity)arrayList.get(this.rand.nextInt(arrayList.size()));
        time.put(livingEntity3.getUniqueId(), 300);
        livingEntity3.setMetadata("dd-plague", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
    }

    public void infectRandomMobs(int n, World world) {
        for (LivingEntity livingEntity : world.getLivingEntities()) {
            if (this.blacklisted.contains(livingEntity.getType()) || livingEntity.hasMetadata("dd-plague") || livingEntity instanceof Player || livingEntity.isInvulnerable() || this.plugin.RegionProtection && Utils.isZoneProtected(livingEntity.getLocation())) continue;
            time.put(livingEntity.getUniqueId(), 300);
            livingEntity.setMetadata("dd-plague", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
            livingEntity.setRemoveWhenFarAway(false);
            if (--n > 0) continue;
            return;
        }
    }

    public static void infect(LivingEntity livingEntity) {
        time.put(livingEntity.getUniqueId(), 300);
        livingEntity.setMetadata("dd-plague", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)"protected"));
        livingEntity.setRemoveWhenFarAway(false);
        if (livingEntity instanceof Player) {
            infectedPlayers.add(livingEntity.getUniqueId());
        }
    }

    public static void cureEntity(LivingEntity livingEntity) {
        time.remove(livingEntity.getUniqueId());
        livingEntity.removeMetadata("dd-plague", (Plugin)Main.getInstance());
        if (livingEntity instanceof Player) {
            infectedPlayers.remove(livingEntity.getUniqueId());
        }
    }

    @Override
    public void clear() {
        for (Map.Entry<UUID, Integer> entry : time.entrySet()) {
            if (Bukkit.getEntity((UUID)entry.getKey()) == null) continue;
            Bukkit.getEntity((UUID)entry.getKey()).removeMetadata("dd-plague", (Plugin)this.plugin);
        }
        time.clear();
        infectedPlayers.clear();
    }

    public void setPriorities(List<EntityType> list) {
        this.priorities = list;
    }
}

