/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.entities.snowstormentities.Yeti;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.handlers.DifficultyLevel;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.SeasonsHandler;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.BlockRegenHandler;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import me.casperge.realisticseasons.api.SeasonsAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class Blizzard
extends WeatherDisaster {
    private boolean freeze;
    private boolean leather;
    private boolean seasonsAllowed;
    private boolean despawnEntities;
    private int minTemp;
    private int freezeHeight;
    private int particleRange;
    private int particleYRange;
    private double damage;
    private double particleMultiplier;
    private Queue<UUID> entities = new ArrayDeque<UUID>();
    private Map<UUID, UUID> targets = new HashMap<UUID, UUID>();
    private SeasonsAPI seasons;

    public Blizzard(int n) {
        super(n);
        this.freeze = this.configFile.getBoolean("blizzard.freeze_entities");
        this.despawnEntities = this.configFile.getBoolean("blizzard.despawn_frozen_entities");
        this.leather = this.configFile.getBoolean("blizzard.leather_armor_protection");
        this.time = this.configFile.getInt("blizzard.time.level " + this.level) * 20;
        this.delay = this.configFile.getInt("blizzard.start_delay") * 20;
        this.damage = this.configFile.getDouble("blizzard.damage");
        this.freezeHeight = this.configFile.getInt("blizzard.min_freezing_height");
        if (this.damage < 0.0) {
            this.damage = 0.0;
        }
        this.seasonsAllowed = this.plugin.seasonsHandler.isActive;
        if (this.seasonsAllowed) {
            this.seasons = SeasonsHandler.getSeasonsAPI();
            this.minTemp = this.plugin.seasonsHandler.blizzTemp;
        }
        this.volume = this.configFile.getDouble("blizzard.volume");
        this.particleRange = this.configFile.getInt("blizzard.particle_max_distance");
        this.particleYRange = this.configFile.getInt("blizzard.particle_Y_range");
        this.particleMultiplier = 1.0 * this.configFile.getDouble("blizzard.particle_multiplier");
        this.type = Disaster.BLIZZARD;
    }

    @Override
    public void start(final World world, Player player, boolean bl) {
        BukkitTask[] bukkitTaskArray;
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        ongoingDisasters.add(this);
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            Utils.broadcastEvent(this.level, "weather", this.type, world);
        }
        DeathMessages.blizzards.add(this);
        final Blizzard blizzard = this;
        final int[] nArray = new int[1];
        final Random random = this.plugin.random;
        final double d = this.configFile.getDouble("blizzard.mob_spawn_rate");
        final EntityHandler entityHandler = this.plugin.handler;
        final String string = ChatColor.GRAY + Languages.getString("misc.yetiBlessing");
        final NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, "dd-frozen-mob");
        new RepeatingTask(this.plugin, this.delay, 5){

            @Override
            public void run() {
                if (Blizzard.this.time <= 0) {
                    this.cancel();
                    DeathMessages.blizzards.remove(blizzard);
                    ongoingDisasters.remove(blizzard);
                    Blizzard.this.clearEntities();
                    Blizzard.this.triggerRegen(true);
                    return;
                }
                Blizzard blizzard2 = Blizzard.this;
                blizzard2.time = blizzard2.time - 5;
                for (LivingEntity livingEntity : world.getLivingEntities()) {
                    int n;
                    if (Blizzard.this.entities.contains(livingEntity.getUniqueId()) && ((Mob)livingEntity).getTarget() == null && Bukkit.getEntity((UUID)Blizzard.this.targets.get(livingEntity.getUniqueId())) != null) {
                        ((Mob)livingEntity).setTarget((LivingEntity)Bukkit.getEntity((UUID)Blizzard.this.targets.get(livingEntity.getUniqueId())));
                    }
                    if (livingEntity.hasMetadata("dd-yeti") || !(!Blizzard.this.seasonsAllowed && livingEntity.getLocation().getBlock().getTemperature() <= 0.15) && (!Blizzard.this.seasonsAllowed || !(livingEntity instanceof Player) || Blizzard.this.seasons.getTemperature((Player)livingEntity) > Blizzard.this.minTemp) || Utils.isWeatherDisabled(livingEntity.getLocation(), blizzard)) continue;
                    Block block = livingEntity.getLocation().getBlock();
                    if (block.getLightFromBlocks() >= 13) {
                        Location location = livingEntity.getLocation();
                        n = location.getBlockX();
                        int n2 = location.getBlockY();
                        int n3 = location.getBlockZ();
                        int n4 = n - 1;
                        while (n4 < n + 1) {
                            int n5 = n2 - 1;
                            while (n5 < n2 + 1) {
                                int n6 = n3 - 1;
                                while (n6 < n3 + 1) {
                                    location.setX((double)n4);
                                    location.setY((double)n5);
                                    location.setZ((double)n6);
                                    block = location.getBlock();
                                    if (block.getType() == Material.TORCH || block.getType() == Material.WALL_TORCH) {
                                        if (Blizzard.this.plugin.CProtect) {
                                            Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                        }
                                        Blizzard.this.addBlockToList(block, block.getState());
                                        block.setType(Material.AIR);
                                        ItemStack itemStack = new ItemStack(Material.STICK, 1);
                                        world.dropItem(block.getLocation(), itemStack);
                                    }
                                    ++n6;
                                }
                                ++n5;
                            }
                            ++n4;
                        }
                        continue;
                    }
                    if (livingEntity instanceof Player && CustomEntityType.YETI.canSpawn()) {
                        if (Utils.isPlayerImmune((Player)livingEntity)) continue;
                        if (nArray[0] == 40 && random.nextDouble() * 100.0 < d) {
                            int n7 = 0;
                            while (n7 < 5) {
                                n = 13;
                                int n8 = 13;
                                int n9 = random.nextInt(15) - 7;
                                if (random.nextInt(2) == 0) {
                                    n *= -1;
                                }
                                if (random.nextInt(2) == 0) {
                                    n8 *= -1;
                                }
                                if (random.nextInt(2) == 0) {
                                    n += n9;
                                } else {
                                    n8 += n9;
                                }
                                Location location = Utils.findSmartYSpawn(livingEntity.getLocation(), livingEntity.getLocation().clone().add((double)n, 0.0, (double)n8), 3, 20);
                                if (location != null) {
                                    Mob mob = (Mob)location.getWorld().spawnEntity(location, EntityType.IRON_GOLEM);
                                    entityHandler.addEntity(new Yeti(mob, Blizzard.this.plugin, random));
                                    mob.setTarget(livingEntity);
                                    Blizzard.this.entities.add(mob.getUniqueId());
                                    Blizzard.this.targets.put(mob.getUniqueId(), livingEntity.getUniqueId());
                                    break;
                                }
                                ++n7;
                            }
                        }
                    }
                    livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 20, 2, true, false));
                    if (livingEntity.getType() == EntityType.STRAY || livingEntity.getType() == EntityType.POLAR_BEAR) continue;
                    double d2 = Blizzard.this.damage;
                    if (Blizzard.this.leather) {
                        ItemStack[] itemStackArray = livingEntity.getEquipment().getArmorContents();
                        if (itemStackArray[0] != null && itemStackArray[0].getType() == Material.LEATHER_BOOTS) {
                            d2 -= Blizzard.this.damage / 4.0;
                        }
                        if (itemStackArray[1] != null && itemStackArray[1].getType() == Material.LEATHER_LEGGINGS) {
                            d2 -= Blizzard.this.damage / 4.0;
                        }
                        if (itemStackArray[2] != null) {
                            int n10;
                            if (itemStackArray[2].getType() == Material.LEATHER_CHESTPLATE) {
                                d2 -= Blizzard.this.damage / 4.0;
                            }
                            if ((n10 = Utils.levelOfEnchant(string, itemStackArray[2])) > 0) {
                                d2 -= Blizzard.this.damage / 4.0 * (double)(n10 + 1);
                            }
                        }
                        if (itemStackArray[3] != null && itemStackArray[3].getType() == Material.LEATHER_HELMET) {
                            d2 -= Blizzard.this.damage / 4.0;
                        }
                        if (d2 <= 0.0) continue;
                    }
                    if (!livingEntity.isInvulnerable()) {
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 20, 0, true, false));
                        Utils.pureDamageEntity(livingEntity, d2, "dd-blizzarddeath", false, null);
                    } else {
                        livingEntity.removePotionEffect(PotionEffectType.WITHER);
                    }
                    if (!(livingEntity.getHealth() <= 10.0)) continue;
                    if (livingEntity instanceof Player) {
                        Utils.pureDamageEntity(livingEntity, d2, "dd-blizzarddeath", false, null);
                        continue;
                    }
                    if (!Blizzard.this.freeze || livingEntity.isInvulnerable() || livingEntity.getLocation().getBlockY() < Blizzard.this.freezeHeight) continue;
                    livingEntity.setAI(false);
                    livingEntity.setInvulnerable(true);
                    livingEntity.setSilent(true);
                    if (livingEntity.getRemoveWhenFarAway()) {
                        livingEntity.getPersistentDataContainer().set(namespacedKey, PersistentDataType.BYTE, (Object)0);
                    } else {
                        livingEntity.getPersistentDataContainer().set(namespacedKey, PersistentDataType.BYTE, (Object)1);
                    }
                    if (!Blizzard.this.despawnEntities) {
                        livingEntity.setRemoveWhenFarAway(false);
                    }
                    Location location = new Location(livingEntity.getWorld(), (double)livingEntity.getLocation().getBlockX() + 0.5, (double)livingEntity.getLocation().getBlockY(), (double)livingEntity.getLocation().getBlockZ() + 0.5);
                    livingEntity.teleport(location);
                    Block block2 = livingEntity.getLocation().getBlock();
                    int n11 = 0;
                    while ((double)n11 < livingEntity.getHeight()) {
                        if (!Utils.passStrengthTest(block2.getType())) {
                            if (Blizzard.this.plugin.CProtect) {
                                Utils.getCoreProtect().logPlacement("Deadly-Disasters", block2.getLocation(), Material.ICE, block2.getBlockData());
                            }
                            Blizzard.this.addBlockToList(block2, block2.getState());
                            block2.setType(Material.ICE);
                        }
                        block2 = block2.getRelative(BlockFace.UP);
                        ++n11;
                    }
                }
                if (!world.hasStorm()) {
                    world.setStorm(true);
                }
                if (nArray[0] >= 40) {
                    nArray[0] = 0;
                }
                nArray[0] = nArray[0] + 1;
            }
        };
        bukkitTaskArray = new BukkitTask[]{this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (Blizzard.this.time <= 0) {
                    bukkitTaskArray[0].cancel();
                    return;
                }
                for (Player player : world.getPlayers()) {
                    if (!player.getWorld().equals(world)) continue;
                    Location location = null;
                    int n = -Blizzard.this.particleRange;
                    while (n <= Blizzard.this.particleRange) {
                        int n2 = -Blizzard.this.particleRange;
                        while (n2 <= Blizzard.this.particleRange) {
                            if (!(random.nextDouble() >= Blizzard.this.particleMultiplier)) {
                                int n3;
                                Location location2 = player.getLocation().add((double)n, 0.0, (double)n2);
                                Location location3 = world.getHighestBlockAt(location2).getLocation();
                                if (!(!Blizzard.this.seasonsAllowed && location3.getBlock().getTemperature() > 0.15 || Utils.isWeatherDisabled(location3, blizzard) || (n3 = location3.getBlockY() - location2.getBlockY()) > Blizzard.this.particleYRange)) {
                                    if (n == Blizzard.this.particleRange || n == -Blizzard.this.particleRange || n2 == Blizzard.this.particleRange || n2 == -Blizzard.this.particleRange) {
                                        player.spawnParticle(Particle.CLOUD, location3.add(0.5, 3.0, 0.5), 2, 0.5, 0.7, 0.5, 0.05);
                                    } else {
                                        if (n3 < 0) {
                                            location3.setY(location3.getY() + (double)(n3 * -1));
                                        }
                                        if (location == null || location3.distanceSquared(player.getLocation()) < location.distanceSquared(player.getLocation())) {
                                            location = location3;
                                        }
                                        if (n3 > 0) {
                                            player.spawnParticle(Particle.CLOUD, location3.add(0.5, 3.0, 0.5), 2, 0.5, 0.7, 0.5, 0.05);
                                        } else {
                                            int n4 = 0;
                                            while (n4 < 2) {
                                                player.spawnParticle(Particle.CLOUD, location3.add(random.nextDouble(), 3.0 + random.nextDouble() * 2.0, random.nextDouble()), 0, random.nextDouble() / 2.5 - 0.2, -(random.nextDouble() / 0.6), random.nextDouble() / 2.5 - 0.2);
                                                ++n4;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    if (location == null) continue;
                    player.playSound(location, Sound.WEATHER_RAIN_ABOVE, (float)(0.75 * Blizzard.this.volume), 0.5f);
                }
            }
        }, (long)this.delay, 1L)};
    }

    @Override
    public void clear() {
        this.time = 0;
        this.clearEntities();
    }

    public void clearEntities() {
        for (UUID uUID : this.entities) {
            if (Bukkit.getEntity((UUID)uUID) == null) continue;
            Bukkit.getEntity((UUID)uUID).remove();
        }
    }

    @Override
    public void triggerRegen(boolean bl) {
        RepeatingTask[] repeatingTaskArray;
        if (WorldObject.findWorldObject((World)this.world).difficulty != DifficultyLevel.CUSTOM || (Integer)WorldObject.findWorldObject((World)this.world).settings.get("regenDelay") < 0) {
            return;
        }
        this.UUIDToFalling.forEach((uUID, block) -> {
            if (Bukkit.getEntity((UUID)uUID) != null) {
                Bukkit.getEntity((UUID)uUID).remove();
            }
        });
        regeneratingDisasters.add(this);
        final Blizzard blizzard = this;
        if (bl) {
            this.reverseList();
        }
        this.damagedBlocks.putAll(this.physicBlocks);
        final double d = this.type.getDefaultRegenTickRate() * this.configFile.getDouble(String.valueOf(this.type.name().toLowerCase()) + ".regen_rate");
        final double[] dArray = new double[]{0.0};
        final HashMap hashMap = new HashMap();
        repeatingTaskArray = new RepeatingTask[]{new RepeatingTask(this.plugin, (Integer)WorldObject.findWorldObject((World)this.world).settings.get("regenDelay") * 20, 1){

            @Override
            public void run() {
                dArray[0] = dArray[0] + d;
                while (dArray[0] >= 1.0) {
                    dArray[0] = dArray[0] - 1.0;
                    if (Blizzard.this.damagedBlocks.isEmpty()) {
                        this.cancel();
                        regeneratingTasks.remove(repeatingTaskArray[0]);
                        regeneratingDisasters.remove(blizzard);
                        BlockRegenHandler.gravityHold.removeAll(Blizzard.this.gravityHoldBlocks);
                        break;
                    }
                    try {
                        Object object;
                        Map.Entry entry = Blizzard.this.damagedBlocks.entrySet().iterator().next();
                        Block block = (Block)entry.getKey();
                        Iterator iterator = Blizzard.this.blockToBlock.entrySet().iterator();
                        while (iterator.hasNext()) {
                            object = iterator.next();
                            if (((Block)object.getKey()).equals(block)) {
                                Block block2 = (Block)object.getValue();
                                if (block.equals(block2)) {
                                    iterator.remove();
                                    break;
                                }
                                if (block2.getState() instanceof InventoryHolder) {
                                    ItemStack[] itemStackArray = ((InventoryHolder)block2.getState()).getInventory().getContents();
                                    Blizzard.this.plugin.getServer().getScheduler().runTaskLater((Plugin)Blizzard.this.plugin, () -> ((InventoryHolder)block.getState()).getInventory().setContents(itemStackArray), 7L);
                                }
                                block2.setType(Material.AIR);
                                iterator.remove();
                                while (iterator.hasNext()) {
                                    object = iterator.next();
                                    if (!((Block)object.getValue()).equals(block)) continue;
                                    if (block.getState() instanceof InventoryHolder) {
                                        hashMap.put((Block)object.getKey(), ((InventoryHolder)block.getState()).getInventory().getContents());
                                    }
                                    iterator.remove();
                                }
                                break;
                            }
                            if (!((Block)object.getValue()).equals(block)) continue;
                            if (block.getState() instanceof InventoryHolder) {
                                hashMap.put((Block)object.getKey(), ((InventoryHolder)block.getState()).getInventory().getContents());
                            }
                            iterator.remove();
                        }
                        if (Utils.isMaterialGravity(((BlockState)entry.getValue()).getType())) {
                            Blizzard.this.gravityHoldBlocks.add(block);
                            BlockRegenHandler.gravityHold.add(block);
                        }
                        if (block.getType() == Material.ICE) {
                            object = new BlockBreakEvent(block, null);
                            Bukkit.getPluginManager().callEvent((Event)object);
                            block.getWorld().spawnParticle(Particle.BLOCK_CRACK, block.getLocation().clone().add(0.5, 0.5, 0.5), 10, 0.3, 0.3, 0.3, 0.01, (Object)Material.ICE.createBlockData());
                            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_GLASS_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                        ((BlockState)entry.getValue()).update(true);
                        if (hashMap.containsKey(block)) {
                            Blizzard.this.plugin.getServer().getScheduler().runTaskLater((Plugin)Blizzard.this.plugin, () -> ((InventoryHolder)block.getState()).getInventory().setContents((ItemStack[])hashMap.get(block)), 7L);
                        }
                        Blizzard.this.damagedBlocks.remove(block);
                        disasterBlocks.remove(block);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Utils.sendDebugMessage();
                    }
                }
            }
        }};
        regeneratingTasks.put(repeatingTaskArray[0], blizzard);
    }

    public boolean canMobsFreeze() {
        return this.freeze;
    }

    public void setMobsFreeze(boolean bl) {
        this.freeze = bl;
    }

    public boolean canLeatherProtect() {
        return this.leather;
    }

    public void setLeatherProtect(boolean bl) {
        this.leather = bl;
    }

    public static void refreshFrozen(Main main) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)main, "dd-frozen-mob");
        for (World world : Bukkit.getWorlds()) {
            if (world.getEnvironment() != World.Environment.NORMAL) continue;
            for (LivingEntity livingEntity : world.getLivingEntities()) {
                if (!livingEntity.getPersistentDataContainer().has(namespacedKey, PersistentDataType.BYTE) || livingEntity.getLocation().add(0.0, Math.max(0.0, livingEntity.getHeight() - 0.5), 0.0).getBlock().getType() == Material.ICE) continue;
                livingEntity.setInvulnerable(false);
                livingEntity.setAI(true);
                if ((Byte)livingEntity.getPersistentDataContainer().get(namespacedKey, PersistentDataType.BYTE) == 0) {
                    livingEntity.setRemoveWhenFarAway(true);
                }
                livingEntity.getPersistentDataContainer().remove(namespacedKey);
                livingEntity.setSilent(false);
            }
        }
    }

    public static void breakIce(final Block block, Main main) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)main, "dd-frozen-mob");
        for (Entity entity : block.getWorld().getNearbyEntities(block.getLocation().clone().add(0.5, 0.5, 0.5), 0.5, 1.25, 0.5)) {
            if (!(entity instanceof LivingEntity) || !entity.getPersistentDataContainer().has(namespacedKey, PersistentDataType.BYTE) || entity.getHeight() > 1.0 && entity.getLocation().add(0.0, 1.0, 0.0).getBlock().getType().equals((Object)Material.ICE) && !entity.getLocation().add(0.0, 1.0, 0.0).getBlock().equals(block)) continue;
            entity.setInvulnerable(false);
            ((LivingEntity)entity).setAI(true);
            if ((Byte)entity.getPersistentDataContainer().get(namespacedKey, PersistentDataType.BYTE) == 0) {
                ((LivingEntity)entity).setRemoveWhenFarAway(true);
            }
            entity.getPersistentDataContainer().remove(namespacedKey);
            entity.setSilent(false);
            main.getServer().getScheduler().runTaskLater((Plugin)main, new Runnable(){

                @Override
                public void run() {
                    if (block.getType() == Material.WATER) {
                        block.setType(Material.AIR);
                    }
                }
            }, 1L);
            return;
        }
    }
}

