/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.disasters.CaveInBlock;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class CaveIn
extends DestructionDisaster {
    private Queue<CaveInBlock> placements = new ArrayDeque<CaveInBlock>();
    public Iterator<CaveInBlock> iterator;
    private int radius;
    private int depth;
    private int maxOffset;
    private int maxBlocks;
    private BlockData[] materials;
    private double fallSpeed = -0.5;
    private double size;
    private double damage;
    public int blocksDestroyed;
    public Queue<UUID> fallingRoof = new ArrayDeque<UUID>();

    public CaveIn(int n) {
        super(n);
        switch (n) {
            default: {
                this.radius = 9;
                this.depth = 1;
                this.maxOffset = 6;
                break;
            }
            case 2: {
                this.radius = 13;
                this.depth = 2;
                this.maxOffset = 8;
                break;
            }
            case 3: {
                this.radius = 18;
                this.depth = 3;
                this.maxOffset = 10;
                break;
            }
            case 4: {
                this.radius = 23;
                this.depth = 4;
                this.maxOffset = 12;
                break;
            }
            case 5: {
                this.radius = 30;
                this.depth = 5;
                this.maxOffset = 15;
                break;
            }
            case 6: {
                this.radius = 50;
                this.depth = 6;
                this.maxOffset = 25;
            }
        }
        this.size = this.configFile.getDouble("cavein.size");
        this.radius = (int)((double)this.radius * this.size);
        this.damage = this.configFile.getDouble("cavein.damage");
        this.maxBlocks = this.configFile.getInt("cavein.max_falling_blocks");
        this.volume = this.configFile.getDouble("cavein.volume");
        this.type = Disaster.CAVEIN;
    }

    @Override
    public void start(final Location location, Player player) {
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, location, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        ongoingDisasters.add(this);
        this.loc = location;
        DeathMessages.caveins.add(this);
        final CaveIn caveIn = this;
        final Random random = this.plugin.random;
        final int[] nArray = new int[]{1};
        final BlockVector blockVector = new BlockVector(location.getX(), location.getY(), location.getZ());
        final World world = location.getWorld();
        this.addPlayersToSurvivalChannel(location.clone().subtract(0.0, (double)this.radius, 0.0), this.radius, this.survivingPlayers);
        new RepeatingTask(this.plugin, 0, 5){

            @Override
            public void run() {
                if (nArray[0] <= CaveIn.this.radius) {
                    int n = -nArray[0];
                    while (n < nArray[0]) {
                        int n2 = -nArray[0];
                        while (n2 < nArray[0]) {
                            Vector vector = blockVector.clone().add(new Vector(n, 0, n2));
                            Block block = world.getBlockAt(vector.toLocation(world));
                            if (blockVector.distance(vector) >= (double)(nArray[0] - 1) && blockVector.distance(vector) <= (double)nArray[0]) {
                                int n3;
                                if (block.getType().isSolid()) {
                                    n3 = 0;
                                    while (n3 < CaveIn.this.maxOffset) {
                                        if (!(block = block.getRelative(BlockFace.DOWN)).getType().isSolid()) {
                                            CaveIn.this.placements.add(new CaveInBlock(block.getRelative(BlockFace.UP).getLocation(), CaveIn.this.depth, caveIn));
                                            break;
                                        }
                                        ++n3;
                                    }
                                } else {
                                    n3 = 0;
                                    while (n3 < CaveIn.this.maxOffset) {
                                        if ((block = block.getRelative(BlockFace.UP)).getType().isSolid()) {
                                            CaveIn.this.placements.add(new CaveInBlock(block.getLocation(), CaveIn.this.depth, caveIn));
                                            break;
                                        }
                                        ++n3;
                                    }
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    nArray[0] = nArray[0] + 1;
                    for (Entity entity : location.getWorld().getNearbyEntities(location.clone().subtract(0.0, 10.0, 0.0), (double)(nArray[0] + 10), 25.0, (double)(nArray[0] + 10))) {
                        if (!(entity instanceof Player)) continue;
                        ((Player)entity).playSound(entity.getLocation(), Sound.ENTITY_WITHER_BREAK_BLOCK, (float)(0.075 * CaveIn.this.volume), (float)(random.nextDouble() + 0.5));
                    }
                }
                CaveIn.this.iterator = CaveIn.this.placements.iterator();
                while (CaveIn.this.iterator.hasNext()) {
                    if (CaveIn.this.fallingRoof.size() >= CaveIn.this.maxBlocks) break;
                    BlockData blockData = null;
                    if (CaveIn.this.materials != null) {
                        blockData = CaveIn.this.materials[random.nextInt(CaveIn.this.materials.length)];
                    }
                    CaveIn.this.iterator.next().fall(blockData, CaveIn.this.fallSpeed);
                }
                if (CaveIn.this.placements.isEmpty()) {
                    CaveIn.this.plugin.getServer().getScheduler().runTaskLater((Plugin)CaveIn.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            DeathMessages.caveins.remove(caveIn);
                            CaveIn.this.awardPlayersInSet(CaveIn.this.survivingPlayers, 1, "disasters.survival.cavein");
                            if ((this).CaveIn.this.level >= 6) {
                                CaveIn.this.awardPlayersInSet(CaveIn.this.survivingPlayers, 1, "disasters.survival.level_six", 3);
                            }
                            CaveIn.this.removePlayersFromSurvivalChannel(CaveIn.this.survivingPlayers);
                        }
                    }, 200L);
                    this.cancel();
                    CaveIn.this.triggerRegen(true);
                    ongoingDisasters.remove(caveIn);
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, CaveIn.this.type.getMetricsLabel(), CaveIn.this.blocksDestroyed);
                }
            }
        };
        new RepeatingTask(this.plugin, 0, 2){

            @Override
            public void run() {
                if (CaveIn.this.placements.isEmpty() && CaveIn.this.fallingRoof.isEmpty()) {
                    this.cancel();
                    return;
                }
                Iterator iterator = CaveIn.this.fallingRoof.iterator();
                while (iterator.hasNext()) {
                    FallingBlock fallingBlock = (FallingBlock)Bukkit.getEntity((UUID)((UUID)iterator.next()));
                    if (fallingBlock == null || fallingBlock.isDead()) {
                        iterator.remove();
                        continue;
                    }
                    for (Entity entity : world.getNearbyEntities(fallingBlock.getLocation().add(0.5, 0.5, 0.5), 0.5, 0.5, 0.5)) {
                        if (!(entity instanceof LivingEntity) || ((LivingEntity)entity).getNoDamageTicks() > 0) continue;
                        if (entity instanceof Player) {
                            if (Utils.isPlayerImmune((Player)entity)) continue;
                            if (CaveIn.this.plugin.achievementsHandler.isMasteryActive(entity.getUniqueId(), "disasters.survival.cavein")) {
                                Utils.damageEntity((LivingEntity)entity, CaveIn.this.damage - CaveIn.this.damage / 100.0 * CaveIn.this.plugin.achievementsHandler.getMasteryPower(entity.getUniqueId(), "disasters.survival.cavein"), "dd-caveincrush", false);
                                continue;
                            }
                        }
                        Utils.damageEntity((LivingEntity)entity, CaveIn.this.damage, "dd-caveincrush", false);
                    }
                }
            }
        };
        for (Entity entity : location.getWorld().getNearbyEntities(location.clone().subtract(0.0, 10.0, 0.0), (double)(this.radius + 15), 20.0, (double)(this.radius + 15))) {
            if (!(entity instanceof Player)) continue;
            ((Player)entity).playSound(entity.getLocation(), Sound.ENTITY_WITHER_BREAK_BLOCK, (float)(0.33 * (double)this.level * this.volume), 0.5f);
        }
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if ((location = Utils.getBlockAbove(location).getLocation()).getBlock().getType() == Material.AIR || location.getBlockY() > this.type.getMinHeight() && location.getWorld().getEnvironment() != World.Environment.NETHER) {
            return null;
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(Utils.getBlockAbove(location).getLocation(), player);
    }

    public int getX() {
        return this.loc.getBlockX();
    }

    public int getZ() {
        return this.loc.getBlockZ();
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public BlockData[] getMaterials() {
        return this.materials;
    }

    public void setMaterials(Material[] materialArray) {
        this.materials = new BlockData[materialArray.length];
        int n = 0;
        while (n < materialArray.length) {
            this.materials[n] = materialArray[n].createBlockData();
            ++n;
        }
    }

    public double getFallSpeed() {
        return this.fallSpeed;
    }

    public void setFallSpeed(double d) {
        this.fallSpeed = d;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }
}

